/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.avro;

import org.apache.avro.Schema;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;

public class AvroSchemaValidator
implements Validator {
    public ValidationResult validate(String subject, String input, ValidationContext context) {
        if (context.isExpressionLanguageSupported(subject) && context.isExpressionLanguagePresent(input)) {
            return new ValidationResult.Builder().input(input).subject(subject).valid(true).explanation("Expression Language is present").build();
        }
        try {
            new Schema.Parser().parse(input);
            return new ValidationResult.Builder().valid(true).build();
        }
        catch (Exception e) {
            return new ValidationResult.Builder().input(input).subject(subject).valid(false).explanation("Not a valid Avro Schema: " + e.getMessage()).build();
        }
    }
}

