/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.schema.access;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.schema.access.JsonSchemaAccessStrategy;
import org.apache.nifi.schema.access.SchemaField;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.type.RecordDataType;
import org.codehaus.jackson.map.ObjectMapper;
import sun.misc.IOUtils;

public class InferenceSchemaStrategy
implements JsonSchemaAccessStrategy {
    private final Set<SchemaField> schemaFields = EnumSet.noneOf(SchemaField.class);

    public RecordSchema getSchema(Map<String, String> variables, InputStream contentStream, RecordSchema readSchema) throws SchemaNotFoundException, IOException {
        byte[] bytes = IOUtils.readFully((InputStream)contentStream, (int)-1, (boolean)true);
        ObjectMapper mapper = new ObjectMapper();
        return this.convertSchema((Map)mapper.readValue(bytes, Map.class));
    }

    protected RecordSchema convertSchema(Map<String, Object> result) {
        ArrayList<RecordField> fields = new ArrayList<RecordField>();
        for (Map.Entry<String, Object> entry : result.entrySet()) {
            RecordField field;
            if (entry.getValue() instanceof Integer) {
                field = new RecordField(entry.getKey(), RecordFieldType.INT.getDataType());
            } else if (entry.getValue() instanceof Long) {
                field = new RecordField(entry.getKey(), RecordFieldType.LONG.getDataType());
            } else if (entry.getValue() instanceof Boolean) {
                field = new RecordField(entry.getKey(), RecordFieldType.BOOLEAN.getDataType());
            } else if (entry.getValue() instanceof Double) {
                field = new RecordField(entry.getKey(), RecordFieldType.DOUBLE.getDataType());
            } else if (entry.getValue() instanceof Date) {
                field = new RecordField(entry.getKey(), RecordFieldType.DATE.getDataType());
            } else if (entry.getValue() instanceof List) {
                field = new RecordField(entry.getKey(), RecordFieldType.ARRAY.getDataType());
            } else if (entry.getValue() instanceof Map) {
                RecordSchema nestedSchema = this.convertSchema((Map)entry.getValue());
                RecordDataType rdt = new RecordDataType(nestedSchema);
                field = new RecordField(entry.getKey(), (DataType)rdt);
            } else {
                field = new RecordField(entry.getKey(), RecordFieldType.STRING.getDataType());
            }
            fields.add(field);
        }
        return new SimpleRecordSchema(fields);
    }

    public Set<SchemaField> getSuppliedSchemaFields() {
        return this.schemaFields;
    }

    public RecordSchema getSchema(Map<String, String> variables, Map<String, Object> content, RecordSchema readSchema) throws SchemaNotFoundException, IOException {
        return this.convertSchema(content);
    }
}

