/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.schema.access;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.nifi.avro.AvroTypeUtil;
import org.apache.nifi.schema.access.SchemaAccessWriter;
import org.apache.nifi.schema.access.SchemaField;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.record.RecordSchema;

public class WriteAvroSchemaAttributeStrategy
implements SchemaAccessWriter {
    private final LoadingCache<RecordSchema, String> avroSchemaTextCache = Caffeine.newBuilder().maximumSize(10L).build(schema -> AvroTypeUtil.extractAvroSchema(schema).toString());

    public void writeHeader(RecordSchema schema, OutputStream out) throws IOException {
    }

    public Map<String, String> getAttributes(RecordSchema schema) {
        Optional schemaText;
        Optional schemaFormat = schema.getSchemaFormat();
        if (schemaFormat.isPresent() && "avro".equals(schemaFormat.get()) && (schemaText = schema.getSchemaText()).isPresent()) {
            return Collections.singletonMap("avro.schema", schemaText.get());
        }
        return Collections.singletonMap("avro.schema", this.avroSchemaTextCache.get((Object)schema));
    }

    public void validateSchema(RecordSchema schema) throws SchemaNotFoundException {
    }

    public Set<SchemaField> getRequiredSchemaFields() {
        return EnumSet.noneOf(SchemaField.class);
    }
}

