/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.serialization;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.schema.access.AvroSchemaTextStrategy;
import org.apache.nifi.schema.access.InferenceSchemaStrategy;
import org.apache.nifi.schema.access.JsonSchemaAccessStrategy;
import org.apache.nifi.schema.access.SchemaAccessStrategy;
import org.apache.nifi.schema.access.SchemaAccessUtils;
import org.apache.nifi.schema.access.SchemaNamePropertyStrategy;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.schemaregistry.services.SchemaRegistry;
import org.apache.nifi.serialization.SchemaRegistryService;
import org.apache.nifi.serialization.record.RecordSchema;

public class JsonInferenceSchemaRegistryService
extends SchemaRegistryService {
    private String schemaAccess;

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        this.storeSchemaAccessStrategy(context);
        this.schemaAccess = context.getProperty(this.getSchemaAcessStrategyDescriptor()).getValue();
    }

    @Override
    protected AllowableValue getDefaultSchemaAccessStrategy() {
        return SchemaAccessUtils.INFER_SCHEMA;
    }

    @Override
    protected SchemaAccessStrategy getSchemaAccessStrategy(String strategy, SchemaRegistry schemaRegistry, PropertyContext context) {
        if (strategy == null) {
            return null;
        }
        if (strategy.equalsIgnoreCase(SchemaAccessUtils.SCHEMA_NAME_PROPERTY.getValue())) {
            PropertyValue schemaName = context.getProperty(SchemaAccessUtils.SCHEMA_NAME);
            PropertyValue schemaBranchName = context.getProperty(SchemaAccessUtils.SCHEMA_BRANCH_NAME);
            PropertyValue schemaVersion = context.getProperty(SchemaAccessUtils.SCHEMA_VERSION);
            return new SchemaNamePropertyStrategy(schemaRegistry, schemaName, schemaBranchName, schemaVersion);
        }
        if (strategy.equalsIgnoreCase(SchemaAccessUtils.SCHEMA_TEXT_PROPERTY.getValue())) {
            return new AvroSchemaTextStrategy(context.getProperty(SchemaAccessUtils.SCHEMA_TEXT));
        }
        if (strategy.equalsIgnoreCase(SchemaAccessUtils.INFER_SCHEMA.getValue())) {
            return new InferenceSchemaStrategy();
        }
        return null;
    }

    @Override
    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>(2);
        AllowableValue[] strategies = new AllowableValue[]{SchemaAccessUtils.SCHEMA_NAME_PROPERTY, SchemaAccessUtils.SCHEMA_TEXT_PROPERTY, SchemaAccessUtils.INFER_SCHEMA};
        properties.add(this.buildStrategyProperty(strategies));
        properties.add(SchemaAccessUtils.SCHEMA_REGISTRY);
        properties.add(SchemaAccessUtils.SCHEMA_NAME);
        properties.add(SchemaAccessUtils.SCHEMA_VERSION);
        properties.add(SchemaAccessUtils.SCHEMA_BRANCH_NAME);
        properties.add(SchemaAccessUtils.SCHEMA_TEXT);
        return properties;
    }

    public RecordSchema getSchema(Map<String, String> variables, Map<String, Object> content, RecordSchema readSchema) throws SchemaNotFoundException, IOException {
        if (this.schemaAccess.equalsIgnoreCase(SchemaAccessUtils.SCHEMA_NAME_PROPERTY.getValue()) || this.schemaAccess.equalsIgnoreCase(SchemaAccessUtils.SCHEMA_TEXT_PROPERTY.getValue())) {
            return this.getSchema(variables, readSchema);
        }
        return ((JsonSchemaAccessStrategy)this.schemaAccessStrategy).getSchema(variables, content, readSchema);
    }
}

