/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.avro;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.avro.Conversions;
import org.apache.avro.JsonProperties;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.util.Utf8;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.SchemaIdentifier;
import org.apache.nifi.serialization.record.StandardSchemaIdentifier;
import org.apache.nifi.serialization.record.type.ArrayDataType;
import org.apache.nifi.serialization.record.type.ChoiceDataType;
import org.apache.nifi.serialization.record.type.MapDataType;
import org.apache.nifi.serialization.record.type.RecordDataType;
import org.apache.nifi.serialization.record.util.DataTypeUtils;
import org.apache.nifi.serialization.record.util.IllegalTypeConversionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroTypeUtil {
    private static final Logger logger = LoggerFactory.getLogger(AvroTypeUtil.class);
    public static final String AVRO_SCHEMA_FORMAT = "avro";
    private static final String LOGICAL_TYPE_DATE = "date";
    private static final String LOGICAL_TYPE_TIME_MILLIS = "time-millis";
    private static final String LOGICAL_TYPE_TIME_MICROS = "time-micros";
    private static final String LOGICAL_TYPE_TIMESTAMP_MILLIS = "timestamp-millis";
    private static final String LOGICAL_TYPE_TIMESTAMP_MICROS = "timestamp-micros";
    private static final String LOGICAL_TYPE_DECIMAL = "decimal";

    public static Schema extractAvroSchema(RecordSchema recordSchema) {
        if (recordSchema == null) {
            throw new IllegalArgumentException("RecordSchema cannot be null");
        }
        Optional schemaFormatOption = recordSchema.getSchemaFormat();
        if (!schemaFormatOption.isPresent()) {
            return AvroTypeUtil.buildAvroSchema(recordSchema);
        }
        String schemaFormat = (String)schemaFormatOption.get();
        if (!schemaFormat.equals(AVRO_SCHEMA_FORMAT)) {
            return AvroTypeUtil.buildAvroSchema(recordSchema);
        }
        Optional textOption = recordSchema.getSchemaText();
        if (!textOption.isPresent()) {
            return AvroTypeUtil.buildAvroSchema(recordSchema);
        }
        String text = (String)textOption.get();
        return new Schema.Parser().parse(text);
    }

    private static Schema buildAvroSchema(RecordSchema recordSchema) {
        ArrayList<Schema.Field> avroFields = new ArrayList<Schema.Field>(recordSchema.getFieldCount());
        for (RecordField recordField : recordSchema.getFields()) {
            avroFields.add(AvroTypeUtil.buildAvroField(recordField));
        }
        Schema avroSchema = Schema.createRecord((String)"nifiRecord", null, (String)"org.apache.nifi", (boolean)false, avroFields);
        return avroSchema;
    }

    private static Schema.Field buildAvroField(RecordField recordField) {
        Schema.Field field;
        Schema schema = AvroTypeUtil.buildAvroSchema(recordField.getDataType(), recordField.getFieldName(), recordField.isNullable());
        String recordFieldName = recordField.getFieldName();
        if (AvroTypeUtil.isValidAvroFieldName(recordFieldName)) {
            field = new Schema.Field(recordField.getFieldName(), schema, null, recordField.getDefaultValue());
        } else {
            String validName = AvroTypeUtil.createValidAvroFieldName(recordField.getFieldName());
            field = new Schema.Field(validName, schema, null, recordField.getDefaultValue());
            field.addAlias(recordField.getFieldName());
        }
        for (String alias : recordField.getAliases()) {
            field.addAlias(alias);
        }
        return field;
    }

    private static boolean isValidAvroFieldName(String fieldName) {
        if (fieldName.isEmpty()) {
            return false;
        }
        char firstChar = fieldName.charAt(0);
        if (firstChar != '_' && !Character.isLetter(firstChar)) {
            return false;
        }
        for (int i = 1; i < fieldName.length(); ++i) {
            char c = fieldName.charAt(i);
            if (c == '_' || Character.isLetterOrDigit(c)) continue;
            return false;
        }
        return true;
    }

    private static String createValidAvroFieldName(String fieldName) {
        if (fieldName.isEmpty()) {
            return "UNNAMED_FIELD";
        }
        StringBuilder sb = new StringBuilder();
        char firstChar = fieldName.charAt(0);
        if (firstChar == '_' || Character.isLetter(firstChar)) {
            sb.append(firstChar);
        } else {
            sb.append("_");
        }
        for (int i = 1; i < fieldName.length(); ++i) {
            char c = fieldName.charAt(i);
            if (c == '_' || Character.isLetterOrDigit(c)) {
                sb.append(c);
                continue;
            }
            sb.append("_");
        }
        return sb.toString();
    }

    private static Schema buildAvroSchema(DataType dataType, String fieldName, boolean nullable) {
        Schema schema;
        switch (dataType.getFieldType()) {
            case ARRAY: {
                ArrayDataType arrayDataType = (ArrayDataType)dataType;
                DataType elementDataType = arrayDataType.getElementType();
                if (RecordFieldType.BYTE.equals((Object)elementDataType.getFieldType())) {
                    schema = Schema.create((Schema.Type)Schema.Type.BYTES);
                    break;
                }
                Schema elementType = AvroTypeUtil.buildAvroSchema(elementDataType, fieldName, false);
                schema = Schema.createArray((Schema)elementType);
                break;
            }
            case BIGINT: {
                schema = Schema.create((Schema.Type)Schema.Type.STRING);
                break;
            }
            case BOOLEAN: {
                schema = Schema.create((Schema.Type)Schema.Type.BOOLEAN);
                break;
            }
            case BYTE: {
                schema = Schema.create((Schema.Type)Schema.Type.INT);
                break;
            }
            case CHAR: {
                schema = Schema.create((Schema.Type)Schema.Type.STRING);
                break;
            }
            case CHOICE: {
                ChoiceDataType choiceDataType = (ChoiceDataType)dataType;
                List options = choiceDataType.getPossibleSubTypes();
                ArrayList<Schema> unionTypes = new ArrayList<Schema>(options.size());
                HashSet<Schema.Type> typesAdded = new HashSet<Schema.Type>();
                for (DataType option : options) {
                    Schema optionSchema = AvroTypeUtil.buildAvroSchema(option, fieldName, false);
                    if (typesAdded.contains(optionSchema.getType())) continue;
                    unionTypes.add(optionSchema);
                    typesAdded.add(optionSchema.getType());
                }
                schema = Schema.createUnion(unionTypes);
                break;
            }
            case DATE: {
                schema = Schema.create((Schema.Type)Schema.Type.INT);
                LogicalTypes.date().addToSchema(schema);
                break;
            }
            case DOUBLE: {
                schema = Schema.create((Schema.Type)Schema.Type.DOUBLE);
                break;
            }
            case FLOAT: {
                schema = Schema.create((Schema.Type)Schema.Type.FLOAT);
                break;
            }
            case INT: {
                schema = Schema.create((Schema.Type)Schema.Type.INT);
                break;
            }
            case LONG: {
                schema = Schema.create((Schema.Type)Schema.Type.LONG);
                break;
            }
            case MAP: {
                schema = Schema.createMap((Schema)AvroTypeUtil.buildAvroSchema(((MapDataType)dataType).getValueType(), fieldName, false));
                break;
            }
            case RECORD: {
                RecordDataType recordDataType = (RecordDataType)dataType;
                RecordSchema childSchema = recordDataType.getChildSchema();
                ArrayList<Schema.Field> childFields = new ArrayList<Schema.Field>(childSchema.getFieldCount());
                for (RecordField field : childSchema.getFields()) {
                    childFields.add(AvroTypeUtil.buildAvroField(field));
                }
                schema = Schema.createRecord((String)(fieldName + "Type"), null, (String)"org.apache.nifi", (boolean)false, childFields);
                break;
            }
            case SHORT: {
                schema = Schema.create((Schema.Type)Schema.Type.INT);
                break;
            }
            case STRING: {
                schema = Schema.create((Schema.Type)Schema.Type.STRING);
                break;
            }
            case TIME: {
                schema = Schema.create((Schema.Type)Schema.Type.INT);
                LogicalTypes.timeMillis().addToSchema(schema);
                break;
            }
            case TIMESTAMP: {
                schema = Schema.create((Schema.Type)Schema.Type.LONG);
                LogicalTypes.timestampMillis().addToSchema(schema);
                break;
            }
            default: {
                return null;
            }
        }
        if (nullable) {
            return AvroTypeUtil.nullable(schema);
        }
        return schema;
    }

    private static Schema nullable(Schema schema) {
        if (schema.getType() == Schema.Type.UNION) {
            Schema nullSchema;
            ArrayList<Schema> unionTypes = new ArrayList<Schema>(schema.getTypes());
            if (unionTypes.contains(nullSchema = Schema.create((Schema.Type)Schema.Type.NULL))) {
                return schema;
            }
            unionTypes.add(nullSchema);
            return Schema.createUnion(unionTypes);
        }
        return Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), schema});
    }

    public static DataType determineDataType(Schema avroSchema) {
        return AvroTypeUtil.determineDataType(avroSchema, new HashMap<String, DataType>());
    }

    public static DataType determineDataType(Schema avroSchema, Map<String, DataType> knownRecordTypes) {
        if (knownRecordTypes == null) {
            throw new IllegalArgumentException("'knownRecordTypes' cannot be null.");
        }
        Schema.Type avroType = avroSchema.getType();
        LogicalType logicalType = avroSchema.getLogicalType();
        if (logicalType != null) {
            String logicalTypeName;
            switch (logicalTypeName = logicalType.getName()) {
                case "date": {
                    return RecordFieldType.DATE.getDataType();
                }
                case "time-millis": 
                case "time-micros": {
                    return RecordFieldType.TIME.getDataType();
                }
                case "timestamp-millis": 
                case "timestamp-micros": {
                    return RecordFieldType.TIMESTAMP.getDataType();
                }
                case "decimal": {
                    return RecordFieldType.DOUBLE.getDataType();
                }
            }
        }
        switch (avroType) {
            case ARRAY: {
                return RecordFieldType.ARRAY.getArrayDataType(AvroTypeUtil.determineDataType(avroSchema.getElementType(), knownRecordTypes));
            }
            case BYTES: 
            case FIXED: {
                return RecordFieldType.ARRAY.getArrayDataType(RecordFieldType.BYTE.getDataType());
            }
            case BOOLEAN: {
                return RecordFieldType.BOOLEAN.getDataType();
            }
            case DOUBLE: {
                return RecordFieldType.DOUBLE.getDataType();
            }
            case ENUM: 
            case STRING: {
                return RecordFieldType.STRING.getDataType();
            }
            case FLOAT: {
                return RecordFieldType.FLOAT.getDataType();
            }
            case INT: {
                return RecordFieldType.INT.getDataType();
            }
            case LONG: {
                return RecordFieldType.LONG.getDataType();
            }
            case RECORD: {
                String schemaFullName = avroSchema.getNamespace() + "." + avroSchema.getName();
                if (knownRecordTypes.containsKey(schemaFullName)) {
                    return knownRecordTypes.get(schemaFullName);
                }
                SimpleRecordSchema recordSchema = new SimpleRecordSchema(SchemaIdentifier.EMPTY);
                DataType recordSchemaType = RecordFieldType.RECORD.getRecordDataType((RecordSchema)recordSchema);
                knownRecordTypes.put(schemaFullName, recordSchemaType);
                List avroFields = avroSchema.getFields();
                ArrayList<RecordField> recordFields = new ArrayList<RecordField>(avroFields.size());
                for (Schema.Field field : avroFields) {
                    String fieldName = field.name();
                    Schema fieldSchema = field.schema();
                    DataType fieldType = AvroTypeUtil.determineDataType(fieldSchema, knownRecordTypes);
                    boolean nullable = AvroTypeUtil.isNullable(fieldSchema);
                    AvroTypeUtil.addFieldToList(recordFields, field, fieldName, fieldSchema, fieldType, nullable);
                }
                recordSchema.setFields(recordFields);
                return recordSchemaType;
            }
            case NULL: {
                return RecordFieldType.STRING.getDataType();
            }
            case MAP: {
                Schema valueSchema = avroSchema.getValueType();
                DataType valueType = AvroTypeUtil.determineDataType(valueSchema, knownRecordTypes);
                return RecordFieldType.MAP.getMapDataType(valueType);
            }
            case UNION: {
                List<Schema> nonNullSubSchemas = AvroTypeUtil.getNonNullSubSchemas(avroSchema);
                if (nonNullSubSchemas.size() == 1) {
                    return AvroTypeUtil.determineDataType(nonNullSubSchemas.get(0), knownRecordTypes);
                }
                ArrayList<DataType> possibleChildTypes = new ArrayList<DataType>(nonNullSubSchemas.size());
                for (Schema subSchema : nonNullSubSchemas) {
                    DataType childDataType = AvroTypeUtil.determineDataType(subSchema, knownRecordTypes);
                    possibleChildTypes.add(childDataType);
                }
                return RecordFieldType.CHOICE.getChoiceDataType(possibleChildTypes);
            }
        }
        return null;
    }

    private static List<Schema> getNonNullSubSchemas(Schema avroSchema) {
        List unionFieldSchemas = avroSchema.getTypes();
        if (unionFieldSchemas == null) {
            return Collections.emptyList();
        }
        ArrayList<Schema> nonNullTypes = new ArrayList<Schema>(unionFieldSchemas.size());
        for (Schema fieldSchema : unionFieldSchemas) {
            if (fieldSchema.getType() == Schema.Type.NULL) continue;
            nonNullTypes.add(fieldSchema);
        }
        return nonNullTypes;
    }

    public static RecordSchema createSchema(Schema avroSchema) {
        return AvroTypeUtil.createSchema(avroSchema, true);
    }

    public static RecordSchema createSchema(Schema avroSchema, boolean includeText) {
        if (avroSchema == null) {
            throw new IllegalArgumentException("Avro Schema cannot be null");
        }
        SchemaIdentifier identifier = new StandardSchemaIdentifier.Builder().name(avroSchema.getName()).build();
        return AvroTypeUtil.createSchema(avroSchema, includeText ? avroSchema.toString() : null, identifier);
    }

    public static RecordSchema createSchema(Schema avroSchema, String schemaText, SchemaIdentifier schemaId) {
        if (avroSchema == null) {
            throw new IllegalArgumentException("Avro Schema cannot be null");
        }
        String schemaFullName = avroSchema.getNamespace() + "." + avroSchema.getName();
        SimpleRecordSchema recordSchema = schemaText == null ? new SimpleRecordSchema(schemaId) : new SimpleRecordSchema(schemaText, AVRO_SCHEMA_FORMAT, schemaId);
        recordSchema.setSchemaName(avroSchema.getName());
        recordSchema.setSchemaNamespace(avroSchema.getNamespace());
        DataType recordSchemaType = RecordFieldType.RECORD.getRecordDataType((RecordSchema)recordSchema);
        HashMap<String, DataType> knownRecords = new HashMap<String, DataType>();
        knownRecords.put(schemaFullName, recordSchemaType);
        ArrayList<RecordField> recordFields = new ArrayList<RecordField>(avroSchema.getFields().size());
        for (Schema.Field field : avroSchema.getFields()) {
            String fieldName = field.name();
            Schema fieldSchema = field.schema();
            DataType dataType = AvroTypeUtil.determineDataType(fieldSchema, knownRecords);
            boolean nullable = AvroTypeUtil.isNullable(fieldSchema);
            AvroTypeUtil.addFieldToList(recordFields, field, fieldName, fieldSchema, dataType, nullable);
        }
        recordSchema.setFields(recordFields);
        return recordSchema;
    }

    public static boolean isNullable(Schema schema) {
        Schema.Type schemaType = schema.getType();
        if (schemaType == Schema.Type.UNION) {
            for (Schema unionSchema : schema.getTypes()) {
                if (!AvroTypeUtil.isNullable(unionSchema)) continue;
                return true;
            }
        }
        return schemaType == Schema.Type.NULL;
    }

    public static Object[] convertByteArray(byte[] bytes) {
        Object[] array = new Object[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            array[i] = bytes[i];
        }
        return array;
    }

    public static ByteBuffer convertByteArray(Object[] bytes) {
        ByteBuffer bb = ByteBuffer.allocate(bytes.length);
        for (Object o : bytes) {
            if (!(o instanceof Byte)) {
                throw new IllegalTypeConversionException("Cannot convert value " + bytes + " of type " + bytes.getClass() + " to ByteBuffer");
            }
            bb.put((Byte)o);
        }
        bb.flip();
        return bb;
    }

    protected static Pair<String, Schema.Field> lookupField(Schema avroSchema, RecordField recordField) {
        String fieldName = recordField.getFieldName();
        Schema.Field field = avroSchema.getField(fieldName);
        if (field == null) {
            for (String alias : recordField.getAliases()) {
                field = avroSchema.getField(alias);
                if (field == null) continue;
                fieldName = alias;
                break;
            }
        }
        if (field == null) {
            block1: for (Schema.Field childField : avroSchema.getFields()) {
                Set aliases = childField.aliases();
                if (aliases.isEmpty()) continue;
                if (aliases.contains(fieldName)) {
                    field = childField;
                    break;
                }
                for (String alias : recordField.getAliases()) {
                    if (!aliases.contains(alias)) continue;
                    field = childField;
                    fieldName = alias;
                    continue block1;
                }
            }
        }
        return new ImmutablePair((Object)fieldName, (Object)field);
    }

    public static GenericRecord createAvroRecord(Record record, Schema avroSchema) throws IOException {
        return AvroTypeUtil.createAvroRecord(record, avroSchema, StandardCharsets.UTF_8);
    }

    public static GenericRecord createAvroRecord(Record record, Schema avroSchema, Charset charset) throws IOException {
        GenericData.Record rec = new GenericData.Record(avroSchema);
        RecordSchema recordSchema = record.getSchema();
        for (RecordField recordField : recordSchema.getFields()) {
            Object rawValue = record.getValue(recordField);
            Pair<String, Schema.Field> fieldPair = AvroTypeUtil.lookupField(avroSchema, recordField);
            String fieldName = (String)fieldPair.getLeft();
            Schema.Field field = (Schema.Field)fieldPair.getRight();
            if (field == null) continue;
            Object converted = AvroTypeUtil.convertToAvroObject(rawValue, field.schema(), fieldName, charset);
            rec.put(field.name(), converted);
        }
        for (Schema.Field field : avroSchema.getFields()) {
            Optional recordField = recordSchema.getField(field.name());
            if (recordField.isPresent() || rec.get(field.name()) != null || field.defaultVal() == null) continue;
            rec.put(field.name(), field.defaultVal());
        }
        return rec;
    }

    public static Object convertToAvroObject(Object rawValue, Schema fieldSchema) {
        return AvroTypeUtil.convertToAvroObject(rawValue, fieldSchema, StandardCharsets.UTF_8);
    }

    public static Object convertToAvroObject(Object rawValue, Schema fieldSchema, Charset charset) {
        return AvroTypeUtil.convertToAvroObject(rawValue, fieldSchema, fieldSchema.getName(), charset);
    }

    private static void addFieldToList(List<RecordField> recordFields, Schema.Field field, String fieldName, Schema fieldSchema, DataType dataType, boolean nullable) {
        if (field.defaultVal() == JsonProperties.NULL_VALUE) {
            recordFields.add(new RecordField(fieldName, dataType, field.aliases(), nullable));
        } else {
            Object[] defaultValue = field.defaultVal();
            if (fieldSchema.getType() == Schema.Type.ARRAY && !DataTypeUtils.isArrayTypeCompatible((Object)defaultValue, (DataType)((ArrayDataType)dataType).getElementType())) {
                defaultValue = defaultValue instanceof List ? ((List)defaultValue).toArray() : new Object[]{};
            }
            recordFields.add(new RecordField(fieldName, dataType, (Object)defaultValue, field.aliases(), nullable));
        }
    }

    private static Long getLongFromTimestamp(Object rawValue, Schema fieldSchema, String fieldName) {
        String format = AvroTypeUtil.determineDataType(fieldSchema).getFormat();
        Timestamp t = DataTypeUtils.toTimestamp((Object)rawValue, () -> DataTypeUtils.getDateFormat((String)format), (String)fieldName);
        return t.getTime();
    }

    private static Object convertToAvroObject(Object rawValue, Schema fieldSchema, String fieldName, Charset charset) {
        if (rawValue == null) {
            return null;
        }
        switch (fieldSchema.getType()) {
            case INT: {
                LogicalType logicalType = fieldSchema.getLogicalType();
                if (logicalType == null) {
                    return DataTypeUtils.toInteger((Object)rawValue, (String)fieldName);
                }
                if (LOGICAL_TYPE_DATE.equals(logicalType.getName())) {
                    String format = AvroTypeUtil.determineDataType(fieldSchema).getFormat();
                    Date date = DataTypeUtils.toDate((Object)rawValue, () -> DataTypeUtils.getDateFormat((String)format), (String)fieldName);
                    Duration duration = Duration.between(new java.util.Date(0L).toInstant(), new java.util.Date(date.getTime()).toInstant());
                    long l = duration.toDays();
                    return (int)l;
                }
                if (LOGICAL_TYPE_TIME_MILLIS.equals(logicalType.getName())) {
                    String format = AvroTypeUtil.determineDataType(fieldSchema).getFormat();
                    Time time = DataTypeUtils.toTime((Object)rawValue, () -> DataTypeUtils.getDateFormat((String)format), (String)fieldName);
                    java.util.Date date = new java.util.Date(time.getTime());
                    Duration duration = Duration.between(date.toInstant().truncatedTo(ChronoUnit.DAYS), date.toInstant());
                    long millisSinceMidnight = duration.toMillis();
                    return (int)millisSinceMidnight;
                }
                return DataTypeUtils.toInteger((Object)rawValue, (String)fieldName);
            }
            case LONG: {
                LogicalType logicalType = fieldSchema.getLogicalType();
                if (logicalType == null) {
                    return DataTypeUtils.toLong((Object)rawValue, (String)fieldName);
                }
                if (LOGICAL_TYPE_TIME_MICROS.equals(logicalType.getName())) {
                    long longValue = AvroTypeUtil.getLongFromTimestamp(rawValue, fieldSchema, fieldName);
                    java.util.Date date = new java.util.Date(longValue);
                    Duration duration = Duration.between(date.toInstant().truncatedTo(ChronoUnit.DAYS), date.toInstant());
                    return duration.toMillis() * 1000L;
                }
                if (LOGICAL_TYPE_TIMESTAMP_MILLIS.equals(logicalType.getName())) {
                    String format = AvroTypeUtil.determineDataType(fieldSchema).getFormat();
                    Timestamp t = DataTypeUtils.toTimestamp((Object)rawValue, () -> DataTypeUtils.getDateFormat((String)format), (String)fieldName);
                    return AvroTypeUtil.getLongFromTimestamp(rawValue, fieldSchema, fieldName);
                }
                if (LOGICAL_TYPE_TIMESTAMP_MICROS.equals(logicalType.getName())) {
                    return AvroTypeUtil.getLongFromTimestamp(rawValue, fieldSchema, fieldName) * 1000L;
                }
                return DataTypeUtils.toLong((Object)rawValue, (String)fieldName);
            }
            case BYTES: 
            case FIXED: {
                LogicalType logicalType = fieldSchema.getLogicalType();
                if (logicalType != null && LOGICAL_TYPE_DECIMAL.equals(logicalType.getName())) {
                    BigDecimal rawDecimal;
                    LogicalTypes.Decimal decimalType = (LogicalTypes.Decimal)logicalType;
                    if (rawValue instanceof BigDecimal) {
                        rawDecimal = (BigDecimal)rawValue;
                    } else if (rawValue instanceof Double) {
                        rawDecimal = BigDecimal.valueOf((Double)rawValue);
                    } else if (rawValue instanceof String) {
                        rawDecimal = new BigDecimal((String)rawValue);
                    } else if (rawValue instanceof Integer) {
                        rawDecimal = new BigDecimal((Integer)rawValue);
                    } else if (rawValue instanceof Long) {
                        rawDecimal = new BigDecimal((Long)rawValue);
                    } else {
                        throw new IllegalTypeConversionException("Cannot convert value " + rawValue + " of type " + rawValue.getClass() + " to a logical decimal");
                    }
                    int desiredScale = decimalType.getScale();
                    BigDecimal bigDecimal = rawDecimal.scale() == desiredScale ? rawDecimal : rawDecimal.setScale(desiredScale, 4);
                    return fieldSchema.getType() == Schema.Type.BYTES ? new Conversions.DecimalConversion().toBytes(bigDecimal, fieldSchema, logicalType) : new Conversions.DecimalConversion().toFixed(bigDecimal, fieldSchema, logicalType);
                }
                if (rawValue instanceof byte[]) {
                    return ByteBuffer.wrap((byte[])rawValue);
                }
                if (rawValue instanceof String) {
                    return ByteBuffer.wrap(((String)rawValue).getBytes(charset));
                }
                if (rawValue instanceof Object[]) {
                    return AvroTypeUtil.convertByteArray((Object[])rawValue);
                }
                try {
                    if (rawValue instanceof Blob) {
                        Blob blob = (Blob)rawValue;
                        return ByteBuffer.wrap(IOUtils.toByteArray((InputStream)blob.getBinaryStream()));
                    }
                    throw new IllegalTypeConversionException("Cannot convert value " + rawValue + " of type " + rawValue.getClass() + " to a ByteBuffer");
                }
                catch (IllegalTypeConversionException itce) {
                    throw itce;
                }
                catch (Exception e) {
                    throw new IllegalTypeConversionException("Cannot convert value " + rawValue + " of type " + rawValue.getClass() + " to a ByteBuffer", (Throwable)e);
                }
            }
            case MAP: {
                if (rawValue instanceof Record) {
                    Record recordValue = (Record)rawValue;
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    for (RecordField recordField : recordValue.getSchema().getFields()) {
                        Object v = recordValue.getValue(recordField);
                        if (v == null) continue;
                        map.put(recordField.getFieldName(), v);
                    }
                    return map;
                }
                if (rawValue instanceof Map) {
                    Map objectMap = (Map)rawValue;
                    HashMap<String, Object> map = new HashMap<String, Object>(objectMap.size());
                    for (String string : objectMap.keySet()) {
                        Object converted = AvroTypeUtil.convertToAvroObject(objectMap.get(string), fieldSchema.getValueType(), fieldName + "[" + string + "]", charset);
                        map.put(string, converted);
                    }
                    return map;
                }
                throw new IllegalTypeConversionException("Cannot convert value " + rawValue + " of type " + rawValue.getClass() + " to a Map");
            }
            case RECORD: {
                Set entries;
                GenericData.Record avroRecord = new GenericData.Record(fieldSchema);
                if (rawValue instanceof Map) {
                    Map map = (Map)rawValue;
                    entries = map.entrySet();
                } else if (rawValue instanceof Record) {
                    entries = new HashSet();
                    Record record = (Record)rawValue;
                    record.getSchema().getFields().forEach(field -> entries.add(new AbstractMap.SimpleEntry<String, Object>(field.getFieldName(), record.getValue(field))));
                } else {
                    throw new IllegalTypeConversionException("Cannot convert value " + rawValue + " of type " + rawValue.getClass() + " to a Record");
                }
                for (Map.Entry entry : entries) {
                    Object recordFieldValue = entry.getValue();
                    String recordFieldName = (String)entry.getKey();
                    Schema.Field field2 = fieldSchema.getField(recordFieldName);
                    if (field2 == null) continue;
                    Object converted = AvroTypeUtil.convertToAvroObject(recordFieldValue, field2.schema(), fieldName + "/" + recordFieldName, charset);
                    avroRecord.put(recordFieldName, converted);
                }
                return avroRecord;
            }
            case UNION: {
                return AvroTypeUtil.convertUnionFieldValue(rawValue, fieldSchema, schema -> AvroTypeUtil.convertToAvroObject(rawValue, schema, fieldName, charset), fieldName);
            }
            case ARRAY: {
                Object[] objectArray;
                if (rawValue instanceof List) {
                    objectArray = ((List)rawValue).toArray();
                } else if (rawValue instanceof Object[]) {
                    objectArray = (Object[])rawValue;
                } else {
                    throw new IllegalTypeConversionException("Cannot convert value " + rawValue + " of type " + rawValue.getClass() + " to an Array");
                }
                ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
                int i = 0;
                for (Object o : objectArray) {
                    Object converted = AvroTypeUtil.convertToAvroObject(o, fieldSchema.getElementType(), fieldName + "[" + i + "]", charset);
                    arrayList.add(converted);
                    ++i;
                }
                return arrayList;
            }
            case BOOLEAN: {
                return DataTypeUtils.toBoolean((Object)rawValue, (String)fieldName);
            }
            case DOUBLE: {
                return DataTypeUtils.toDouble((Object)rawValue, (String)fieldName);
            }
            case FLOAT: {
                return DataTypeUtils.toFloat((Object)rawValue, (String)fieldName);
            }
            case NULL: {
                return null;
            }
            case ENUM: {
                return new GenericData.EnumSymbol(fieldSchema, rawValue);
            }
            case STRING: {
                return DataTypeUtils.toString((Object)rawValue, (String)null, (Charset)charset);
            }
        }
        return rawValue;
    }

    public static Map<String, Object> convertAvroRecordToMap(GenericRecord avroRecord, RecordSchema recordSchema) {
        return AvroTypeUtil.convertAvroRecordToMap(avroRecord, recordSchema, StandardCharsets.UTF_8);
    }

    public static Map<String, Object> convertAvroRecordToMap(GenericRecord avroRecord, RecordSchema recordSchema, Charset charset) {
        HashMap<String, Object> values = new HashMap<String, Object>(recordSchema.getFieldCount());
        for (RecordField recordField : recordSchema.getFields()) {
            Object value = avroRecord.get(recordField.getFieldName());
            if (value == null) {
                String alias;
                Iterator iterator = recordField.getAliases().iterator();
                while (iterator.hasNext() && (value = avroRecord.get(alias = (String)iterator.next())) == null) {
                }
            }
            String fieldName = recordField.getFieldName();
            try {
                Schema.Field avroField = avroRecord.getSchema().getField(fieldName);
                if (avroField == null) {
                    values.put(fieldName, null);
                    continue;
                }
                Schema fieldSchema = avroField.schema();
                Object rawValue = AvroTypeUtil.normalizeValue(value, fieldSchema, fieldName);
                DataType desiredType = recordField.getDataType();
                Object coercedValue = DataTypeUtils.convertType((Object)rawValue, (DataType)desiredType, (String)fieldName, (Charset)charset);
                values.put(fieldName, coercedValue);
            }
            catch (Exception ex) {
                logger.debug("fail to convert field " + fieldName, (Throwable)ex);
                throw ex;
            }
        }
        return values;
    }

    private static Object convertUnionFieldValue(Object originalValue, Schema fieldSchema, Function<Schema, Object> conversion, String fieldName) {
        boolean foundNonNull = false;
        for (Schema subSchema : fieldSchema.getTypes()) {
            if (subSchema.getType() == Schema.Type.NULL) continue;
            foundNonNull = true;
            DataType desiredDataType = AvroTypeUtil.determineDataType(subSchema);
            try {
                Object convertedValue = conversion.apply(subSchema);
                if (AvroTypeUtil.isCompatibleDataType(convertedValue, desiredDataType)) {
                    return convertedValue;
                }
                if (subSchema.getLogicalType() == null || !DataTypeUtils.isCompatibleDataType((Object)originalValue, (DataType)desiredDataType)) continue;
                return convertedValue;
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Cannot convert value {} to type {}", new Object[]{originalValue, desiredDataType, e});
            }
        }
        if (foundNonNull) {
            throw new IllegalTypeConversionException("Cannot convert value " + originalValue + " of type " + originalValue.getClass() + " because no compatible types exist in the UNION for field " + fieldName);
        }
        return null;
    }

    private static boolean isCompatibleDataType(Object value, DataType dataType) {
        if (value == null) {
            return false;
        }
        switch (dataType.getFieldType()) {
            case RECORD: {
                if (!(value instanceof GenericRecord) && !(value instanceof SpecificRecord)) break;
                return true;
            }
            case STRING: {
                if (!(value instanceof Utf8)) break;
                return true;
            }
            case ARRAY: {
                if (!(value instanceof GenericData.Array) && !(value instanceof List) && !(value instanceof ByteBuffer)) break;
                return true;
            }
            case MAP: {
                if (!(value instanceof Map)) break;
                return true;
            }
        }
        return DataTypeUtils.isCompatibleDataType((Object)value, (DataType)dataType);
    }

    private static Object normalizeValue(Object value, Schema avroSchema, String fieldName) {
        if (value == null) {
            return null;
        }
        switch (avroSchema.getType()) {
            case INT: {
                LogicalType logicalType = avroSchema.getLogicalType();
                if (logicalType == null) {
                    return value;
                }
                String logicalName = logicalType.getName();
                if (LOGICAL_TYPE_DATE.equals(logicalName)) {
                    return new Date(TimeUnit.DAYS.toMillis(((Integer)value).intValue()));
                }
                if (!LOGICAL_TYPE_TIME_MILLIS.equals(logicalName)) break;
                return new Time(((Integer)value).intValue());
            }
            case LONG: {
                LogicalType logicalType = avroSchema.getLogicalType();
                if (logicalType == null) {
                    return value;
                }
                String logicalName = logicalType.getName();
                if (LOGICAL_TYPE_TIME_MICROS.equals(logicalName)) {
                    return new Time(TimeUnit.MICROSECONDS.toMillis((Long)value));
                }
                if (LOGICAL_TYPE_TIMESTAMP_MILLIS.equals(logicalName)) {
                    return new Timestamp((Long)value);
                }
                if (!LOGICAL_TYPE_TIMESTAMP_MICROS.equals(logicalName)) break;
                return new Timestamp(TimeUnit.MICROSECONDS.toMillis((Long)value));
            }
            case UNION: {
                if (value instanceof GenericData.Record) {
                    GenericData.Record avroRecord = (GenericData.Record)value;
                    return AvroTypeUtil.normalizeValue(value, avroRecord.getSchema(), fieldName);
                }
                return AvroTypeUtil.convertUnionFieldValue(value, avroSchema, schema -> AvroTypeUtil.normalizeValue(value, schema, fieldName), fieldName);
            }
            case RECORD: {
                GenericData.Record record = (GenericData.Record)value;
                Schema recordSchema = record.getSchema();
                List recordFields = recordSchema.getFields();
                HashMap<String, Object> values = new HashMap<String, Object>(recordFields.size());
                for (Schema.Field field : recordFields) {
                    Object avroFieldValue = record.get(field.name());
                    Object fieldValue = AvroTypeUtil.normalizeValue(avroFieldValue, field.schema(), fieldName + "/" + field.name());
                    values.put(field.name(), fieldValue);
                }
                RecordSchema childSchema = AvroTypeUtil.createSchema(recordSchema, false);
                return new MapRecord(childSchema, values);
            }
            case BYTES: {
                ByteBuffer bb = (ByteBuffer)value;
                LogicalType logicalType = avroSchema.getLogicalType();
                if (logicalType != null && LOGICAL_TYPE_DECIMAL.equals(logicalType.getName())) {
                    return new Conversions.DecimalConversion().fromBytes(bb, avroSchema, logicalType);
                }
                return AvroTypeUtil.convertByteArray(bb.array());
            }
            case FIXED: {
                GenericFixed fixed = (GenericFixed)value;
                return AvroTypeUtil.convertByteArray(fixed.bytes());
            }
            case ENUM: {
                return value.toString();
            }
            case NULL: {
                return null;
            }
            case STRING: {
                return value.toString();
            }
            case ARRAY: {
                if (value instanceof List) {
                    List list = (List)value;
                    Object[] valueArray = new Object[list.size()];
                    for (int i = 0; i < list.size(); ++i) {
                        Schema elementSchema = avroSchema.getElementType();
                        valueArray[i] = AvroTypeUtil.normalizeValue(list.get(i), elementSchema, fieldName + "[" + i + "]");
                    }
                    return valueArray;
                }
                GenericData.Array array = (GenericData.Array)value;
                Object[] valueArray = new Object[array.size()];
                for (int i = 0; i < array.size(); ++i) {
                    Schema elementSchema = avroSchema.getElementType();
                    valueArray[i] = AvroTypeUtil.normalizeValue(array.get(i), elementSchema, fieldName + "[" + i + "]");
                }
                return valueArray;
            }
            case MAP: {
                Map avroMap = (Map)value;
                HashMap map = new HashMap(avroMap.size());
                for (Map.Entry entry : avroMap.entrySet()) {
                    Object obj = entry.getValue();
                    if (obj instanceof Utf8 || obj instanceof CharSequence) {
                        obj = obj.toString();
                    }
                    String key = entry.getKey().toString();
                    obj = AvroTypeUtil.normalizeValue(obj, avroSchema.getValueType(), fieldName + "[" + key + "]");
                    map.put(key, obj);
                }
                return map;
            }
        }
        return value;
    }
}

