/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.schema.access;

import java.io.InputStream;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.nifi.avro.AvroTypeUtil;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.schema.access.SchemaAccessStrategy;
import org.apache.nifi.schema.access.SchemaField;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.record.RecordSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroSchemaTextStrategy
implements SchemaAccessStrategy {
    private static final Set<SchemaField> schemaFields = EnumSet.of(SchemaField.SCHEMA_TEXT, SchemaField.SCHEMA_TEXT_FORMAT);
    private static final Logger logger = LoggerFactory.getLogger(AvroSchemaTextStrategy.class);
    private final PropertyValue schemaTextPropertyValue;

    public AvroSchemaTextStrategy(PropertyValue schemaTextPropertyValue) {
        this.schemaTextPropertyValue = schemaTextPropertyValue;
    }

    public RecordSchema getSchema(Map<String, String> variables, InputStream contentStream, RecordSchema readSchema) throws SchemaNotFoundException {
        String schemaText = this.schemaTextPropertyValue.evaluateAttributeExpressions(variables).getValue();
        if (schemaText == null || schemaText.trim().isEmpty()) {
            throw new SchemaNotFoundException("FlowFile did not contain appropriate attributes to determine Schema Text");
        }
        logger.debug("For {} found schema text {}", variables, (Object)schemaText);
        try {
            Schema avroSchema = new Schema.Parser().parse(schemaText);
            return AvroTypeUtil.createSchema(avroSchema);
        }
        catch (Exception e) {
            throw new SchemaNotFoundException("Failed to create schema from the Schema Text after evaluating FlowFile Attributes", (Throwable)e);
        }
    }

    public Set<SchemaField> getSuppliedSchemaFields() {
        return schemaFields;
    }
}

