/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnShutdown;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processors.aws.AbstractAWSProcessor;
import org.apache.nifi.processors.aws.credentials.provider.service.AWSCredentialsProviderService;

public abstract class AbstractAWSCredentialsProviderProcessor<ClientType extends AmazonWebServiceClient>
extends AbstractAWSProcessor<ClientType> {
    public static final PropertyDescriptor AWS_CREDENTIALS_PROVIDER_SERVICE = new PropertyDescriptor.Builder().name("AWS Credentials Provider service").description("The Controller Service that is used to obtain aws credentials provider").required(false).identifiesControllerService(AWSCredentialsProviderService.class).build();

    @Override
    @OnScheduled
    public void onScheduled(ProcessContext context) {
        ControllerService service = context.getProperty(AWS_CREDENTIALS_PROVIDER_SERVICE).asControllerService();
        if (service != null) {
            this.getLogger().debug("Using aws credentials provider service for creating client");
            this.onScheduledUsingControllerService(context);
        } else {
            this.getLogger().debug("Using aws credentials for creating client");
            super.onScheduled(context);
        }
    }

    protected void onScheduledUsingControllerService(ProcessContext context) {
        ClientType awsClient = this.createClient(context, this.getCredentialsProvider(context), this.createConfiguration(context));
        this.client = awsClient;
        super.initializeRegionAndEndpoint(context);
    }

    @OnShutdown
    public void onShutDown() {
        if (this.client != null) {
            this.client.shutdown();
        }
    }

    protected AWSCredentialsProvider getCredentialsProvider(ProcessContext context) {
        AWSCredentialsProviderService awsCredentialsProviderService = (AWSCredentialsProviderService)context.getProperty(AWS_CREDENTIALS_PROVIDER_SERVICE).asControllerService(AWSCredentialsProviderService.class);
        return awsCredentialsProviderService.getCredentialsProvider();
    }

    protected abstract ClientType createClient(ProcessContext var1, AWSCredentialsProvider var2, ClientConfiguration var3);
}

