/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AnonymousAWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.PropertiesCredentials;
import com.amazonaws.http.conn.ssl.SdkTLSSocketFactory;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import java.io.File;
import java.io.IOException;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnShutdown;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.aws.credentials.provider.factory.CredentialPropertyDescriptors;
import org.apache.nifi.proxy.ProxyConfiguration;
import org.apache.nifi.proxy.ProxySpec;
import org.apache.nifi.ssl.SSLContextService;

@Deprecated
public abstract class AbstractAWSProcessor<ClientType extends AmazonWebServiceClient>
extends AbstractProcessor {
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("FlowFiles are routed to success relationship").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("FlowFiles are routed to failure relationship").build();
    public static final Set<Relationship> relationships = Collections.unmodifiableSet(new HashSet<Relationship>(Arrays.asList(REL_SUCCESS, REL_FAILURE)));
    public static final PropertyDescriptor CREDENTIALS_FILE = CredentialPropertyDescriptors.CREDENTIALS_FILE;
    public static final PropertyDescriptor ACCESS_KEY = CredentialPropertyDescriptors.ACCESS_KEY;
    public static final PropertyDescriptor SECRET_KEY = CredentialPropertyDescriptors.SECRET_KEY;
    public static final PropertyDescriptor PROXY_HOST = new PropertyDescriptor.Builder().name("Proxy Host").description("Proxy host name or IP").expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor PROXY_HOST_PORT = new PropertyDescriptor.Builder().name("Proxy Host Port").description("Proxy host port").expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).required(false).addValidator(StandardValidators.PORT_VALIDATOR).build();
    public static final PropertyDescriptor PROXY_USERNAME = new PropertyDescriptor.Builder().name("proxy-user-name").displayName("Proxy Username").description("Proxy username").expressionLanguageSupported(true).required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor PROXY_PASSWORD = new PropertyDescriptor.Builder().name("proxy-user-password").displayName("Proxy Password").description("Proxy password").expressionLanguageSupported(true).required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(true).build();
    public static final PropertyDescriptor REGION = new PropertyDescriptor.Builder().name("Region").required(true).allowableValues(AbstractAWSProcessor.getAvailableRegions()).defaultValue(AbstractAWSProcessor.createAllowableValue(Regions.DEFAULT_REGION).getValue()).build();
    public static final PropertyDescriptor TIMEOUT = new PropertyDescriptor.Builder().name("Communications Timeout").required(true).addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).defaultValue("30 secs").build();
    public static final PropertyDescriptor SSL_CONTEXT_SERVICE = new PropertyDescriptor.Builder().name("SSL Context Service").description("Specifies an optional SSL Context Service that, if provided, will be used to create connections").required(false).identifiesControllerService(SSLContextService.class).build();
    public static final PropertyDescriptor ENDPOINT_OVERRIDE = new PropertyDescriptor.Builder().name("Endpoint Override URL").description("Endpoint URL to use instead of the AWS default including scheme, host, port, and path. The AWS libraries select an endpoint URL based on the AWS region, but this property overrides the selected endpoint URL, allowing use with other S3-compatible endpoints.").expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).required(false).addValidator(StandardValidators.URL_VALIDATOR).build();
    protected volatile ClientType client;
    protected volatile Region region;
    protected static final Protocol DEFAULT_PROTOCOL = Protocol.HTTPS;
    protected static final String DEFAULT_USER_AGENT = "NiFi";
    private static final ProxySpec[] PROXY_SPECS = new ProxySpec[]{ProxySpec.HTTP_AUTH};
    public static final PropertyDescriptor PROXY_CONFIGURATION_SERVICE = ProxyConfiguration.createProxyConfigPropertyDescriptor((boolean)true, (ProxySpec[])PROXY_SPECS);

    protected static AllowableValue createAllowableValue(Regions region) {
        return new AllowableValue(region.getName(), region.getDescription(), "AWS Region Code : " + region.getName());
    }

    protected static AllowableValue[] getAvailableRegions() {
        ArrayList<AllowableValue> values = new ArrayList<AllowableValue>();
        for (Regions region : Regions.values()) {
            values.add(AbstractAWSProcessor.createAllowableValue(region));
        }
        return values.toArray(new AllowableValue[values.size()]);
    }

    public Set<Relationship> getRelationships() {
        return relationships;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> problems = new ArrayList<ValidationResult>(super.customValidate(validationContext));
        boolean accessKeySet = validationContext.getProperty(ACCESS_KEY).isSet();
        boolean secretKeySet = validationContext.getProperty(SECRET_KEY).isSet();
        if (accessKeySet && !secretKeySet || secretKeySet && !accessKeySet) {
            problems.add(new ValidationResult.Builder().input("Access Key").valid(false).explanation("If setting Secret Key or Access Key, must set both").build());
        }
        boolean credentialsFileSet = validationContext.getProperty(CREDENTIALS_FILE).isSet();
        if ((secretKeySet || accessKeySet) && credentialsFileSet) {
            problems.add(new ValidationResult.Builder().input("Access Key").valid(false).explanation("Cannot set both Credentials File and Secret Key/Access Key").build());
        }
        boolean proxyHostSet = validationContext.getProperty(PROXY_HOST).isSet();
        boolean proxyPortSet = validationContext.getProperty(PROXY_HOST_PORT).isSet();
        if (proxyHostSet && !proxyPortSet || !proxyHostSet && proxyPortSet) {
            problems.add(new ValidationResult.Builder().subject("Proxy Host and Port").valid(false).explanation("If Proxy Host or Proxy Port is set, both must be set").build());
        }
        boolean proxyUserSet = validationContext.getProperty(PROXY_USERNAME).isSet();
        boolean proxyPwdSet = validationContext.getProperty(PROXY_PASSWORD).isSet();
        if (proxyUserSet && !proxyPwdSet || !proxyUserSet && proxyPwdSet) {
            problems.add(new ValidationResult.Builder().subject("Proxy User and Password").valid(false).explanation("If Proxy Username or Proxy Password is set, both must be set").build());
        }
        if (proxyUserSet && !proxyHostSet) {
            problems.add(new ValidationResult.Builder().subject("Proxy").valid(false).explanation("If Proxy username is set, proxy host must be set").build());
        }
        ProxyConfiguration.validateProxySpec((ValidationContext)validationContext, problems, (ProxySpec[])PROXY_SPECS);
        return problems;
    }

    protected ClientConfiguration createConfiguration(ProcessContext context) {
        ProxyConfiguration proxyConfig;
        SSLContextService sslContextService;
        ClientConfiguration config = new ClientConfiguration();
        config.setMaxConnections(context.getMaxConcurrentTasks());
        config.setMaxErrorRetry(0);
        config.setUserAgent(DEFAULT_USER_AGENT);
        config.setProtocol(DEFAULT_PROTOCOL);
        int commsTimeout = context.getProperty(TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS).intValue();
        config.setConnectionTimeout(commsTimeout);
        config.setSocketTimeout(commsTimeout);
        if (this.getSupportedPropertyDescriptors().contains(SSL_CONTEXT_SERVICE) && (sslContextService = (SSLContextService)context.getProperty(SSL_CONTEXT_SERVICE).asControllerService(SSLContextService.class)) != null) {
            SSLContext sslContext = sslContextService.createSSLContext(SSLContextService.ClientAuth.NONE);
            SdkTLSSocketFactory sdkTLSSocketFactory = new SdkTLSSocketFactory(sslContext, (HostnameVerifier)new DefaultHostnameVerifier());
            config.getApacheHttpClientConfig().setSslSocketFactory((ConnectionSocketFactory)sdkTLSSocketFactory);
        }
        if (Proxy.Type.HTTP.equals((Object)(proxyConfig = ProxyConfiguration.getConfiguration((PropertyContext)context, () -> {
            if (context.getProperty(PROXY_HOST).isSet()) {
                ProxyConfiguration componentProxyConfig = new ProxyConfiguration();
                String proxyHost = context.getProperty(PROXY_HOST).evaluateAttributeExpressions().getValue();
                Integer proxyPort = context.getProperty(PROXY_HOST_PORT).evaluateAttributeExpressions().asInteger();
                String proxyUsername = context.getProperty(PROXY_USERNAME).evaluateAttributeExpressions().getValue();
                String proxyPassword = context.getProperty(PROXY_PASSWORD).evaluateAttributeExpressions().getValue();
                componentProxyConfig.setProxyType(Proxy.Type.HTTP);
                componentProxyConfig.setProxyServerHost(proxyHost);
                componentProxyConfig.setProxyServerPort(proxyPort);
                componentProxyConfig.setProxyUserName(proxyUsername);
                componentProxyConfig.setProxyUserPassword(proxyPassword);
                return componentProxyConfig;
            }
            return ProxyConfiguration.DIRECT_CONFIGURATION;
        })).getProxyType())) {
            config.setProxyHost(proxyConfig.getProxyServerHost());
            config.setProxyPort(proxyConfig.getProxyServerPort().intValue());
            if (proxyConfig.hasCredential()) {
                config.setProxyUsername(proxyConfig.getProxyUserName());
                config.setProxyPassword(proxyConfig.getProxyUserPassword());
            }
        }
        return config;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        ClientType awsClient = this.createClient(context, this.getCredentials(context), this.createConfiguration(context));
        this.client = awsClient;
        this.initializeRegionAndEndpoint(context);
    }

    protected void initializeRegionAndEndpoint(ProcessContext context) {
        String urlstr;
        if (this.getSupportedPropertyDescriptors().contains(REGION)) {
            String region = context.getProperty(REGION).getValue();
            if (region != null) {
                this.region = Region.getRegion((Regions)Regions.fromName((String)region));
                this.client.setRegion(this.region);
            } else {
                this.region = null;
            }
        }
        if (this.getSupportedPropertyDescriptors().contains(ENDPOINT_OVERRIDE) && !(urlstr = StringUtils.trimToEmpty((String)context.getProperty(ENDPOINT_OVERRIDE).evaluateAttributeExpressions().getValue())).isEmpty()) {
            this.getLogger().info("Overriding endpoint with {}", new Object[]{urlstr});
            if (urlstr.endsWith(".vpce.amazonaws.com")) {
                String region = this.parseRegionForVPCE(urlstr);
                this.client.setEndpoint(urlstr, this.client.getServiceName(), region);
            } else {
                this.client.setEndpoint(urlstr);
            }
        }
    }

    private String parseRegionForVPCE(String url) {
        int index = url.length() - ".vpce.amazonaws.com".length();
        Pattern VPCE_ENDPOINT_PATTERN = Pattern.compile("^(?:.+[vpce-][a-z0-9-]+\\.)?([a-z0-9-]+)$");
        Matcher matcher = VPCE_ENDPOINT_PATTERN.matcher(url.substring(0, index));
        if (matcher.matches()) {
            return matcher.group(1);
        }
        this.getLogger().warn("Unable to get a match with the VPCE endpoint pattern; defaulting the region to us-east-1...");
        return "us-east-1";
    }

    @Deprecated
    protected abstract ClientType createClient(ProcessContext var1, AWSCredentials var2, ClientConfiguration var3);

    protected ClientType getClient() {
        return this.client;
    }

    protected Region getRegion() {
        return this.region;
    }

    protected AWSCredentials getCredentials(ProcessContext context) {
        String accessKey = context.getProperty(ACCESS_KEY).evaluateAttributeExpressions().getValue();
        String secretKey = context.getProperty(SECRET_KEY).evaluateAttributeExpressions().getValue();
        String credentialsFile = context.getProperty(CREDENTIALS_FILE).getValue();
        if (credentialsFile != null) {
            try {
                return new PropertiesCredentials(new File(credentialsFile));
            }
            catch (IOException ioe) {
                throw new ProcessException("Could not read Credentials File", (Throwable)ioe);
            }
        }
        if (accessKey != null && secretKey != null) {
            return new BasicAWSCredentials(accessKey, secretKey);
        }
        return new AnonymousAWSCredentials();
    }

    @OnShutdown
    public void onShutdown() {
        if (this.getClient() != null) {
            this.getClient().shutdown();
        }
    }
}

