/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.kinesis;

import com.amazonaws.AmazonWebServiceClient;
import java.util.ArrayList;
import java.util.List;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.aws.AbstractAWSCredentialsProviderProcessor;

public abstract class AbstractBaseKinesisProcessor<ClientType extends AmazonWebServiceClient>
extends AbstractAWSCredentialsProviderProcessor<ClientType> {
    public static final String AWS_KINESIS_ERROR_MESSAGE = "aws.kinesis.error.message";
    public static final PropertyDescriptor BATCH_SIZE = new PropertyDescriptor.Builder().displayName("Message Batch Size").name("message-batch-size").description("Batch size for messages (1-500).").defaultValue("250").required(false).addValidator(StandardValidators.createLongValidator((long)1L, (long)500L, (boolean)true)).sensitive(false).build();
    public static final PropertyDescriptor MAX_MESSAGE_BUFFER_SIZE_MB = new PropertyDescriptor.Builder().name("max-message-buffer-size").displayName("Max message buffer size (MB)").description("Max message buffer size in Mega-bytes").defaultValue("1 MB").required(false).addValidator(StandardValidators.DATA_SIZE_VALIDATOR).sensitive(false).build();
    public static final int MAX_MESSAGE_SIZE = 1024000;

    protected FlowFile handleFlowFileTooBig(ProcessSession session, FlowFile flowFileCandidate, String message) {
        flowFileCandidate = session.putAttribute(flowFileCandidate, message, "record too big " + flowFileCandidate.getSize() + " max allowed " + 1024000);
        session.transfer(flowFileCandidate, REL_FAILURE);
        this.getLogger().error("Failed to publish to kinesis records {} because the size was greater than {} bytes", new Object[]{flowFileCandidate, 1024000});
        return flowFileCandidate;
    }

    protected List<FlowFile> filterMessagesByMaxSize(ProcessSession session, int batchSize, long maxBufferSizeBytes, String message) {
        FlowFile flowFileCandidate;
        ArrayList<FlowFile> flowFiles = new ArrayList<FlowFile>(batchSize);
        long currentBufferSizeBytes = 0L;
        for (int i = 0; i < batchSize && currentBufferSizeBytes <= maxBufferSizeBytes && (flowFileCandidate = session.get()) != null; ++i) {
            if (flowFileCandidate.getSize() > 1024000L) {
                flowFileCandidate = this.handleFlowFileTooBig(session, flowFileCandidate, message);
                continue;
            }
            currentBufferSizeBytes += flowFileCandidate.getSize();
            flowFiles.add(flowFileCandidate);
        }
        return flowFiles;
    }
}

