/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.s3;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.regions.Region;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.S3ClientOptions;
import com.amazonaws.services.s3.model.AccessControlList;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.CanonicalGrantee;
import com.amazonaws.services.s3.model.EmailAddressGrantee;
import com.amazonaws.services.s3.model.Grantee;
import com.amazonaws.services.s3.model.Owner;
import com.amazonaws.services.s3.model.Permission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.aws.AbstractAWSCredentialsProviderProcessor;

public abstract class AbstractS3Processor
extends AbstractAWSCredentialsProviderProcessor<AmazonS3Client> {
    public static final PropertyDescriptor FULL_CONTROL_USER_LIST = new PropertyDescriptor.Builder().name("FullControl User List").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).description("A comma-separated list of Amazon User ID's or E-mail addresses that specifies who should have Full Control for an object").defaultValue("${s3.permissions.full.users}").build();
    public static final PropertyDescriptor READ_USER_LIST = new PropertyDescriptor.Builder().name("Read Permission User List").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).description("A comma-separated list of Amazon User ID's or E-mail addresses that specifies who should have Read Access for an object").defaultValue("${s3.permissions.read.users}").build();
    public static final PropertyDescriptor WRITE_USER_LIST = new PropertyDescriptor.Builder().name("Write Permission User List").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).description("A comma-separated list of Amazon User ID's or E-mail addresses that specifies who should have Write Access for an object").defaultValue("${s3.permissions.write.users}").build();
    public static final PropertyDescriptor READ_ACL_LIST = new PropertyDescriptor.Builder().name("Read ACL User List").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).description("A comma-separated list of Amazon User ID's or E-mail addresses that specifies who should have permissions to read the Access Control List for an object").defaultValue("${s3.permissions.readacl.users}").build();
    public static final PropertyDescriptor WRITE_ACL_LIST = new PropertyDescriptor.Builder().name("Write ACL User List").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).description("A comma-separated list of Amazon User ID's or E-mail addresses that specifies who should have permissions to change the Access Control List for an object").defaultValue("${s3.permissions.writeacl.users}").build();
    public static final PropertyDescriptor CANNED_ACL = new PropertyDescriptor.Builder().name("canned-acl").displayName("Canned ACL").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).description("Amazon Canned ACL for an object, one of: BucketOwnerFullControl, BucketOwnerRead, LogDeliveryWrite, AuthenticatedRead, PublicReadWrite, PublicRead, Private; will be ignored if any other ACL/permission/owner property is specified").defaultValue("${s3.permissions.cannedacl}").build();
    public static final PropertyDescriptor OWNER = new PropertyDescriptor.Builder().name("Owner").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).description("The Amazon ID to use for the object's owner").defaultValue("${s3.owner}").build();
    public static final PropertyDescriptor BUCKET = new PropertyDescriptor.Builder().name("Bucket").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor KEY = new PropertyDescriptor.Builder().name("Object Key").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).defaultValue("${filename}").build();
    public static final PropertyDescriptor SIGNER_OVERRIDE = new PropertyDescriptor.Builder().name("Signer Override").description("The AWS libraries use the default signer but this property allows you to specify a custom signer to support older S3-compatible services.").required(false).allowableValues(new AllowableValue[]{new AllowableValue("Default Signature", "Default Signature"), new AllowableValue("AWSS3V4SignerType", "Signature v4"), new AllowableValue("S3SignerType", "Signature v2")}).defaultValue("Default Signature").build();

    @Override
    protected AmazonS3Client createClient(ProcessContext context, AWSCredentialsProvider credentialsProvider, ClientConfiguration config) {
        this.getLogger().info("Creating client with credentials provider");
        this.initializeSignerOverride(context, config);
        AmazonS3Client s3 = new AmazonS3Client(credentialsProvider, config);
        this.initalizeEndpointOverride(context, s3);
        return s3;
    }

    private void initalizeEndpointOverride(ProcessContext context, AmazonS3Client s3) {
        if (!StringUtils.trimToEmpty((String)context.getProperty(ENDPOINT_OVERRIDE).evaluateAttributeExpressions().getValue()).isEmpty()) {
            S3ClientOptions s3Options = new S3ClientOptions();
            s3Options.setPathStyleAccess(true);
            s3.setS3ClientOptions(s3Options);
        }
    }

    private void initializeSignerOverride(ProcessContext context, ClientConfiguration config) {
        String signer = context.getProperty(SIGNER_OVERRIDE).getValue();
        if (signer != null && !signer.equals(SIGNER_OVERRIDE.getDefaultValue())) {
            config.setSignerOverride(signer);
        }
    }

    @Override
    protected AmazonS3Client createClient(ProcessContext context, AWSCredentials credentials, ClientConfiguration config) {
        this.getLogger().info("Creating client with AWS credentials");
        this.initializeSignerOverride(context, config);
        AmazonS3Client s3 = new AmazonS3Client(credentials, config);
        this.initalizeEndpointOverride(context, s3);
        return s3;
    }

    protected Grantee createGrantee(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        if (value.contains("@")) {
            return new EmailAddressGrantee(value);
        }
        return new CanonicalGrantee(value);
    }

    protected final List<Grantee> createGrantees(String value) {
        String[] vals;
        if (StringUtils.isEmpty((CharSequence)value)) {
            return Collections.emptyList();
        }
        ArrayList<Grantee> grantees = new ArrayList<Grantee>();
        for (String val : vals = value.split(",")) {
            String identifier = val.trim();
            Grantee grantee = this.createGrantee(identifier);
            if (grantee == null) continue;
            grantees.add(grantee);
        }
        return grantees;
    }

    protected String getUrlForObject(String bucket, String key) {
        Region region = this.getRegion();
        if (region == null) {
            return DEFAULT_PROTOCOL.toString() + "://s3.amazonaws.com/" + bucket + "/" + key;
        }
        String endpoint = region.getServiceEndpoint("s3");
        return DEFAULT_PROTOCOL.toString() + "://" + endpoint + "/" + bucket + "/" + key;
    }

    protected final AccessControlList createACL(ProcessContext context, FlowFile flowFile) {
        AccessControlList acl = null;
        String ownerId = context.getProperty(OWNER).evaluateAttributeExpressions(flowFile).getValue();
        if (!StringUtils.isEmpty((CharSequence)ownerId)) {
            Owner owner = new Owner();
            owner.setId(ownerId);
            if (acl == null) {
                acl = new AccessControlList();
            }
            acl.setOwner(owner);
        }
        for (Grantee grantee : this.createGrantees(context.getProperty(FULL_CONTROL_USER_LIST).evaluateAttributeExpressions(flowFile).getValue())) {
            if (acl == null) {
                acl = new AccessControlList();
            }
            acl.grantPermission(grantee, Permission.FullControl);
        }
        for (Grantee grantee : this.createGrantees(context.getProperty(READ_USER_LIST).evaluateAttributeExpressions(flowFile).getValue())) {
            if (acl == null) {
                acl = new AccessControlList();
            }
            acl.grantPermission(grantee, Permission.Read);
        }
        for (Grantee grantee : this.createGrantees(context.getProperty(WRITE_USER_LIST).evaluateAttributeExpressions(flowFile).getValue())) {
            if (acl == null) {
                acl = new AccessControlList();
            }
            acl.grantPermission(grantee, Permission.Write);
        }
        for (Grantee grantee : this.createGrantees(context.getProperty(READ_ACL_LIST).evaluateAttributeExpressions(flowFile).getValue())) {
            if (acl == null) {
                acl = new AccessControlList();
            }
            acl.grantPermission(grantee, Permission.ReadAcp);
        }
        for (Grantee grantee : this.createGrantees(context.getProperty(WRITE_ACL_LIST).evaluateAttributeExpressions(flowFile).getValue())) {
            if (acl == null) {
                acl = new AccessControlList();
            }
            acl.grantPermission(grantee, Permission.WriteAcp);
        }
        return acl;
    }

    protected final CannedAccessControlList createCannedACL(ProcessContext context, FlowFile flowFile) {
        CannedAccessControlList cannedAcl = null;
        String cannedAclString = context.getProperty(CANNED_ACL).evaluateAttributeExpressions(flowFile).getValue();
        if (!StringUtils.isEmpty((CharSequence)cannedAclString)) {
            cannedAcl = CannedAccessControlList.valueOf((String)cannedAclString);
        }
        return cannedAcl;
    }
}

