/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.credentials.provider.factory.strategies;

import com.amazonaws.auth.AWSCredentialsProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.processors.aws.credentials.provider.factory.CredentialsStrategy;

public abstract class AbstractCredentialsStrategy
implements CredentialsStrategy {
    private final String name;
    private final PropertyDescriptor[] requiredProperties;

    public AbstractCredentialsStrategy(String name, PropertyDescriptor[] requiredProperties) {
        this.name = name;
        this.requiredProperties = requiredProperties;
    }

    @Override
    public boolean canCreatePrimaryCredential(Map<PropertyDescriptor, String> properties) {
        for (PropertyDescriptor requiredProperty : this.requiredProperties) {
            boolean containsValue;
            boolean containsRequiredProperty = properties.containsKey(requiredProperty);
            String propertyValue = properties.get(requiredProperty);
            boolean bl = containsValue = propertyValue != null;
            if (containsRequiredProperty && containsValue) continue;
            return false;
        }
        return true;
    }

    @Override
    public Collection<ValidationResult> validate(ValidationContext validationContext, CredentialsStrategy primaryStrategy) {
        boolean thisIsSelectedStrategy = this == primaryStrategy;
        String requiredMessageFormat = "property %1$s must be set with %2$s";
        String excludedMessageFormat = "property %1$s cannot be used with %2$s";
        String failureFormat = thisIsSelectedStrategy ? requiredMessageFormat : excludedMessageFormat;
        ArrayList<ValidationResult> validationFailureResults = null;
        for (PropertyDescriptor requiredProperty : this.requiredProperties) {
            boolean requiredPropertyIsSet = validationContext.getProperty(requiredProperty).isSet();
            if (requiredPropertyIsSet == thisIsSelectedStrategy) continue;
            String message = String.format(failureFormat, requiredProperty.getDisplayName(), primaryStrategy.getName());
            if (validationFailureResults == null) {
                validationFailureResults = new ArrayList<ValidationResult>();
            }
            validationFailureResults.add(new ValidationResult.Builder().subject(requiredProperty.getDisplayName()).valid(false).explanation(message).build());
        }
        return validationFailureResults;
    }

    @Override
    public abstract AWSCredentialsProvider getCredentialsProvider(Map<PropertyDescriptor, String> var1);

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean canCreateDerivedCredential(Map<PropertyDescriptor, String> properties) {
        return false;
    }

    @Override
    public AWSCredentialsProvider getDerivedCredentialsProvider(Map<PropertyDescriptor, String> properties, AWSCredentialsProvider primaryCredentialsProvider) {
        throw new UnsupportedOperationException();
    }
}

