/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.credentials.provider.service;

import com.amazonaws.auth.AWSCredentialsProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.aws.credentials.provider.factory.CredentialPropertyDescriptors;
import org.apache.nifi.processors.aws.credentials.provider.factory.CredentialsProviderFactory;
import org.apache.nifi.processors.aws.credentials.provider.service.AWSCredentialsProviderService;
import org.apache.nifi.reporting.InitializationException;

@CapabilityDescription(value="Defines credentials for Amazon Web Services processors. Uses default credentials without configuration. Default credentials support EC2 instance profile/role, default user profile, environment variables, etc. Additional options include access key / secret key pairs, credentials file, named profile, and assume role credentials.")
@Tags(value={"aws", "credentials", "provider"})
public class AWSCredentialsProviderControllerService
extends AbstractControllerService
implements AWSCredentialsProviderService {
    public static final PropertyDescriptor ASSUME_ROLE_ARN = CredentialPropertyDescriptors.ASSUME_ROLE_ARN;
    public static final PropertyDescriptor ASSUME_ROLE_NAME = CredentialPropertyDescriptors.ASSUME_ROLE_NAME;
    public static final PropertyDescriptor MAX_SESSION_TIME = CredentialPropertyDescriptors.MAX_SESSION_TIME;
    private static final List<PropertyDescriptor> properties;
    private volatile AWSCredentialsProvider credentialsProvider;
    protected final CredentialsProviderFactory credentialsProviderFactory = new CredentialsProviderFactory();

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return properties;
    }

    public AWSCredentialsProvider getCredentialsProvider() throws ProcessException {
        return this.credentialsProvider;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        Collection<ValidationResult> validationFailureResults = this.credentialsProviderFactory.validate(validationContext);
        return validationFailureResults;
    }

    @OnEnabled
    public void onConfigured(ConfigurationContext context) throws InitializationException {
        Map properties = context.getProperties();
        properties.keySet().forEach(propertyDescriptor -> {
            if (propertyDescriptor.isExpressionLanguageSupported()) {
                properties.put(propertyDescriptor, context.getProperty(propertyDescriptor).evaluateAttributeExpressions().getValue());
            }
        });
        this.credentialsProvider = this.credentialsProviderFactory.getCredentialsProvider(properties);
        this.getLogger().debug("Using credentials provider: " + this.credentialsProvider.getClass());
    }

    public String toString() {
        return "AWSCredentialsProviderService[id=" + this.getIdentifier() + "]";
    }

    static {
        ArrayList<PropertyDescriptor> props = new ArrayList<PropertyDescriptor>();
        props.add(CredentialPropertyDescriptors.USE_DEFAULT_CREDENTIALS);
        props.add(CredentialPropertyDescriptors.ACCESS_KEY);
        props.add(CredentialPropertyDescriptors.SECRET_KEY);
        props.add(CredentialPropertyDescriptors.CREDENTIALS_FILE);
        props.add(CredentialPropertyDescriptors.PROFILE_NAME);
        props.add(CredentialPropertyDescriptors.USE_ANONYMOUS_CREDENTIALS);
        props.add(ASSUME_ROLE_ARN);
        props.add(ASSUME_ROLE_NAME);
        props.add(MAX_SESSION_TIME);
        props.add(CredentialPropertyDescriptors.ASSUME_ROLE_EXTERNAL_ID);
        props.add(CredentialPropertyDescriptors.ASSUME_ROLE_PROXY_HOST);
        props.add(CredentialPropertyDescriptors.ASSUME_ROLE_PROXY_PORT);
        properties = Collections.unmodifiableList(props);
    }
}

