/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.kinesis.stream;

import com.amazonaws.services.kinesis.AmazonKinesisClient;
import com.amazonaws.services.kinesis.model.PutRecordsRequest;
import com.amazonaws.services.kinesis.model.PutRecordsRequestEntry;
import com.amazonaws.services.kinesis.model.PutRecordsResult;
import com.amazonaws.services.kinesis.model.PutRecordsResultEntry;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.aws.kinesis.stream.AbstractKinesisStreamProcessor;

@SupportsBatching
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"amazon", "aws", "kinesis", "put", "stream"})
@CapabilityDescription(value="Sends the contents to a specified Amazon Kinesis. In order to send data to Kinesis, the stream name has to be specified.")
@WritesAttributes(value={@WritesAttribute(attribute="aws.kinesis.error.message", description="Error message on posting message to AWS Kinesis"), @WritesAttribute(attribute="aws.kinesis.error.code", description="Error code for the message when posting to AWS Kinesis"), @WritesAttribute(attribute="aws.kinesis.sequence.number", description="Sequence number for the message when posting to AWS Kinesis"), @WritesAttribute(attribute="aws.kinesis.shard.id", description="Shard id of the message posted to AWS Kinesis")})
public class PutKinesisStream
extends AbstractKinesisStreamProcessor {
    public static final String AWS_KINESIS_ERROR_CODE = "aws.kinesis.error.code";
    public static final String AWS_KINESIS_SHARD_ID = "aws.kinesis.shard.id";
    public static final String AWS_KINESIS_SEQUENCE_NUMBER = "aws.kinesis.sequence.number";
    public static final PropertyDescriptor KINESIS_PARTITION_KEY = new PropertyDescriptor.Builder().displayName("Amazon Kinesis Stream Partition Key").name("amazon-kinesis-stream-partition-key").description("The partition key attribute.  If it is not set, a random value is used").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).defaultValue("${kinesis.partition.key}").required(false).addValidator(StandardValidators.ATTRIBUTE_EXPRESSION_LANGUAGE_VALIDATOR).build();
    public static final List<PropertyDescriptor> properties = Collections.unmodifiableList(Arrays.asList(KINESIS_STREAM_NAME, KINESIS_PARTITION_KEY, BATCH_SIZE, MAX_MESSAGE_BUFFER_SIZE_MB, REGION, ACCESS_KEY, SECRET_KEY, CREDENTIALS_FILE, AWS_CREDENTIALS_PROVIDER_SERVICE, TIMEOUT, PROXY_CONFIGURATION_SERVICE, PROXY_HOST, PROXY_HOST_PORT, PROXY_USERNAME, PROXY_PASSWORD, ENDPOINT_OVERRIDE));
    protected Random randomParitionKeyGenerator = new Random();

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return properties;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) {
        int batchSize = context.getProperty(BATCH_SIZE).asInteger();
        long maxBufferSizeBytes = context.getProperty(MAX_MESSAGE_BUFFER_SIZE_MB).asDataSize(DataUnit.B).longValue();
        List flowFiles = this.filterMessagesByMaxSize(session, batchSize, maxBufferSizeBytes, "aws.kinesis.error.message");
        HashMap hashFlowFiles = new HashMap();
        HashMap recordHash = new HashMap();
        AmazonKinesisClient client = (AmazonKinesisClient)this.getClient();
        try {
            String streamName;
            ArrayList<FlowFile> failedFlowFiles = new ArrayList<FlowFile>();
            ArrayList<FlowFile> successfulFlowFiles = new ArrayList<FlowFile>();
            for (int i = 0; i < flowFiles.size(); ++i) {
                FlowFile flowFile = (FlowFile)flowFiles.get(i);
                streamName = context.getProperty(KINESIS_STREAM_NAME).evaluateAttributeExpressions(flowFile).getValue();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                session.exportTo(flowFile, (OutputStream)baos);
                PutRecordsRequestEntry record = new PutRecordsRequestEntry().withData(ByteBuffer.wrap(baos.toByteArray()));
                String partitionKey = context.getProperty(KINESIS_PARTITION_KEY).evaluateAttributeExpressions((FlowFile)flowFiles.get(i)).getValue();
                if (!StringUtils.isBlank((CharSequence)partitionKey)) {
                    record.setPartitionKey(partitionKey);
                } else {
                    record.setPartitionKey(Integer.toString(this.randomParitionKeyGenerator.nextInt()));
                }
                if (!recordHash.containsKey(streamName)) {
                    recordHash.put(streamName, new ArrayList());
                }
                if (!hashFlowFiles.containsKey(streamName)) {
                    hashFlowFiles.put(streamName, new ArrayList());
                }
                ((List)hashFlowFiles.get(streamName)).add(flowFile);
                ((List)recordHash.get(streamName)).add(record);
            }
            for (Map.Entry entryRecord : recordHash.entrySet()) {
                streamName = (String)entryRecord.getKey();
                List records = (List)entryRecord.getValue();
                if (records.size() > 0) {
                    PutRecordsRequest putRecordRequest = new PutRecordsRequest();
                    putRecordRequest.setStreamName(streamName);
                    putRecordRequest.setRecords((Collection)records);
                    PutRecordsResult results = client.putRecords(putRecordRequest);
                    List responseEntries = results.getRecords();
                    for (int i = 0; i < responseEntries.size(); ++i) {
                        PutRecordsResultEntry entry = (PutRecordsResultEntry)responseEntries.get(i);
                        FlowFile flowFile = (FlowFile)((List)hashFlowFiles.get(streamName)).get(i);
                        HashMap<String, String> attributes = new HashMap<String, String>();
                        attributes.put(AWS_KINESIS_SHARD_ID, entry.getShardId());
                        attributes.put(AWS_KINESIS_SEQUENCE_NUMBER, entry.getSequenceNumber());
                        if (!StringUtils.isBlank((CharSequence)entry.getErrorCode())) {
                            attributes.put(AWS_KINESIS_ERROR_CODE, entry.getErrorCode());
                            attributes.put("aws.kinesis.error.message", entry.getErrorMessage());
                            flowFile = session.putAllAttributes(flowFile, attributes);
                            failedFlowFiles.add(flowFile);
                            continue;
                        }
                        flowFile = session.putAllAttributes(flowFile, attributes);
                        successfulFlowFiles.add(flowFile);
                    }
                }
                ((List)recordHash.get(streamName)).clear();
                records.clear();
            }
            if (failedFlowFiles.size() > 0) {
                session.transfer(failedFlowFiles, REL_FAILURE);
                this.getLogger().error("Failed to publish to kinesis records {}", new Object[]{failedFlowFiles});
            }
            if (successfulFlowFiles.size() > 0) {
                session.transfer(successfulFlowFiles, REL_SUCCESS);
                this.getLogger().debug("Successfully published to kinesis records {}", new Object[]{successfulFlowFiles});
            }
        }
        catch (Exception exception) {
            this.getLogger().error("Failed to publish due to exception {} flowfiles {} ", new Object[]{exception, flowFiles});
            session.transfer((Collection)flowFiles, REL_FAILURE);
            context.yield();
        }
    }
}

