/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.azure.storage.queue;

import com.microsoft.azure.storage.CloudStorageAccount;
import com.microsoft.azure.storage.StorageCredentials;
import com.microsoft.azure.storage.StorageCredentialsSharedAccessSignature;
import com.microsoft.azure.storage.queue.CloudQueueClient;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.azure.storage.utils.AzureStorageUtils;

public abstract class AbstractAzureQueueStorage
extends AbstractProcessor {
    public static final PropertyDescriptor QUEUE = new PropertyDescriptor.Builder().name("storage-queue-name").displayName("Queue Name").description("Name of the Azure Storage Queue").required(true).addValidator(StandardValidators.NON_EMPTY_EL_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("All successfully processed FlowFiles are routed to this relationship").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("Unsuccessful operations will be transferred to the failure relationship.").build();
    private static final String FORMAT_QUEUE_CONNECTION_STRING = "DefaultEndpointsProtocol=https;AccountName=%s;AccountKey=%s";
    private static final String FORMAT_QUEUE_BASE_URI = "https://%s.queue.core.windows.net";
    private static final Set<Relationship> relationships = Collections.unmodifiableSet(new HashSet<Relationship>(Arrays.asList(REL_SUCCESS, REL_FAILURE)));

    public Set<Relationship> getRelationships() {
        return relationships;
    }

    protected final CloudQueueClient createCloudQueueClient(ProcessContext context, FlowFile flowFile) {
        CloudQueueClient cloudQueueClient;
        String sasToken;
        String storageAccountKey;
        String storageAccountName;
        if (flowFile == null) {
            storageAccountName = context.getProperty(AzureStorageUtils.ACCOUNT_NAME).evaluateAttributeExpressions().getValue();
            storageAccountKey = context.getProperty(AzureStorageUtils.ACCOUNT_KEY).evaluateAttributeExpressions().getValue();
            sasToken = context.getProperty(AzureStorageUtils.PROP_SAS_TOKEN).evaluateAttributeExpressions().getValue();
        } else {
            storageAccountName = context.getProperty(AzureStorageUtils.ACCOUNT_NAME).evaluateAttributeExpressions(flowFile).getValue();
            storageAccountKey = context.getProperty(AzureStorageUtils.ACCOUNT_KEY).evaluateAttributeExpressions(flowFile).getValue();
            sasToken = context.getProperty(AzureStorageUtils.PROP_SAS_TOKEN).evaluateAttributeExpressions(flowFile).getValue();
        }
        try {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{sasToken})) {
                String connectionString = String.format(FORMAT_QUEUE_BASE_URI, storageAccountName);
                StorageCredentialsSharedAccessSignature storageCredentials = new StorageCredentialsSharedAccessSignature(sasToken);
                cloudQueueClient = new CloudQueueClient(new URI(connectionString), (StorageCredentials)storageCredentials);
            } else {
                String connectionString = String.format(FORMAT_QUEUE_CONNECTION_STRING, storageAccountName, storageAccountKey);
                CloudStorageAccount storageAccount = CloudStorageAccount.parse((String)connectionString);
                cloudQueueClient = storageAccount.createCloudQueueClient();
            }
        }
        catch (IllegalArgumentException | URISyntaxException e) {
            this.getLogger().error("Invalid connection string URI for '{}'", new Object[]{context.getName()}, (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        catch (InvalidKeyException e) {
            this.getLogger().error("Invalid connection credentials for '{}'", new Object[]{context.getName()}, (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        return cloudQueueClient;
    }
}

