/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.azure.storage.utils;

import com.microsoft.azure.storage.CloudStorageAccount;
import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.StorageCredentials;
import com.microsoft.azure.storage.StorageCredentialsSharedAccessSignature;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.proxy.ProxyConfiguration;
import org.apache.nifi.proxy.ProxySpec;

public final class AzureStorageUtils {
    public static final String BLOCK = "Block";
    public static final String PAGE = "Page";
    public static final PropertyDescriptor ACCOUNT_KEY = new PropertyDescriptor.Builder().name("storage-account-key").displayName("Storage Account Key").description("The storage account key. This is an admin-like password providing access to every container in this account. It is recommended one uses Shared Access Signature (SAS) token instead for fine-grained control with policies. There are certain risks in allowing the account key to be stored as a flowfile attribute. While it does provide for a more flexible flow by allowing the account key to be fetched dynamically from a flow file attribute, care must be taken to restrict access to the event provenance data (e.g. by strictly controlling the policies governing provenance for this Processor). In addition, the provenance repositories may be put on encrypted disk partitions.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(false).sensitive(true).build();
    public static final PropertyDescriptor ACCOUNT_NAME = new PropertyDescriptor.Builder().name("storage-account-name").displayName("Storage Account Name").description("The storage account name.  There are certain risks in allowing the account name to be stored as a flowfile attribute. While it does provide for a more flexible flow by allowing the account name to be fetched dynamically from a flowfile attribute, care must be taken to restrict access to the event provenance data (e.g. by strictly controlling the policies governing provenance for this Processor). In addition, the provenance repositories may be put on encrypted disk partitions.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(true).sensitive(true).build();
    public static final PropertyDescriptor CONTAINER = new PropertyDescriptor.Builder().name("container-name").displayName("Container Name").description("Name of the Azure storage container").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(true).build();
    public static final PropertyDescriptor PROP_SAS_TOKEN = new PropertyDescriptor.Builder().name("storage-sas-token").displayName("SAS Token").description("Shared Access Signature token, including the leading '?'. Specify either SAS Token (recommended) or Account Key. There are certain risks in allowing the SAS token to be stored as a flowfile attribute. While it does provide for a more flexible flow by allowing the account name to be fetched dynamically from a flowfile attribute, care must be taken to restrict access to the event provenance data (e.g. by strictly controlling the policies governing provenance for this Processor). In addition, the provenance repositories may be put on encrypted disk partitions.").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).sensitive(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final String FORMAT_BLOB_CONNECTION_STRING = "DefaultEndpointsProtocol=https;AccountName=%s;AccountKey=%s";
    public static final String FORMAT_BASE_URI = "https://%s.blob.core.windows.net";
    private static final ProxySpec[] PROXY_SPECS = new ProxySpec[]{ProxySpec.HTTP, ProxySpec.SOCKS};
    public static final PropertyDescriptor PROXY_CONFIGURATION_SERVICE = ProxyConfiguration.createProxyConfigPropertyDescriptor((boolean)false, (ProxySpec[])PROXY_SPECS);

    private AzureStorageUtils() {
    }

    public static CloudBlobClient createCloudBlobClient(ProcessContext context, ComponentLog logger, FlowFile flowFile) {
        CloudBlobClient cloudBlobClient;
        String sasToken;
        String accountKey;
        String accountName;
        if (flowFile == null) {
            accountName = context.getProperty(ACCOUNT_NAME).evaluateAttributeExpressions().getValue();
            accountKey = context.getProperty(ACCOUNT_KEY).evaluateAttributeExpressions().getValue();
            sasToken = context.getProperty(PROP_SAS_TOKEN).evaluateAttributeExpressions().getValue();
        } else {
            accountName = context.getProperty(ACCOUNT_NAME).evaluateAttributeExpressions(flowFile).getValue();
            accountKey = context.getProperty(ACCOUNT_KEY).evaluateAttributeExpressions(flowFile).getValue();
            sasToken = context.getProperty(PROP_SAS_TOKEN).evaluateAttributeExpressions(flowFile).getValue();
        }
        try {
            if (StringUtils.isNotBlank((CharSequence)sasToken)) {
                String storageConnectionString = String.format(FORMAT_BASE_URI, accountName);
                StorageCredentialsSharedAccessSignature creds = new StorageCredentialsSharedAccessSignature(sasToken);
                cloudBlobClient = new CloudBlobClient(new URI(storageConnectionString), (StorageCredentials)creds);
            } else {
                String blobConnString = String.format(FORMAT_BLOB_CONNECTION_STRING, accountName, accountKey);
                CloudStorageAccount storageAccount = CloudStorageAccount.parse((String)blobConnString);
                cloudBlobClient = storageAccount.createCloudBlobClient();
            }
        }
        catch (IllegalArgumentException | URISyntaxException e) {
            logger.error("Invalid connection string URI for '{}'", new Object[]{context.getName()}, (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        catch (InvalidKeyException e) {
            logger.error("Invalid connection credentials for '{}'", new Object[]{context.getName()}, (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        return cloudBlobClient;
    }

    public static Collection<ValidationResult> validateCredentialProperties(ValidationContext validationContext) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        String sasToken = validationContext.getProperty(PROP_SAS_TOKEN).getValue();
        String acctName = validationContext.getProperty(ACCOUNT_KEY).getValue();
        if (StringUtils.isBlank((CharSequence)sasToken) && StringUtils.isBlank((CharSequence)acctName) || StringUtils.isNotBlank((CharSequence)sasToken) && StringUtils.isNotBlank((CharSequence)acctName)) {
            results.add(new ValidationResult.Builder().subject("AzureStorageUtils Credentials").valid(false).explanation("either Azure Account Key or Shared Access Signature required, but not both").build());
        }
        return results;
    }

    public static void validateProxySpec(ValidationContext context, Collection<ValidationResult> results) {
        ProxyConfiguration.validateProxySpec((ValidationContext)context, results, (ProxySpec[])PROXY_SPECS);
    }

    public static void setProxy(OperationContext operationContext, ProcessContext processContext) {
        ProxyConfiguration proxyConfig = ProxyConfiguration.getConfiguration((PropertyContext)processContext);
        operationContext.setProxy(proxyConfig.createProxy());
    }
}

