/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.azure.storage.utils;

import java.io.Serializable;
import org.apache.nifi.processor.util.list.ListableEntity;

public class BlobInfo
implements Comparable<BlobInfo>,
Serializable,
ListableEntity {
    private static final long serialVersionUID = 1L;
    private final String primaryUri;
    private final String secondaryUri;
    private final String contentType;
    private final String contentLanguage;
    private final String etag;
    private final long lastModifiedTime;
    private final long length;
    private final String blobType;
    private final String blobName;
    private final String containerName;

    public static long getSerialversionuid() {
        return 1L;
    }

    public String getPrimaryUri() {
        return this.primaryUri;
    }

    public String getSecondaryUri() {
        return this.secondaryUri;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getContentLanguage() {
        return this.contentLanguage;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public String getBlobName() {
        return this.blobName;
    }

    public String getEtag() {
        return this.etag;
    }

    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public long getLength() {
        return this.length;
    }

    public String getBlobType() {
        return this.blobType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.etag == null ? 0 : this.etag.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BlobInfo other = (BlobInfo)obj;
        return !(this.etag == null ? other.etag != null : !this.etag.equals(other.etag));
    }

    @Override
    public int compareTo(BlobInfo o) {
        return this.etag.compareTo(o.etag);
    }

    private BlobInfo(Builder builder) {
        this.primaryUri = builder.primaryUri;
        this.secondaryUri = builder.secondaryUri;
        this.contentType = builder.contentType;
        this.contentLanguage = builder.contentLanguage;
        this.containerName = builder.containerName;
        this.etag = builder.etag;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.length = builder.length;
        this.blobType = builder.blobType;
        this.blobName = builder.blobName;
    }

    public String getName() {
        String primaryUri = this.getPrimaryUri();
        return primaryUri.substring(primaryUri.lastIndexOf(47) + 1);
    }

    public String getIdentifier() {
        return this.getPrimaryUri();
    }

    public long getTimestamp() {
        return this.getLastModifiedTime();
    }

    public long getSize() {
        return this.length;
    }

    public static final class Builder {
        private String primaryUri;
        private String secondaryUri;
        private String contentType;
        private String contentLanguage;
        private String etag;
        private long lastModifiedTime;
        private long length;
        private String blobType;
        private String containerName;
        private String blobName;

        public Builder primaryUri(String primaryUri) {
            this.primaryUri = primaryUri;
            return this;
        }

        public Builder secondaryUri(String secondaryUri) {
            this.secondaryUri = secondaryUri;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder contentLanguage(String contentLanguage) {
            this.contentLanguage = contentLanguage;
            return this;
        }

        public Builder containerName(String containerName) {
            this.containerName = containerName;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder lastModifiedTime(long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public Builder length(long length) {
            this.length = length;
            return this;
        }

        public Builder blobType(String blobType) {
            this.blobType = blobType;
            return this;
        }

        public Builder blobName(String blobName) {
            this.blobName = blobName;
            return this;
        }

        public BlobInfo build() {
            return new BlobInfo(this);
        }
    }
}

