/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.dto;

import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.nifi.web.api.dto.NodeEventDTO;
import org.apache.nifi.web.api.dto.util.DateTimeAdapter;

@XmlType(name="node")
public class NodeDTO {
    private String nodeId;
    private String address;
    private Integer apiPort;
    private String status;
    private Date heartbeat;
    private Date connectionRequested;
    private Set<String> roles;
    private Integer activeThreadCount;
    private String queued;
    private List<NodeEventDTO> events;
    private Date nodeStartTime;

    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    @ApiModelProperty(value="the time of the nodes's last heartbeat.", readOnly=true, dataType="string")
    public Date getHeartbeat() {
        return this.heartbeat;
    }

    public void setHeartbeat(Date heartbeat) {
        this.heartbeat = heartbeat;
    }

    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    @ApiModelProperty(value="The time of the node's last connection request.", readOnly=true, dataType="string")
    public Date getConnectionRequested() {
        return this.connectionRequested;
    }

    public void setConnectionRequested(Date connectionRequested) {
        this.connectionRequested = connectionRequested;
    }

    @ApiModelProperty(value="The active threads for the NiFi on the node.", readOnly=true)
    public Integer getActiveThreadCount() {
        return this.activeThreadCount;
    }

    public void setActiveThreadCount(Integer activeThreadCount) {
        this.activeThreadCount = activeThreadCount;
    }

    @ApiModelProperty(value="The queue the NiFi on the node.", readOnly=true)
    public String getQueued() {
        return this.queued;
    }

    public void setQueued(String queued) {
        this.queued = queued;
    }

    @ApiModelProperty(value="The node's host/ip address.", readOnly=true)
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    @ApiModelProperty(value="The id of the node.", readOnly=true)
    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    @ApiModelProperty(value="The port the node is listening for API requests.", readOnly=true)
    public Integer getApiPort() {
        return this.apiPort;
    }

    public void setApiPort(Integer port) {
        this.apiPort = port;
    }

    @ApiModelProperty(value="The node's status.")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @ApiModelProperty(value="The node's events.", readOnly=true)
    public List<NodeEventDTO> getEvents() {
        return this.events;
    }

    public void setEvents(List<NodeEventDTO> events) {
        this.events = events;
    }

    @ApiModelProperty(value="The roles of this node.", readOnly=true)
    public Set<String> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    @ApiModelProperty(value="The time at which this Node was last refreshed.", readOnly=true, dataType="string")
    public Date getNodeStartTime() {
        return this.nodeStartTime;
    }

    public void setNodeStartTime(Date nodeStartTime) {
        this.nodeStartTime = nodeStartTime;
    }
}

