/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.confluent.schemaregistry.client;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.IOException;
import java.time.Duration;
import org.apache.nifi.confluent.schemaregistry.client.SchemaRegistryClient;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.record.RecordSchema;

public class CachingSchemaRegistryClient
implements SchemaRegistryClient {
    private final SchemaRegistryClient client;
    private final LoadingCache<String, RecordSchema> nameCache;
    private final LoadingCache<Integer, RecordSchema> idCache;

    public CachingSchemaRegistryClient(SchemaRegistryClient toWrap, int cacheSize, long expirationNanos) {
        this.client = toWrap;
        this.nameCache = Caffeine.newBuilder().maximumSize((long)cacheSize).expireAfterWrite(Duration.ofNanos(expirationNanos)).build(this.client::getSchema);
        this.idCache = Caffeine.newBuilder().maximumSize((long)cacheSize).expireAfterWrite(Duration.ofNanos(expirationNanos)).build(this.client::getSchema);
    }

    @Override
    public RecordSchema getSchema(String schemaName) throws IOException, SchemaNotFoundException {
        return (RecordSchema)this.nameCache.get((Object)schemaName);
    }

    @Override
    public RecordSchema getSchema(int schemaId) throws IOException, SchemaNotFoundException {
        return (RecordSchema)this.idCache.get((Object)schemaId);
    }
}

