/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.confluent.schemaregistry.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.apache.avro.Schema;
import org.apache.avro.SchemaParseException;
import org.apache.nifi.avro.AvroTypeUtil;
import org.apache.nifi.confluent.schemaregistry.client.SchemaRegistryClient;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.SchemaIdentifier;
import org.apache.nifi.web.util.WebUtils;
import org.glassfish.jersey.client.ClientConfig;

public class RestSchemaRegistryClient
implements SchemaRegistryClient {
    private final List<String> baseUrls;
    private final Client client;
    private final ComponentLog logger;
    private static final String SUBJECT_FIELD_NAME = "subject";
    private static final String VERSION_FIELD_NAME = "version";
    private static final String ID_FIELD_NAME = "id";
    private static final String SCHEMA_TEXT_FIELD_NAME = "schema";
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String SCHEMA_REGISTRY_CONTENT_TYPE = "application/vnd.schemaregistry.v1+json";

    public RestSchemaRegistryClient(List<String> baseUrls, int timeoutMillis, SSLContext sslContext, ComponentLog logger) {
        this.baseUrls = new ArrayList<String>(baseUrls);
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.property("jersey.config.client.connectTimeout", (Object)timeoutMillis);
        clientConfig.property("jersey.config.client.readTimeout", (Object)timeoutMillis);
        this.client = WebUtils.createClient((ClientConfig)clientConfig, (SSLContext)sslContext);
        this.logger = logger;
    }

    @Override
    public RecordSchema getSchema(String schemaName) throws IOException, SchemaNotFoundException {
        String pathSuffix = this.getSubjectPath(schemaName);
        JsonNode responseJson = this.fetchJsonResponse(pathSuffix, "name " + schemaName);
        RecordSchema recordSchema = this.createRecordSchema(responseJson);
        return recordSchema;
    }

    @Override
    public RecordSchema getSchema(int schemaId) throws IOException, SchemaNotFoundException {
        String schemaPath = this.getSchemaPath(schemaId);
        JsonNode responseJson = this.fetchJsonResponse(schemaPath, "id " + schemaId);
        JsonNode subjectsJson = this.fetchJsonResponse("/subjects", "subjects array");
        ArrayNode subjectsList = (ArrayNode)subjectsJson;
        JsonNode completeSchema = null;
        for (JsonNode subject : subjectsList) {
            try {
                String subjectName = subject.asText();
                completeSchema = this.postJsonResponse("/subjects/" + subjectName, responseJson, "schema id: " + schemaId);
                break;
            }
            catch (SchemaNotFoundException e) {
            }
        }
        if (completeSchema == null) {
            throw new SchemaNotFoundException("could not get schema with id: " + schemaId);
        }
        RecordSchema recordSchema = this.createRecordSchema(completeSchema);
        return recordSchema;
    }

    private RecordSchema createRecordSchema(JsonNode schemaNode) throws SchemaNotFoundException {
        String subject = schemaNode.get(SUBJECT_FIELD_NAME).asText();
        int version = schemaNode.get(VERSION_FIELD_NAME).asInt();
        int id = schemaNode.get(ID_FIELD_NAME).asInt();
        String schemaText = schemaNode.get(SCHEMA_TEXT_FIELD_NAME).asText();
        try {
            Schema avroSchema = new Schema.Parser().parse(schemaText);
            SchemaIdentifier schemaId = SchemaIdentifier.builder().name(subject).id(Long.valueOf(id)).version(Integer.valueOf(version)).build();
            RecordSchema recordSchema = AvroTypeUtil.createSchema((Schema)avroSchema, (String)schemaText, (SchemaIdentifier)schemaId);
            return recordSchema;
        }
        catch (SchemaParseException spe) {
            throw new SchemaNotFoundException("Obtained Schema with id " + id + " and name " + subject + " from Confluent Schema Registry but the Schema Text that was returned is not a valid Avro Schema");
        }
    }

    private String getSubjectPath(String schemaName) throws UnsupportedEncodingException {
        return "/subjects/" + URLEncoder.encode(schemaName, "UTF-8") + "/versions/latest";
    }

    private String getSchemaPath(int schemaId) throws UnsupportedEncodingException {
        return "/schemas/ids/" + URLEncoder.encode(String.valueOf(schemaId), "UTF-8");
    }

    private JsonNode postJsonResponse(String pathSuffix, JsonNode schema, String schemaDescription) throws SchemaNotFoundException {
        String errorMessage = null;
        for (String baseUrl : this.baseUrls) {
            String path = this.getPath(pathSuffix);
            String trimmedBase = this.getTrimmedBase(baseUrl);
            String url = trimmedBase + path;
            WebTarget builder = this.client.target(url);
            Response response = builder.request().accept(new String[]{"application/json"}).header(CONTENT_TYPE_HEADER, (Object)SCHEMA_REGISTRY_CONTENT_TYPE).post(Entity.json((Object)schema.toString()));
            int responseCode = response.getStatus();
            if (responseCode == Response.Status.NOT_FOUND.getStatusCode() || responseCode != Response.Status.OK.getStatusCode()) continue;
            JsonNode responseJson = (JsonNode)response.readEntity(JsonNode.class);
            return responseJson;
        }
        throw new SchemaNotFoundException("Failed to retrieve Schema with " + schemaDescription + " from any of the Confluent Schema Registry URL's provided; failure response message: " + errorMessage);
    }

    private JsonNode fetchJsonResponse(String pathSuffix, String schemaDescription) throws SchemaNotFoundException, IOException {
        String errorMessage = null;
        for (String baseUrl : this.baseUrls) {
            String path = this.getPath(pathSuffix);
            String trimmedBase = this.getTrimmedBase(baseUrl);
            String url = trimmedBase + path;
            WebTarget webTarget = this.client.target(url);
            Response response = webTarget.request().accept(new String[]{"application/json"}).get();
            int responseCode = response.getStatus();
            if (responseCode == Response.Status.OK.getStatusCode()) {
                JsonNode responseJson = (JsonNode)response.readEntity(JsonNode.class);
                return responseJson;
            }
            if (responseCode == Response.Status.NOT_FOUND.getStatusCode()) {
                throw new SchemaNotFoundException("Could not find Schema with " + schemaDescription + " from the Confluent Schema Registry located at " + baseUrl);
            }
            if (errorMessage != null) continue;
            errorMessage = (String)response.readEntity(String.class);
        }
        throw new IOException("Failed to retrieve Schema with " + schemaDescription + " from any of the Confluent Schema Registry URL's provided; failure response message: " + errorMessage);
    }

    private String getTrimmedBase(String baseUrl) {
        return baseUrl.endsWith("/") ? baseUrl.substring(0, baseUrl.length() - 1) : baseUrl;
    }

    private String getPath(String pathSuffix) {
        return pathSuffix.startsWith("/") ? pathSuffix : "/" + pathSuffix;
    }
}

