/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.cybersecurity;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.nifi.annotation.behavior.EventDriven;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.cybersecurity.AbstractFuzzyHashProcessor;
import org.apache.nifi.processors.cybersecurity.FuzzyHashContent;
import org.apache.nifi.processors.cybersecurity.matchers.FuzzyHashMatcher;
import org.apache.nifi.processors.cybersecurity.matchers.SSDeepHashMatcher;
import org.apache.nifi.processors.cybersecurity.matchers.TLSHHashMatcher;
import org.apache.nifi.util.StringUtils;

@EventDriven
@SideEffectFree
@SupportsBatching
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@SeeAlso(value={FuzzyHashContent.class})
@Tags(value={"hashing", "fuzzy-hashing", "cyber-security"})
@CapabilityDescription(value="Compares an attribute containing a Fuzzy Hash against a file containing a list of fuzzy hashes, appending an attribute to the FlowFile in case of a successful match.")
@WritesAttributes(value={@WritesAttribute(attribute="XXXX.N.match", description="The match that resembles the attribute specified by the <Hash Attribute Name> property. Note that: 'XXX' gets replaced with the <Hash Attribute Name>"), @WritesAttribute(attribute="XXXX.N.similarity", description="The similarity score between this flowfileand its match of the same number N. Note that: 'XXX' gets replaced with the <Hash Attribute Name>")})
public class CompareFuzzyHash
extends AbstractFuzzyHashProcessor {
    public static final AllowableValue singleMatch = new AllowableValue("single", "single", "Send FlowFile to matched after the first match above threshold");
    public static final AllowableValue multiMatch = new AllowableValue("multi-match", "multi-match", "Iterate full list of hashes before deciding to send FlowFile to matched or unmatched");
    public static final PropertyDescriptor HASH_LIST_FILE = new PropertyDescriptor.Builder().name("HASH_LIST_FILE").displayName("Hash List source file").description("Path to the file containing hashes to be validated against").required(true).addValidator(StandardValidators.FILE_EXISTS_VALIDATOR).build();
    public static final PropertyDescriptor MATCH_THRESHOLD = new PropertyDescriptor.Builder().name("MATCH_THRESHOLD").displayName("Match threshold").description("The similarity score must exceed or be equal to in order formatch to be considered true. Refer to Additional Information for differences between TLSH and SSDEEP scores and how they relate to this property.").required(true).addValidator(StandardValidators.NUMBER_VALIDATOR).build();
    public static final PropertyDescriptor MATCHING_MODE = new PropertyDescriptor.Builder().name("MATCHING_MODE").displayName("Matching mode").description("Defines if the Processor should try to match as many entries as possible (" + multiMatch.getDisplayName() + ") or if it should stop after the first match (" + singleMatch.getDisplayName() + ")").required(true).allowableValues(new AllowableValue[]{singleMatch, multiMatch}).defaultValue(singleMatch.getValue()).build();
    public static final Relationship REL_FOUND = new Relationship.Builder().name("found").description("Any FlowFile that is successfully matched to an existing hash will be sent to this Relationship.").build();
    public static final Relationship REL_NOT_FOUND = new Relationship.Builder().name("not-found").description("Any FlowFile that cannot be matched to an existing hash will be sent to this Relationship.").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("Any FlowFile that cannot be matched, e.g. (lacks the attribute) will be sent to this Relationship.").build();

    protected void init(ProcessorInitializationContext context) {
        ArrayList<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>();
        descriptors.add(HASH_LIST_FILE);
        descriptors.add(HASH_ALGORITHM);
        descriptors.add(ATTRIBUTE_NAME);
        descriptors.add(MATCH_THRESHOLD);
        descriptors.add(MATCHING_MODE);
        this.descriptors = Collections.unmodifiableList(descriptors);
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        relationships.add(REL_FOUND);
        relationships.add(REL_NOT_FOUND);
        relationships.add(REL_FAILURE);
        this.relationships = Collections.unmodifiableSet(relationships);
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    public final List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.descriptors;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        ComponentLog logger = this.getLogger();
        String algorithm = context.getProperty(HASH_ALGORITHM).getValue();
        String attributeName = context.getProperty(ATTRIBUTE_NAME).getValue();
        String inputHash = flowFile.getAttribute(attributeName);
        if (inputHash == null) {
            this.getLogger().info("FlowFile {} lacks the required '{}' attribute, routing to failure.", new Object[]{flowFile, attributeName});
            session.transfer(flowFile, REL_FAILURE);
            return;
        }
        FuzzyHashMatcher fuzzyHashMatcher = null;
        switch (algorithm) {
            case "tlsh": {
                fuzzyHashMatcher = new TLSHHashMatcher(this.getLogger());
                break;
            }
            case "ssdeep": {
                fuzzyHashMatcher = new SSDeepHashMatcher(this.getLogger());
                break;
            }
            default: {
                this.getLogger().error("Seems like the processor is configured to use unsupported algorithm '{}' ? Yielding.", new Object[]{algorithm});
                context.yield();
                return;
            }
        }
        if (!fuzzyHashMatcher.isValidHash(inputHash)) {
            logger.error("Invalid hash provided. Sending to failure");
            session.transfer(flowFile, REL_FAILURE);
            session.commit();
            return;
        }
        double similarity = 0.0;
        double matchThreshold = context.getProperty(MATCH_THRESHOLD).asDouble();
        try {
            ConcurrentHashMap<String, Double> matched = new ConcurrentHashMap<String, Double>();
            BufferedReader reader = fuzzyHashMatcher.getReader(context.getProperty(HASH_LIST_FILE).getValue());
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (line != null && fuzzyHashMatcher.matchExceedsThreshold(similarity = fuzzyHashMatcher.getSimilarity(inputHash, line), matchThreshold)) {
                    String match = fuzzyHashMatcher.getMatch(line);
                    if (!StringUtils.isEmpty((String)match)) {
                        matched.put(match, similarity);
                    } else {
                        logger.error("Found a match against a malformed entry '{}'. Please inspect the contents ofthe {} file and ensure they are properly formatted", new Object[]{line, HASH_LIST_FILE.getDisplayName()});
                    }
                }
                if (context.getProperty(MATCHING_MODE).getValue() != singleMatch.getValue() || matched.size() <= 0) continue;
            }
            ConcurrentHashMap attributes = new ConcurrentHashMap();
            if (matched.size() > 0) {
                int x = 0;
                for (Map.Entry entry : matched.entrySet()) {
                    attributes.put(attributeName + "." + x + ".match", entry.getKey());
                    attributes.put(attributeName + "." + x + ".similarity", String.valueOf(entry.getValue()));
                    ++x;
                }
                flowFile = session.putAllAttributes(flowFile, attributes);
                session.transfer(flowFile, REL_FOUND);
                session.commit();
                return;
            }
            session.transfer(flowFile, REL_NOT_FOUND);
            session.commit();
            return;
        }
        catch (IOException e) {
            logger.error("Error while reading the hash input source");
            context.yield();
            return;
        }
    }
}

