/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance;

import java.util.Collection;
import java.util.Date;
import java.util.UUID;
import org.apache.nifi.provenance.StandardLineageResult;
import org.apache.nifi.provenance.lineage.ComputeLineageSubmission;
import org.apache.nifi.provenance.lineage.LineageComputationType;

public class AsyncLineageSubmission
implements ComputeLineageSubmission {
    private final String lineageIdentifier = UUID.randomUUID().toString();
    private final Date submissionTime = new Date();
    private final LineageComputationType computationType;
    private final Long eventId;
    private final Collection<String> lineageFlowFileUuids;
    private volatile boolean canceled = false;
    private final StandardLineageResult result;

    public AsyncLineageSubmission(LineageComputationType computationType, Long eventId, Collection<String> lineageFlowFileUuids, int numSteps) {
        this.computationType = computationType;
        this.eventId = eventId;
        this.lineageFlowFileUuids = lineageFlowFileUuids;
        this.result = new StandardLineageResult(numSteps, lineageFlowFileUuids);
    }

    public StandardLineageResult getResult() {
        return this.result;
    }

    public Date getSubmissionTime() {
        return this.submissionTime;
    }

    public String getLineageIdentifier() {
        return this.lineageIdentifier;
    }

    public void cancel() {
        this.canceled = true;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public LineageComputationType getLineageComputationType() {
        return this.computationType;
    }

    public Long getExpandedEventId() {
        return this.eventId;
    }

    public Collection<String> getLineageFlowFileUuids() {
        return this.lineageFlowFileUuids;
    }
}

