/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.provenance.StandardQueryResult;
import org.apache.nifi.provenance.search.Query;
import org.apache.nifi.provenance.search.QuerySubmission;

public class AsyncQuerySubmission
implements QuerySubmission {
    public static final int TTL = (int)TimeUnit.MILLISECONDS.convert(60L, TimeUnit.SECONDS);
    private final Date submissionTime = new Date();
    private final Query query;
    private volatile boolean canceled = false;
    private final StandardQueryResult queryResult;

    public AsyncQuerySubmission(Query query, int numSteps) {
        this.query = query;
        this.queryResult = new StandardQueryResult(query, numSteps);
    }

    public Date getSubmissionTime() {
        return this.submissionTime;
    }

    public String getQueryIdentifier() {
        return this.query.getIdentifier();
    }

    public void cancel() {
        this.canceled = true;
        this.queryResult.cancel();
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public Query getQuery() {
        return this.query;
    }

    public StandardQueryResult getResult() {
        return this.queryResult;
    }
}

