/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.lineage.ComputeLineageResult;
import org.apache.nifi.provenance.lineage.EdgeNode;
import org.apache.nifi.provenance.lineage.EventNode;
import org.apache.nifi.provenance.lineage.FlowFileNode;
import org.apache.nifi.provenance.lineage.LineageEdge;
import org.apache.nifi.provenance.lineage.LineageNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardLineageResult
implements ComputeLineageResult {
    public static final int TTL = (int)TimeUnit.MILLISECONDS.convert(30L, TimeUnit.MINUTES);
    private static final Logger logger = LoggerFactory.getLogger(StandardLineageResult.class);
    private final Collection<String> flowFileUuids;
    private final Collection<ProvenanceEventRecord> relevantRecords = new ArrayList<ProvenanceEventRecord>();
    private final Set<LineageNode> nodes = new HashSet<LineageNode>();
    private final Set<LineageEdge> edges = new HashSet<LineageEdge>();
    private final int numSteps;
    private final long creationNanos;
    private long computationNanos;
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwLock.readLock();
    private final Lock writeLock = this.rwLock.writeLock();
    private Date expirationDate = null;
    private String error = null;
    private int numCompletedSteps = 0;
    private volatile boolean canceled = false;

    public StandardLineageResult(int numSteps, Collection<String> flowFileUuids) {
        this.numSteps = numSteps;
        this.creationNanos = System.nanoTime();
        this.flowFileUuids = flowFileUuids;
        this.updateExpiration();
    }

    public List<LineageNode> getNodes() {
        this.readLock.lock();
        try {
            ArrayList<LineageNode> arrayList = new ArrayList<LineageNode>(this.nodes);
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public List<LineageEdge> getEdges() {
        this.readLock.lock();
        try {
            ArrayList<LineageEdge> arrayList = new ArrayList<LineageEdge>(this.edges);
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public int getNumberOfEdges() {
        this.readLock.lock();
        try {
            int n = this.edges.size();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public int getNumberOfNodes() {
        this.readLock.lock();
        try {
            int n = this.nodes.size();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getComputationTime(TimeUnit timeUnit) {
        this.readLock.lock();
        try {
            long l = timeUnit.convert(this.computationNanos, TimeUnit.NANOSECONDS);
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Date getExpiration() {
        this.readLock.lock();
        try {
            Date date = this.expirationDate;
            return date;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String getError() {
        this.readLock.lock();
        try {
            String string = this.error;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public int getPercentComplete() {
        this.readLock.lock();
        try {
            int n = this.numSteps < 1 ? 100 : (int)((float)this.numCompletedSteps / (float)this.numSteps * 100.0f);
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean isFinished() {
        this.readLock.lock();
        try {
            boolean bl = this.numCompletedSteps >= this.numSteps || this.canceled;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setError(String error) {
        this.writeLock.lock();
        try {
            this.error = error;
            ++this.numCompletedSteps;
            this.updateExpiration();
            if (this.numCompletedSteps >= this.numSteps) {
                this.computationNanos = System.nanoTime() - this.creationNanos;
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void update(Collection<ProvenanceEventRecord> records) {
        this.writeLock.lock();
        try {
            this.relevantRecords.addAll(records);
            ++this.numCompletedSteps;
            this.updateExpiration();
            if (this.numCompletedSteps >= this.numSteps && this.error == null) {
                this.computeLineage();
                this.computationNanos = System.nanoTime() - this.creationNanos;
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void computeLineage() {
        long startNanos = System.nanoTime();
        this.nodes.clear();
        this.edges.clear();
        HashMap<String, Object> lastEventMap = new HashMap<String, Object>();
        ArrayList<ProvenanceEventRecord> sortedRecords = new ArrayList<ProvenanceEventRecord>(this.relevantRecords);
        Collections.sort(sortedRecords, new Comparator<ProvenanceEventRecord>(){

            @Override
            public int compare(ProvenanceEventRecord o1, ProvenanceEventRecord o2) {
                int eventTimeComparison = Long.compare(o1.getEventTime(), o2.getEventTime());
                if (eventTimeComparison == 0) {
                    return Long.compare(o1.getEventId(), o2.getEventId());
                }
                return eventTimeComparison;
            }
        });
        block7: for (ProvenanceEventRecord record : sortedRecords) {
            LineageNode lastNode;
            EventNode lineageNode = new EventNode(record);
            boolean added = this.nodes.add((LineageNode)lineageNode);
            if (!added) {
                logger.debug("Did not add {} because it already exists in the 'nodes' set", (Object)lineageNode);
            }
            if ((lastNode = (LineageNode)lastEventMap.get(record.getFlowFileUuid())) != null) {
                Iterator edgeUuid;
                switch (record.getEventType()) {
                    case JOIN: 
                    case CLONE: 
                    case REPLAY: {
                        edgeUuid = lastNode.getFlowFileUuid();
                        break;
                    }
                    default: {
                        edgeUuid = record.getFlowFileUuid();
                    }
                }
                this.edges.add(new EdgeNode((String)((Object)edgeUuid), lastNode, (LineageNode)lineageNode));
            }
            lastEventMap.put(record.getFlowFileUuid(), lineageNode);
            switch (record.getEventType()) {
                case JOIN: 
                case CLONE: 
                case REPLAY: 
                case FORK: 
                case FETCH: {
                    for (String childUuid : record.getChildUuids()) {
                        if (!this.flowFileUuids.contains(childUuid)) continue;
                        FlowFileNode childNode = new FlowFileNode(childUuid, record.getEventTime());
                        boolean isNewFlowFile = this.nodes.add(childNode);
                        if (!isNewFlowFile) {
                            String msg = "Unable to generate Lineage Graph because multiple events were registered claiming to have generated the same FlowFile (UUID = " + childNode.getFlowFileUuid() + ")";
                            logger.error(msg);
                            this.setError(msg);
                            return;
                        }
                        this.edges.add(new EdgeNode(childNode.getFlowFileUuid(), (LineageNode)lineageNode, childNode));
                        lastEventMap.put(childUuid, childNode);
                    }
                    for (String parentUuid : record.getParentUuids()) {
                        LineageNode lastNodeForParent = (LineageNode)lastEventMap.get(parentUuid);
                        if (lastNodeForParent != null && !lastNodeForParent.equals(lineageNode)) {
                            this.edges.add(new EdgeNode(parentUuid, lastNodeForParent, (LineageNode)lineageNode));
                        }
                        lastEventMap.put(parentUuid, lineageNode);
                    }
                    continue block7;
                }
                case RECEIVE: 
                case CREATE: {
                    FlowFileNode flowFileNode = new FlowFileNode(record.getFlowFileUuid(), record.getEventTime());
                    boolean isNewFlowFile = this.nodes.add(flowFileNode);
                    if (!isNewFlowFile) {
                        String msg = "Found cycle in graph. This indicates that multiple events were registered claiming to have generated the same FlowFile (UUID = " + flowFileNode.getFlowFileUuid() + ")";
                        this.setError(msg);
                        logger.error(msg);
                        return;
                    }
                    this.edges.add(new EdgeNode(record.getFlowFileUuid(), (LineageNode)lineageNode, flowFileNode));
                    lastEventMap.put(record.getFlowFileUuid(), flowFileNode);
                    break;
                }
            }
        }
        long nanos = System.nanoTime() - startNanos;
        logger.debug("Finished building lineage with {} nodes and {} edges in {} millis", new Object[]{this.nodes.size(), this.edges.size(), TimeUnit.NANOSECONDS.toMillis(nanos)});
    }

    void cancel() {
        this.canceled = true;
    }

    private void updateExpiration() {
        this.expirationDate = new Date(System.currentTimeMillis() + (long)TTL);
    }
}

