/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.search.Query;
import org.apache.nifi.provenance.search.QueryResult;

public class StandardQueryResult
implements QueryResult {
    public static final int TTL = (int)TimeUnit.MILLISECONDS.convert(30L, TimeUnit.MINUTES);
    private final Query query;
    private final long creationNanos;
    private final int numSteps;
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwLock.readLock();
    private final Lock writeLock = this.rwLock.writeLock();
    private final Set<ProvenanceEventRecord> matchingRecords = new TreeSet<ProvenanceEventRecord>(new EventIdComparator());
    private long totalHitCount;
    private int numCompletedSteps = 0;
    private Date expirationDate;
    private String error;
    private long queryTime;
    private volatile boolean canceled = false;

    public StandardQueryResult(Query query, int numSteps) {
        this.query = query;
        this.numSteps = numSteps;
        this.creationNanos = System.nanoTime();
        this.updateExpiration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ProvenanceEventRecord> getMatchingEvents() {
        this.readLock.lock();
        try {
            if (this.matchingRecords.size() <= this.query.getMaxResults()) {
                ArrayList<ProvenanceEventRecord> arrayList = new ArrayList<ProvenanceEventRecord>(this.matchingRecords);
                return arrayList;
            }
            ArrayList<ProvenanceEventRecord> copy = new ArrayList<ProvenanceEventRecord>(this.query.getMaxResults());
            int i = 0;
            Iterator<ProvenanceEventRecord> itr = this.matchingRecords.iterator();
            while (itr.hasNext()) {
                copy.add(itr.next());
                if (++i < this.query.getMaxResults()) continue;
            }
            ArrayList<ProvenanceEventRecord> arrayList = copy;
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public long getTotalHitCount() {
        this.readLock.lock();
        try {
            long l = this.totalHitCount;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public long getQueryTime() {
        return this.queryTime;
    }

    public Date getExpiration() {
        return this.expirationDate;
    }

    public String getError() {
        return this.error;
    }

    public int getPercentComplete() {
        this.readLock.lock();
        try {
            int n = this.numSteps < 1 ? 100 : (int)((float)this.numCompletedSteps / (float)this.numSteps * 100.0f);
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean isFinished() {
        this.readLock.lock();
        try {
            boolean bl = this.numCompletedSteps >= this.numSteps || this.canceled;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    void cancel() {
        this.canceled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setError(String error) {
        this.writeLock.lock();
        try {
            this.error = error;
            ++this.numCompletedSteps;
            this.updateExpiration();
            if (this.numCompletedSteps >= this.numSteps) {
                long searchNanos = System.nanoTime() - this.creationNanos;
                this.queryTime = TimeUnit.MILLISECONDS.convert(searchNanos, TimeUnit.NANOSECONDS);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Collection<ProvenanceEventRecord> matchingRecords, long totalHits) {
        this.writeLock.lock();
        try {
            this.matchingRecords.addAll(matchingRecords);
            this.totalHitCount += totalHits;
            ++this.numCompletedSteps;
            this.updateExpiration();
            if (this.numCompletedSteps >= this.numSteps) {
                long searchNanos = System.nanoTime() - this.creationNanos;
                this.queryTime = TimeUnit.MILLISECONDS.convert(searchNanos, TimeUnit.NANOSECONDS);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void updateExpiration() {
        this.expirationDate = new Date(System.currentTimeMillis() + (long)TTL);
    }

    private static class EventIdComparator
    implements Comparator<ProvenanceEventRecord> {
        private EventIdComparator() {
        }

        @Override
        public int compare(ProvenanceEventRecord o1, ProvenanceEventRecord o2) {
            return Long.compare(o2.getEventId(), o1.getEventId());
        }
    }
}

