/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.dbcp;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.DynamicProperties;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.RequiresInstanceClassLoading;
import org.apache.nifi.annotation.behavior.SupportsSensitiveDynamicProperties;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.ConfigVerificationResult;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.resource.ResourceCardinality;
import org.apache.nifi.components.resource.ResourceType;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.VerifiableControllerService;
import org.apache.nifi.dbcp.DBCPService;
import org.apache.nifi.dbcp.DBCPValidator;
import org.apache.nifi.expression.AttributeExpression;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.kerberos.KerberosCredentialsService;
import org.apache.nifi.kerberos.KerberosUserService;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.security.krb.KerberosAction;
import org.apache.nifi.security.krb.KerberosKeytabUser;
import org.apache.nifi.security.krb.KerberosLoginException;
import org.apache.nifi.security.krb.KerberosPasswordUser;
import org.apache.nifi.security.krb.KerberosUser;

@SupportsSensitiveDynamicProperties
@Tags(value={"dbcp", "jdbc", "database", "connection", "pooling", "store"})
@CapabilityDescription(value="Provides Database Connection Pooling Service. Connections can be asked from pool and returned after usage.")
@DynamicProperties(value={@DynamicProperty(name="JDBC property name", value="JDBC property value", expressionLanguageScope=ExpressionLanguageScope.VARIABLE_REGISTRY, description="JDBC driver property name and value applied to JDBC connections."), @DynamicProperty(name="SENSITIVE.JDBC property name", value="JDBC property value", expressionLanguageScope=ExpressionLanguageScope.NONE, description="JDBC driver property name prefixed with 'SENSITIVE.' handled as a sensitive property.")})
@RequiresInstanceClassLoading
public class DBCPConnectionPool
extends AbstractControllerService
implements DBCPService,
VerifiableControllerService {
    protected static final String SENSITIVE_PROPERTY_PREFIX = "SENSITIVE.";
    private static final String DEFAULT_MIN_IDLE = "0";
    private static final String DEFAULT_MAX_IDLE = "8";
    private static final String DEFAULT_MAX_CONN_LIFETIME = "-1";
    private static final String DEFAULT_EVICTION_RUN_PERIOD = String.valueOf(-1L);
    private static final String DEFAULT_MIN_EVICTABLE_IDLE_TIME = "30 mins";
    private static final String DEFAULT_SOFT_MIN_EVICTABLE_IDLE_TIME = String.valueOf(-1L);
    public static final PropertyDescriptor DATABASE_URL = new PropertyDescriptor.Builder().name("Database Connection URL").description("A database connection URL used to connect to a database. May contain database system name, host, port, database name and some parameters. The exact syntax of a database connection URL is specified by your DBMS.").defaultValue(null).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).required(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor DB_DRIVERNAME = new PropertyDescriptor.Builder().name("Database Driver Class Name").description("Database driver class name").defaultValue(null).required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor DB_DRIVER_LOCATION = new PropertyDescriptor.Builder().name("database-driver-locations").displayName("Database Driver Location(s)").description("Comma-separated list of files/folders and/or URLs containing the driver JAR and its dependencies (if any). For example '/var/tmp/mariadb-java-client-1.1.7.jar'").defaultValue(null).required(false).identifiesExternalResource(ResourceCardinality.MULTIPLE, ResourceType.FILE, new ResourceType[]{ResourceType.DIRECTORY, ResourceType.URL}).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).dynamicallyModifiesClasspath(true).build();
    public static final PropertyDescriptor DB_USER = new PropertyDescriptor.Builder().name("Database User").description("Database user name").defaultValue(null).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor DB_PASSWORD = new PropertyDescriptor.Builder().name("Password").description("The password for the database user").defaultValue(null).required(false).sensitive(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor MAX_WAIT_TIME = new PropertyDescriptor.Builder().name("Max Wait Time").description("The maximum amount of time that the pool will wait (when there are no available connections)  for a connection to be returned before failing, or -1 to wait indefinitely. ").defaultValue("500 millis").required(true).addValidator(DBCPValidator.CUSTOM_TIME_PERIOD_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).sensitive(false).build();
    public static final PropertyDescriptor MAX_TOTAL_CONNECTIONS = new PropertyDescriptor.Builder().name("Max Total Connections").description("The maximum number of active connections that can be allocated from this pool at the same time,  or negative for no limit.").defaultValue("8").required(true).addValidator(StandardValidators.INTEGER_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).sensitive(false).build();
    public static final PropertyDescriptor VALIDATION_QUERY = new PropertyDescriptor.Builder().name("Validation-query").displayName("Validation query").description("Validation query used to validate connections before returning them. When connection is invalid, it gets dropped and new valid connection will be returned. Note!! Using validation might have some performance penalty.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor MIN_IDLE = new PropertyDescriptor.Builder().displayName("Minimum Idle Connections").name("dbcp-min-idle-conns").description("The minimum number of connections that can remain idle in the pool without extra ones being created. Set to or zero to allow no idle connections.").defaultValue("0").required(false).addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor MAX_IDLE = new PropertyDescriptor.Builder().displayName("Max Idle Connections").name("dbcp-max-idle-conns").description("The maximum number of connections that can remain idle in the pool without extra ones being released. Set to any negative value to allow unlimited idle connections.").defaultValue("8").required(false).addValidator(StandardValidators.INTEGER_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor MAX_CONN_LIFETIME = new PropertyDescriptor.Builder().displayName("Max Connection Lifetime").name("dbcp-max-conn-lifetime").description("The maximum lifetime in milliseconds of a connection. After this time is exceeded the connection will fail the next activation, passivation or validation test. A value of zero or less means the connection has an infinite lifetime.").defaultValue("-1").required(false).addValidator(DBCPValidator.CUSTOM_TIME_PERIOD_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor EVICTION_RUN_PERIOD = new PropertyDescriptor.Builder().displayName("Time Between Eviction Runs").name("dbcp-time-between-eviction-runs").description("The number of milliseconds to sleep between runs of the idle connection evictor thread. When non-positive, no idle connection evictor thread will be run.").defaultValue(DEFAULT_EVICTION_RUN_PERIOD).required(false).addValidator(DBCPValidator.CUSTOM_TIME_PERIOD_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor MIN_EVICTABLE_IDLE_TIME = new PropertyDescriptor.Builder().displayName("Minimum Evictable Idle Time").name("dbcp-min-evictable-idle-time").description("The minimum amount of time a connection may sit idle in the pool before it is eligible for eviction.").defaultValue("30 mins").required(false).addValidator(DBCPValidator.CUSTOM_TIME_PERIOD_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor SOFT_MIN_EVICTABLE_IDLE_TIME = new PropertyDescriptor.Builder().displayName("Soft Minimum Evictable Idle Time").name("dbcp-soft-min-evictable-idle-time").description("The minimum amount of time a connection may sit idle in the pool before it is eligible for eviction by the idle connection evictor, with the extra condition that at least a minimum number of idle connections remain in the pool. When the not-soft version of this option is set to a positive value, it is examined first by the idle connection evictor: when idle connections are visited by the evictor, idle time is first compared against it (without considering the number of idle connections in the pool) and then against this soft option, including the minimum idle connections constraint.").defaultValue(DEFAULT_SOFT_MIN_EVICTABLE_IDLE_TIME).required(false).addValidator(DBCPValidator.CUSTOM_TIME_PERIOD_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor KERBEROS_CREDENTIALS_SERVICE = new PropertyDescriptor.Builder().name("kerberos-credentials-service").displayName("Kerberos Credentials Service").description("Specifies the Kerberos Credentials Controller Service that should be used for authenticating with Kerberos").identifiesControllerService(KerberosCredentialsService.class).required(false).build();
    public static final PropertyDescriptor KERBEROS_USER_SERVICE = new PropertyDescriptor.Builder().name("kerberos-user-service").displayName("Kerberos User Service").description("Specifies the Kerberos User Controller Service that should be used for authenticating with Kerberos").identifiesControllerService(KerberosUserService.class).required(false).build();
    public static final PropertyDescriptor KERBEROS_PRINCIPAL = new PropertyDescriptor.Builder().name("kerberos-principal").displayName("Kerberos Principal").description("The principal to use when specifying the principal and password directly in the processor for authenticating via Kerberos.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).addValidator(StandardValidators.createAttributeExpressionLanguageValidator((AttributeExpression.ResultType)AttributeExpression.ResultType.STRING)).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor KERBEROS_PASSWORD = new PropertyDescriptor.Builder().name("kerberos-password").displayName("Kerberos Password").description("The password to use when specifying the principal and password directly in the processor for authenticating via Kerberos.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(true).build();
    private static final List<PropertyDescriptor> properties;
    protected volatile BasicDataSource dataSource;
    protected volatile KerberosUser kerberosUser;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return properties;
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        PropertyDescriptor.Builder builder = new PropertyDescriptor.Builder().name(propertyDescriptorName).required(false).dynamic(true).addValidator(StandardValidators.createAttributeExpressionLanguageValidator((AttributeExpression.ResultType)AttributeExpression.ResultType.STRING, (boolean)true)).addValidator(StandardValidators.ATTRIBUTE_KEY_PROPERTY_NAME_VALIDATOR);
        if (propertyDescriptorName.startsWith(SENSITIVE_PROPERTY_PREFIX)) {
            builder.sensitive(true).expressionLanguageSupported(ExpressionLanguageScope.NONE);
        } else {
            builder.expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY);
        }
        return builder.build();
    }

    protected Collection<ValidationResult> customValidate(ValidationContext context) {
        boolean kerberosPasswordProvided;
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        boolean kerberosPrincipalProvided = !StringUtils.isBlank((CharSequence)context.getProperty(KERBEROS_PRINCIPAL).evaluateAttributeExpressions().getValue());
        boolean bl = kerberosPasswordProvided = !StringUtils.isBlank((CharSequence)context.getProperty(KERBEROS_PASSWORD).getValue());
        if (kerberosPrincipalProvided && !kerberosPasswordProvided) {
            results.add(new ValidationResult.Builder().subject(KERBEROS_PASSWORD.getDisplayName()).valid(false).explanation("a password must be provided for the given principal").build());
        }
        if (kerberosPasswordProvided && !kerberosPrincipalProvided) {
            results.add(new ValidationResult.Builder().subject(KERBEROS_PRINCIPAL.getDisplayName()).valid(false).explanation("a principal must be provided for the given password").build());
        }
        KerberosCredentialsService kerberosCredentialsService = (KerberosCredentialsService)context.getProperty(KERBEROS_CREDENTIALS_SERVICE).asControllerService(KerberosCredentialsService.class);
        KerberosUserService kerberosUserService = (KerberosUserService)context.getProperty(KERBEROS_USER_SERVICE).asControllerService(KerberosUserService.class);
        if (kerberosCredentialsService != null && (kerberosPrincipalProvided || kerberosPasswordProvided)) {
            results.add(new ValidationResult.Builder().subject(KERBEROS_CREDENTIALS_SERVICE.getDisplayName()).valid(false).explanation("kerberos principal/password and kerberos credential service cannot be configured at the same time").build());
        }
        if (kerberosUserService != null && (kerberosPrincipalProvided || kerberosPasswordProvided)) {
            results.add(new ValidationResult.Builder().subject(KERBEROS_USER_SERVICE.getDisplayName()).valid(false).explanation("kerberos principal/password and kerberos user service cannot be configured at the same time").build());
        }
        if (kerberosUserService != null && kerberosCredentialsService != null) {
            results.add(new ValidationResult.Builder().subject(KERBEROS_USER_SERVICE.getDisplayName()).valid(false).explanation("kerberos user service and kerberos credential service cannot be configured at the same time").build());
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConfigVerificationResult> verify(ConfigurationContext context, ComponentLog verificationLogger, Map<String, String> variables) {
        ArrayList<ConfigVerificationResult> results = new ArrayList<ConfigVerificationResult>();
        KerberosUser kerberosUser = null;
        try {
            kerberosUser = this.getKerberosUser(context);
            if (kerberosUser != null) {
                results.add(new ConfigVerificationResult.Builder().verificationStepName("Configure Kerberos User").outcome(ConfigVerificationResult.Outcome.SUCCESSFUL).explanation("Successfully configured Kerberos user").build());
            }
        }
        catch (Exception e) {
            verificationLogger.error("Failed to configure Kerberos user", (Throwable)e);
            results.add(new ConfigVerificationResult.Builder().verificationStepName("Configure Kerberos User").outcome(ConfigVerificationResult.Outcome.FAILED).explanation("Failed to configure Kerberos user: " + e.getMessage()).build());
        }
        BasicDataSource dataSource = new BasicDataSource();
        try {
            this.configureDataSource(dataSource, kerberosUser, context);
            results.add(new ConfigVerificationResult.Builder().verificationStepName("Configure Data Source").outcome(ConfigVerificationResult.Outcome.SUCCESSFUL).explanation("Successfully configured data source").build());
            try (Connection conn = this.getConnection(dataSource, kerberosUser);){
                results.add(new ConfigVerificationResult.Builder().verificationStepName("Establish Connection").outcome(ConfigVerificationResult.Outcome.SUCCESSFUL).explanation("Successfully established Database Connection").build());
            }
            catch (Exception e) {
                verificationLogger.error("Failed to establish Database Connection", (Throwable)e);
                results.add(new ConfigVerificationResult.Builder().verificationStepName("Establish Connection").outcome(ConfigVerificationResult.Outcome.FAILED).explanation("Failed to establish Database Connection: " + e.getMessage()).build());
            }
        }
        catch (Exception e) {
            String message = "Failed to configure Data Source.";
            if (e.getCause() instanceof ClassNotFoundException) {
                message = message + String.format("  Ensure changes to the '%s' property are applied before verifying", DB_DRIVER_LOCATION.getDisplayName());
            }
            verificationLogger.error(message, (Throwable)e);
            results.add(new ConfigVerificationResult.Builder().verificationStepName("Configure Data Source").outcome(ConfigVerificationResult.Outcome.FAILED).explanation(message + ": " + e.getMessage()).build());
        }
        finally {
            try {
                this.shutdown(dataSource, kerberosUser);
            }
            catch (SQLException e) {
                verificationLogger.error("Failed to shut down data source", (Throwable)e);
            }
        }
        return results;
    }

    @OnEnabled
    public void onConfigured(ConfigurationContext context) throws InitializationException {
        this.kerberosUser = this.getKerberosUser(context);
        this.dataSource = new BasicDataSource();
        this.configureDataSource(this.dataSource, this.kerberosUser, context);
    }

    private void configureDataSource(BasicDataSource dataSource, KerberosUser kerberosUser, ConfigurationContext context) throws InitializationException {
        String dburl = this.getUrl(context);
        String driverName = context.getProperty(DB_DRIVERNAME).evaluateAttributeExpressions().getValue();
        String user = context.getProperty(DB_USER).evaluateAttributeExpressions().getValue();
        String passw = context.getProperty(DB_PASSWORD).evaluateAttributeExpressions().getValue();
        Integer maxTotal = context.getProperty(MAX_TOTAL_CONNECTIONS).evaluateAttributeExpressions().asInteger();
        String validationQuery = context.getProperty(VALIDATION_QUERY).evaluateAttributeExpressions().getValue();
        Long maxWaitMillis = this.extractMillisWithInfinite(context.getProperty(MAX_WAIT_TIME).evaluateAttributeExpressions());
        Integer minIdle = context.getProperty(MIN_IDLE).evaluateAttributeExpressions().asInteger();
        Integer maxIdle = context.getProperty(MAX_IDLE).evaluateAttributeExpressions().asInteger();
        Long maxConnLifetimeMillis = this.extractMillisWithInfinite(context.getProperty(MAX_CONN_LIFETIME).evaluateAttributeExpressions());
        Long timeBetweenEvictionRunsMillis = this.extractMillisWithInfinite(context.getProperty(EVICTION_RUN_PERIOD).evaluateAttributeExpressions());
        Long minEvictableIdleTimeMillis = this.extractMillisWithInfinite(context.getProperty(MIN_EVICTABLE_IDLE_TIME).evaluateAttributeExpressions());
        Long softMinEvictableIdleTimeMillis = this.extractMillisWithInfinite(context.getProperty(SOFT_MIN_EVICTABLE_IDLE_TIME).evaluateAttributeExpressions());
        if (kerberosUser != null) {
            try {
                kerberosUser.login();
            }
            catch (KerberosLoginException e) {
                throw new InitializationException("Unable to authenticate Kerberos principal", (Throwable)e);
            }
        }
        dataSource.setDriver(this.getDriver(driverName, dburl));
        dataSource.setMaxWaitMillis(maxWaitMillis.longValue());
        dataSource.setMaxTotal(maxTotal.intValue());
        dataSource.setMinIdle(minIdle.intValue());
        dataSource.setMaxIdle(maxIdle.intValue());
        dataSource.setMaxConnLifetimeMillis(maxConnLifetimeMillis.longValue());
        dataSource.setTimeBetweenEvictionRunsMillis(timeBetweenEvictionRunsMillis.longValue());
        dataSource.setMinEvictableIdleTimeMillis(minEvictableIdleTimeMillis.longValue());
        dataSource.setSoftMinEvictableIdleTimeMillis(softMinEvictableIdleTimeMillis.longValue());
        if (validationQuery != null && !validationQuery.isEmpty()) {
            dataSource.setValidationQuery(validationQuery);
            dataSource.setTestOnBorrow(true);
        }
        dataSource.setUrl(dburl);
        dataSource.setUsername(user);
        dataSource.setPassword(passw);
        List<PropertyDescriptor> dynamicProperties = context.getProperties().keySet().stream().filter(PropertyDescriptor::isDynamic).collect(Collectors.toList());
        dynamicProperties.forEach(descriptor -> {
            PropertyValue propertyValue = context.getProperty(descriptor);
            if (descriptor.isSensitive()) {
                String propertyName = StringUtils.substringAfter((String)descriptor.getName(), (String)SENSITIVE_PROPERTY_PREFIX);
                dataSource.addConnectionProperty(propertyName, propertyValue.getValue());
            } else {
                dataSource.addConnectionProperty(descriptor.getName(), propertyValue.evaluateAttributeExpressions().getValue());
            }
        });
    }

    private KerberosUser getKerberosUser(ConfigurationContext context) {
        KerberosUser kerberosUser = null;
        KerberosCredentialsService kerberosCredentialsService = (KerberosCredentialsService)context.getProperty(KERBEROS_CREDENTIALS_SERVICE).asControllerService(KerberosCredentialsService.class);
        KerberosUserService kerberosUserService = (KerberosUserService)context.getProperty(KERBEROS_USER_SERVICE).asControllerService(KerberosUserService.class);
        String kerberosPrincipal = context.getProperty(KERBEROS_PRINCIPAL).evaluateAttributeExpressions().getValue();
        String kerberosPassword = context.getProperty(KERBEROS_PASSWORD).getValue();
        if (kerberosUserService != null) {
            kerberosUser = kerberosUserService.createKerberosUser();
        } else if (kerberosCredentialsService != null) {
            kerberosUser = new KerberosKeytabUser(kerberosCredentialsService.getPrincipal(), kerberosCredentialsService.getKeytab());
        } else if (!StringUtils.isBlank((CharSequence)kerberosPrincipal) && !StringUtils.isBlank((CharSequence)kerberosPassword)) {
            kerberosUser = new KerberosPasswordUser(kerberosPrincipal, kerberosPassword);
        }
        return kerberosUser;
    }

    protected String getUrl(ConfigurationContext context) {
        return context.getProperty(DATABASE_URL).evaluateAttributeExpressions().getValue();
    }

    protected Driver getDriver(String driverName, String url) {
        Class<?> clazz;
        try {
            clazz = Class.forName(driverName);
        }
        catch (ClassNotFoundException e) {
            throw new ProcessException("Driver class " + driverName + " is not found", (Throwable)e);
        }
        try {
            return DriverManager.getDriver(url);
        }
        catch (SQLException e) {
            try {
                Driver driver = (Driver)clazz.newInstance();
                DriverManager.registerDriver(driver);
                return DriverManager.getDriver(url);
            }
            catch (SQLException e2) {
                throw new ProcessException("No suitable driver for the given Database Connection URL", (Throwable)e2);
            }
            catch (IllegalAccessException | InstantiationException e2) {
                throw new ProcessException("Creating driver instance is failed", (Throwable)e2);
            }
        }
    }

    protected Long extractMillisWithInfinite(PropertyValue prop) {
        return DEFAULT_MAX_CONN_LIFETIME.equals(prop.getValue()) ? -1L : prop.asTimePeriod(TimeUnit.MILLISECONDS);
    }

    @OnDisabled
    public void shutdown() throws SQLException {
        try {
            this.shutdown(this.dataSource, this.kerberosUser);
        }
        finally {
            this.kerberosUser = null;
            this.dataSource = null;
        }
    }

    private void shutdown(BasicDataSource dataSource, KerberosUser kerberosUser) throws SQLException {
        try {
            if (kerberosUser != null) {
                kerberosUser.logout();
            }
        }
        finally {
            if (dataSource != null) {
                dataSource.close();
            }
        }
    }

    public Connection getConnection() throws ProcessException {
        return this.getConnection(this.dataSource, this.kerberosUser);
    }

    private Connection getConnection(BasicDataSource dataSource, KerberosUser kerberosUser) {
        try {
            Connection con;
            if (kerberosUser != null) {
                KerberosAction kerberosAction = new KerberosAction(kerberosUser, () -> dataSource.getConnection(), this.getLogger());
                con = (Connection)kerberosAction.execute();
            } else {
                con = dataSource.getConnection();
            }
            return con;
        }
        catch (SQLException e) {
            if (kerberosUser != null) {
                try {
                    this.getLogger().info("Error getting connection, performing Kerberos re-login");
                    kerberosUser.login();
                }
                catch (KerberosLoginException le) {
                    throw new ProcessException("Unable to authenticate Kerberos principal", (Throwable)le);
                }
            }
            throw new ProcessException((Throwable)e);
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[id=" + this.getIdentifier() + "]";
    }

    BasicDataSource getDataSource() {
        return this.dataSource;
    }

    static {
        ArrayList<PropertyDescriptor> props = new ArrayList<PropertyDescriptor>();
        props.add(DATABASE_URL);
        props.add(DB_DRIVERNAME);
        props.add(DB_DRIVER_LOCATION);
        props.add(KERBEROS_USER_SERVICE);
        props.add(KERBEROS_CREDENTIALS_SERVICE);
        props.add(KERBEROS_PRINCIPAL);
        props.add(KERBEROS_PASSWORD);
        props.add(DB_USER);
        props.add(DB_PASSWORD);
        props.add(MAX_WAIT_TIME);
        props.add(MAX_TOTAL_CONNECTIONS);
        props.add(VALIDATION_QUERY);
        props.add(MIN_IDLE);
        props.add(MAX_IDLE);
        props.add(MAX_CONN_LIFETIME);
        props.add(EVICTION_RUN_PERIOD);
        props.add(MIN_EVICTABLE_IDLE_TIME);
        props.add(SOFT_MIN_EVICTABLE_IDLE_TIME);
        properties = Collections.unmodifiableList(props);
    }
}

