/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.dbcp;

import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.DynamicProperties;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.RequiresInstanceClassLoading;
import org.apache.nifi.annotation.behavior.Restricted;
import org.apache.nifi.annotation.behavior.Restriction;
import org.apache.nifi.annotation.behavior.SupportsSensitiveDynamicProperties;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.RequiredPermission;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.VerifiableControllerService;
import org.apache.nifi.dbcp.AbstractDBCPConnectionPool;
import org.apache.nifi.dbcp.DBCPService;
import org.apache.nifi.dbcp.utils.DBCPProperties;
import org.apache.nifi.dbcp.utils.DataSourceConfiguration;
import org.apache.nifi.expression.AttributeExpression;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.kerberos.KerberosCredentialsService;
import org.apache.nifi.kerberos.KerberosUserService;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.security.krb.KerberosKeytabUser;
import org.apache.nifi.security.krb.KerberosPasswordUser;
import org.apache.nifi.security.krb.KerberosUser;

@SupportsSensitiveDynamicProperties
@Tags(value={"dbcp", "jdbc", "database", "connection", "pooling", "store"})
@CapabilityDescription(value="Provides Database Connection Pooling Service. Connections can be asked from pool and returned after usage.")
@DynamicProperties(value={@DynamicProperty(name="JDBC property name", value="JDBC property value", expressionLanguageScope=ExpressionLanguageScope.VARIABLE_REGISTRY, description="JDBC driver property name and value applied to JDBC connections."), @DynamicProperty(name="SENSITIVE.JDBC property name", value="JDBC property value", expressionLanguageScope=ExpressionLanguageScope.NONE, description="JDBC driver property name prefixed with 'SENSITIVE.' handled as a sensitive property.")})
@RequiresInstanceClassLoading
@Restricted(restrictions={@Restriction(requiredPermission=RequiredPermission.REFERENCE_REMOTE_RESOURCES, explanation="Database Driver Location can reference resources over HTTP")})
public class DBCPConnectionPool
extends AbstractDBCPConnectionPool
implements DBCPService,
VerifiableControllerService {
    protected static final String SENSITIVE_PROPERTY_PREFIX = "SENSITIVE.";
    private static final List<PropertyDescriptor> PROPERTIES;
    public static final PropertyDescriptor KERBEROS_CREDENTIALS_SERVICE;
    public static final PropertyDescriptor KERBEROS_PRINCIPAL;
    public static final PropertyDescriptor KERBEROS_PASSWORD;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTIES;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext context) {
        boolean kerberosPasswordProvided;
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        boolean kerberosPrincipalProvided = !StringUtils.isBlank((CharSequence)context.getProperty(KERBEROS_PRINCIPAL).evaluateAttributeExpressions().getValue());
        boolean bl = kerberosPasswordProvided = !StringUtils.isBlank((CharSequence)context.getProperty(KERBEROS_PASSWORD).getValue());
        if (kerberosPrincipalProvided && !kerberosPasswordProvided) {
            results.add(new ValidationResult.Builder().subject(KERBEROS_PASSWORD.getDisplayName()).valid(false).explanation("a password must be provided for the given principal").build());
        }
        if (kerberosPasswordProvided && !kerberosPrincipalProvided) {
            results.add(new ValidationResult.Builder().subject(KERBEROS_PRINCIPAL.getDisplayName()).valid(false).explanation("a principal must be provided for the given password").build());
        }
        KerberosCredentialsService kerberosCredentialsService = (KerberosCredentialsService)context.getProperty(KERBEROS_CREDENTIALS_SERVICE).asControllerService(KerberosCredentialsService.class);
        KerberosUserService kerberosUserService = (KerberosUserService)context.getProperty(DBCPProperties.KERBEROS_USER_SERVICE).asControllerService(KerberosUserService.class);
        if (kerberosCredentialsService != null && (kerberosPrincipalProvided || kerberosPasswordProvided)) {
            results.add(new ValidationResult.Builder().subject(KERBEROS_CREDENTIALS_SERVICE.getDisplayName()).valid(false).explanation("kerberos principal/password and kerberos credential service cannot be configured at the same time").build());
        }
        if (kerberosUserService != null && (kerberosPrincipalProvided || kerberosPasswordProvided)) {
            results.add(new ValidationResult.Builder().subject(DBCPProperties.KERBEROS_USER_SERVICE.getDisplayName()).valid(false).explanation("kerberos principal/password and kerberos user service cannot be configured at the same time").build());
        }
        if (kerberosUserService != null && kerberosCredentialsService != null) {
            results.add(new ValidationResult.Builder().subject(DBCPProperties.KERBEROS_USER_SERVICE.getDisplayName()).valid(false).explanation("kerberos user service and kerberos credential service cannot be configured at the same time").build());
        }
        return results;
    }

    BasicDataSource getDataSource() {
        return this.dataSource;
    }

    protected DataSourceConfiguration getDataSourceConfiguration(ConfigurationContext context) {
        String url = context.getProperty(DBCPProperties.DATABASE_URL).evaluateAttributeExpressions().getValue();
        String driverName = context.getProperty(DBCPProperties.DB_DRIVERNAME).evaluateAttributeExpressions().getValue();
        String user = context.getProperty(DBCPProperties.DB_USER).evaluateAttributeExpressions().getValue();
        String password = context.getProperty(DBCPProperties.DB_PASSWORD).evaluateAttributeExpressions().getValue();
        Integer maxTotal = context.getProperty(DBCPProperties.MAX_TOTAL_CONNECTIONS).evaluateAttributeExpressions().asInteger();
        String validationQuery = context.getProperty(DBCPProperties.VALIDATION_QUERY).evaluateAttributeExpressions().getValue();
        Long maxWaitMillis = DBCPProperties.extractMillisWithInfinite((PropertyValue)context.getProperty(DBCPProperties.MAX_WAIT_TIME).evaluateAttributeExpressions());
        Integer minIdle = context.getProperty(DBCPProperties.MIN_IDLE).evaluateAttributeExpressions().asInteger();
        Integer maxIdle = context.getProperty(DBCPProperties.MAX_IDLE).evaluateAttributeExpressions().asInteger();
        Long maxConnLifetimeMillis = DBCPProperties.extractMillisWithInfinite((PropertyValue)context.getProperty(DBCPProperties.MAX_CONN_LIFETIME).evaluateAttributeExpressions());
        Long timeBetweenEvictionRunsMillis = DBCPProperties.extractMillisWithInfinite((PropertyValue)context.getProperty(DBCPProperties.EVICTION_RUN_PERIOD).evaluateAttributeExpressions());
        Long minEvictableIdleTimeMillis = DBCPProperties.extractMillisWithInfinite((PropertyValue)context.getProperty(DBCPProperties.MIN_EVICTABLE_IDLE_TIME).evaluateAttributeExpressions());
        Long softMinEvictableIdleTimeMillis = DBCPProperties.extractMillisWithInfinite((PropertyValue)context.getProperty(DBCPProperties.SOFT_MIN_EVICTABLE_IDLE_TIME).evaluateAttributeExpressions());
        return new DataSourceConfiguration.Builder(url, driverName, user, password).maxTotal(maxTotal.intValue()).validationQuery(validationQuery).maxWaitMillis(maxWaitMillis.longValue()).minIdle(minIdle.intValue()).maxIdle(maxIdle.intValue()).maxConnLifetimeMillis(maxConnLifetimeMillis.longValue()).timeBetweenEvictionRunsMillis(timeBetweenEvictionRunsMillis.longValue()).minEvictableIdleTimeMillis(minEvictableIdleTimeMillis.longValue()).softMinEvictableIdleTimeMillis(softMinEvictableIdleTimeMillis.longValue()).build();
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        PropertyDescriptor.Builder builder = new PropertyDescriptor.Builder().name(propertyDescriptorName).required(false).dynamic(true).addValidator(StandardValidators.createAttributeExpressionLanguageValidator((AttributeExpression.ResultType)AttributeExpression.ResultType.STRING, (boolean)true)).addValidator(StandardValidators.ATTRIBUTE_KEY_PROPERTY_NAME_VALIDATOR);
        if (propertyDescriptorName.startsWith(SENSITIVE_PROPERTY_PREFIX)) {
            builder.sensitive(true).expressionLanguageSupported(ExpressionLanguageScope.NONE);
        } else {
            builder.expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY);
        }
        return builder.build();
    }

    protected Map<String, String> getConnectionProperties(ConfigurationContext context) {
        return this.getDynamicProperties(context).stream().map(descriptor -> {
            PropertyValue propertyValue = context.getProperty(descriptor);
            if (descriptor.isSensitive()) {
                String propertyName = StringUtils.startsWith((CharSequence)descriptor.getName(), (CharSequence)SENSITIVE_PROPERTY_PREFIX) ? StringUtils.substringAfter((String)descriptor.getName(), (String)SENSITIVE_PROPERTY_PREFIX) : descriptor.getName();
                return new AbstractMap.SimpleEntry<String, String>(propertyName, propertyValue.getValue());
            }
            return new AbstractMap.SimpleEntry<String, String>(descriptor.getName(), propertyValue.evaluateAttributeExpressions().getValue());
        }).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    }

    protected Driver getDriver(String driverName, String url) {
        Class<?> clazz;
        try {
            clazz = Class.forName(driverName);
        }
        catch (ClassNotFoundException e) {
            throw new ProcessException("Driver class " + driverName + " is not found", (Throwable)e);
        }
        try {
            return DriverManager.getDriver(url);
        }
        catch (SQLException e) {
            try {
                Driver driver = (Driver)clazz.newInstance();
                DriverManager.registerDriver(driver);
                return DriverManager.getDriver(url);
            }
            catch (SQLException e2) {
                throw new ProcessException("No suitable driver for the given Database Connection URL", (Throwable)e2);
            }
            catch (IllegalAccessException | InstantiationException e2) {
                throw new ProcessException("Creating driver instance is failed", (Throwable)e2);
            }
        }
    }

    protected KerberosUser getKerberosUserByCredentials(ConfigurationContext context) {
        KerberosUser kerberosUser = super.getKerberosUserByCredentials(context);
        if (kerberosUser == null) {
            KerberosCredentialsService kerberosCredentialsService = (KerberosCredentialsService)context.getProperty(KERBEROS_CREDENTIALS_SERVICE).asControllerService(KerberosCredentialsService.class);
            String kerberosPrincipal = context.getProperty(KERBEROS_PRINCIPAL).evaluateAttributeExpressions().getValue();
            String kerberosPassword = context.getProperty(KERBEROS_PASSWORD).getValue();
            if (kerberosCredentialsService != null) {
                kerberosUser = new KerberosKeytabUser(kerberosCredentialsService.getPrincipal(), kerberosCredentialsService.getKeytab());
            } else if (!StringUtils.isBlank((CharSequence)kerberosPrincipal) && !StringUtils.isBlank((CharSequence)kerberosPassword)) {
                kerberosUser = new KerberosPasswordUser(kerberosPrincipal, kerberosPassword);
            }
        }
        return kerberosUser;
    }

    static {
        KERBEROS_CREDENTIALS_SERVICE = new PropertyDescriptor.Builder().name("kerberos-credentials-service").displayName("Kerberos Credentials Service").description("Specifies the Kerberos Credentials Controller Service that should be used for authenticating with Kerberos").identifiesControllerService(KerberosCredentialsService.class).required(false).build();
        KERBEROS_PRINCIPAL = new PropertyDescriptor.Builder().name("kerberos-principal").displayName("Kerberos Principal").description("The principal to use when specifying the principal and password directly in the processor for authenticating via Kerberos.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).addValidator(StandardValidators.createAttributeExpressionLanguageValidator((AttributeExpression.ResultType)AttributeExpression.ResultType.STRING)).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
        KERBEROS_PASSWORD = new PropertyDescriptor.Builder().name("kerberos-password").displayName("Kerberos Password").description("The password to use when specifying the principal and password directly in the processor for authenticating via Kerberos.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(true).build();
        ArrayList<PropertyDescriptor> props = new ArrayList<PropertyDescriptor>();
        props.add(DBCPProperties.DATABASE_URL);
        props.add(DBCPProperties.DB_DRIVERNAME);
        props.add(DBCPProperties.DB_DRIVER_LOCATION);
        props.add(DBCPProperties.KERBEROS_USER_SERVICE);
        props.add(KERBEROS_CREDENTIALS_SERVICE);
        props.add(KERBEROS_PRINCIPAL);
        props.add(KERBEROS_PASSWORD);
        props.add(DBCPProperties.DB_USER);
        props.add(DBCPProperties.DB_PASSWORD);
        props.add(DBCPProperties.MAX_WAIT_TIME);
        props.add(DBCPProperties.MAX_TOTAL_CONNECTIONS);
        props.add(DBCPProperties.VALIDATION_QUERY);
        props.add(DBCPProperties.MIN_IDLE);
        props.add(DBCPProperties.MAX_IDLE);
        props.add(DBCPProperties.MAX_CONN_LIFETIME);
        props.add(DBCPProperties.EVICTION_RUN_PERIOD);
        props.add(DBCPProperties.MIN_EVICTABLE_IDLE_TIME);
        props.add(DBCPProperties.SOFT_MIN_EVICTABLE_IDLE_TIME);
        PROPERTIES = Collections.unmodifiableList(props);
    }
}

