/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.dbcp;

import java.sql.Connection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.processor.FlowFileFilter;
import org.apache.nifi.processor.exception.ProcessException;

@Tags(value={"dbcp", "jdbc", "database", "connection", "pooling", "store"})
@CapabilityDescription(value="Provides Database Connection Pooling Service. Connections can be asked from pool and returned after usage.")
public interface DBCPService
extends ControllerService {
    public Connection getConnection() throws ProcessException;

    default public Connection getConnection(Map<String, String> attributes) throws ProcessException {
        return this.getConnection();
    }

    default public FlowFileFilter getFlowFileFilter() {
        return null;
    }

    default public FlowFileFilter getFlowFileFilter(int batchSize) {
        FlowFileFilter filter = this.getFlowFileFilter();
        if (filter == null) {
            return null;
        }
        AtomicInteger count = new AtomicInteger(0);
        return flowFile -> {
            if (count.get() >= batchSize) {
                return FlowFileFilter.FlowFileFilterResult.REJECT_AND_TERMINATE;
            }
            FlowFileFilter.FlowFileFilterResult result = filter.filter(flowFile);
            if (FlowFileFilter.FlowFileFilterResult.ACCEPT_AND_CONTINUE.equals((Object)result)) {
                count.incrementAndGet();
                return FlowFileFilter.FlowFileFilterResult.ACCEPT_AND_CONTINUE;
            }
            return result;
        };
    }
}

