/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.distributed.cache.client;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.distributed.cache.client.Deserializer;
import org.apache.nifi.distributed.cache.client.Serializer;

@Tags(value={"distributed", "client", "cluster", "map", "cache"})
@CapabilityDescription(value="Provides the ability to communicate with a DistributedMapCacheServer. This allows multiple nodes to coordinate state with a single remote entity.")
public interface DistributedMapCacheClient
extends ControllerService {
    public <K, V> boolean putIfAbsent(K var1, V var2, Serializer<K> var3, Serializer<V> var4) throws IOException;

    public <K, V> V getAndPutIfAbsent(K var1, V var2, Serializer<K> var3, Serializer<V> var4, Deserializer<V> var5) throws IOException;

    public <K> boolean containsKey(K var1, Serializer<K> var2) throws IOException;

    public <K, V> void put(K var1, V var2, Serializer<K> var3, Serializer<V> var4) throws IOException;

    public <K, V> V get(K var1, Serializer<K> var2, Deserializer<V> var3) throws IOException;

    default public <K, V> Map<K, V> subMap(Set<K> keys, Serializer<K> keySerializer, Deserializer<V> valueDeserializer) throws IOException {
        if (keys == null) {
            return null;
        }
        HashMap<K, V> results = new HashMap<K, V>(keys.size());
        for (K key : keys) {
            results.put(key, this.get(key, keySerializer, valueDeserializer));
        }
        return results;
    }

    public void close() throws IOException;

    public <K> boolean remove(K var1, Serializer<K> var2) throws IOException;

    default public <K, V> V removeAndGet(K key, Serializer<K> keySerializer, Deserializer<V> valueDeserializer) throws IOException {
        throw new UnsupportedOperationException();
    }

    public long removeByPattern(String var1) throws IOException;

    default public <K, V> Map<K, V> removeByPatternAndGet(String regex, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) throws IOException {
        throw new UnsupportedOperationException();
    }

    default public <K> Set<K> keySet(Deserializer<K> keyDeserializer) throws IOException {
        throw new UnsupportedOperationException();
    }
}

