/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.elasticsearch;

import java.lang.reflect.InvocationTargetException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.elasticsearch.AbstractElasticsearch5Processor;
import org.apache.nifi.ssl.SSLContextService;
import org.apache.nifi.util.StringUtils;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.transport.client.PreBuiltTransportClient;

abstract class AbstractElasticsearch5TransportClientProcessor
extends AbstractElasticsearch5Processor {
    protected static final PropertyDescriptor CLUSTER_NAME = new PropertyDescriptor.Builder().name("el5-cluster-name").displayName("Cluster Name").description("Name of the ES cluster (for example, elasticsearch_brew). Defaults to 'elasticsearch'").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).defaultValue("elasticsearch").expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    protected static final PropertyDescriptor HOSTS = new PropertyDescriptor.Builder().name("el5-hosts").displayName("ElasticSearch Hosts").description("ElasticSearch Hosts, which should be comma separated and colon for hostname/port host1:port,host2:port,....  For example testcluster:9300. This processor uses the Transport Client to connect to hosts. The default transport client port is 9300.").required(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.HOSTNAME_PORT_LIST_VALIDATOR).build();
    public static final PropertyDescriptor PROP_XPACK_LOCATION = new PropertyDescriptor.Builder().name("el5-xpack-location").displayName("X-Pack Transport Location").description("Specifies the path to the JAR(s) for the Elasticsearch X-Pack Transport feature. If the Elasticsearch cluster has been secured with the X-Pack plugin, then the X-Pack Transport JARs must also be available to this processor. Note: Do NOT place the X-Pack JARs into NiFi's lib/ directory, doing so will prevent the X-Pack Transport JARs from being loaded.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).dynamicallyModifiesClasspath(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    protected static final PropertyDescriptor PING_TIMEOUT = new PropertyDescriptor.Builder().name("el5-ping-timeout").displayName("ElasticSearch Ping Timeout").description("The ping timeout used to determine when a node is unreachable. For example, 5s (5 seconds). If non-local recommended is 30s").required(true).defaultValue("5s").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    protected static final PropertyDescriptor SAMPLER_INTERVAL = new PropertyDescriptor.Builder().name("el5-sampler-interval").displayName("Sampler Interval").description("How often to sample / ping the nodes listed and connected. For example, 5s (5 seconds). If non-local recommended is 30s.").required(true).defaultValue("5s").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    protected final AtomicReference<Client> esClient = new AtomicReference();
    protected List<InetSocketAddress> esHosts;

    AbstractElasticsearch5TransportClientProcessor() {
    }

    @Override
    protected void createElasticsearchClient(ProcessContext context) throws ProcessException {
        ComponentLog log = this.getLogger();
        if (this.esClient.get() != null) {
            return;
        }
        log.debug("Creating ElasticSearch Client");
        try {
            String clusterName = context.getProperty(CLUSTER_NAME).evaluateAttributeExpressions().getValue();
            String pingTimeout = context.getProperty(PING_TIMEOUT).evaluateAttributeExpressions().getValue();
            String samplerInterval = context.getProperty(SAMPLER_INTERVAL).evaluateAttributeExpressions().getValue();
            String username = context.getProperty(USERNAME).evaluateAttributeExpressions().getValue();
            String password = context.getProperty(PASSWORD).getValue();
            SSLContextService sslService = (SSLContextService)context.getProperty(PROP_SSL_CONTEXT_SERVICE).asControllerService(SSLContextService.class);
            Settings.Builder settingsBuilder = Settings.builder().put("cluster.name", clusterName).put("client.transport.ping_timeout", pingTimeout).put("client.transport.nodes_sampler_interval", samplerInterval);
            String xPackUrl = context.getProperty(PROP_XPACK_LOCATION).evaluateAttributeExpressions().getValue();
            if (sslService != null) {
                settingsBuilder.put("xpack.security.transport.ssl.enabled", "true");
                if (!StringUtils.isEmpty((String)sslService.getKeyStoreFile())) {
                    settingsBuilder.put("xpack.ssl.keystore.path", sslService.getKeyStoreFile());
                }
                if (!StringUtils.isEmpty((String)sslService.getKeyStorePassword())) {
                    settingsBuilder.put("xpack.ssl.keystore.password", sslService.getKeyStorePassword());
                }
                if (!StringUtils.isEmpty((String)sslService.getKeyPassword())) {
                    settingsBuilder.put("xpack.ssl.keystore.key_password", sslService.getKeyPassword());
                }
                if (!StringUtils.isEmpty((String)sslService.getTrustStoreFile())) {
                    settingsBuilder.put("xpack.ssl.truststore.path", sslService.getTrustStoreFile());
                }
                if (!StringUtils.isEmpty((String)sslService.getTrustStorePassword())) {
                    settingsBuilder.put("xpack.ssl.truststore.password", sslService.getTrustStorePassword());
                }
            }
            if (!StringUtils.isEmpty((String)username)) {
                StringBuffer secureUser = new StringBuffer(username);
                if (!StringUtils.isEmpty((String)password)) {
                    secureUser.append(":");
                    secureUser.append(password);
                }
                settingsBuilder.put(new Object[]{"xpack.security.user", secureUser});
            }
            String hosts = context.getProperty(HOSTS).evaluateAttributeExpressions().getValue();
            this.esHosts = this.getEsHosts(hosts);
            Client transportClient = this.getTransportClient(settingsBuilder, xPackUrl, username, password, this.esHosts, log);
            this.esClient.set(transportClient);
        }
        catch (Exception e) {
            log.error("Failed to create Elasticsearch client due to {}", new Object[]{e}, (Throwable)e);
            throw new ProcessException((Throwable)e);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected Client getTransportClient(Settings.Builder settingsBuilder, String xPackPath, String username, String password, List<InetSocketAddress> esHosts, ComponentLog log) throws MalformedURLException {
        headers = new HashMap<String, String>();
        transportClient = null;
        if (!StringUtils.isBlank((String)xPackPath)) {
            xPackClassloader = Thread.currentThread().getContextClassLoader();
            try {
                xPackTransportClientClass = Class.forName("org.elasticsearch.xpack.client.PreBuiltXPackTransportClient", true, xPackClassloader);
                ctor = xPackTransportClientClass.getConstructor(new Class[]{Settings.class, Class[].class});
                if (StringUtils.isEmpty((String)username) || StringUtils.isEmpty((String)password)) ** GOTO lbl23
                usernamePasswordTokenClass = Class.forName("org.elasticsearch.xpack.security.authc.support.UsernamePasswordToken", true, xPackClassloader);
                securedStringClass = Class.forName("org.elasticsearch.xpack.security.authc.support.SecuredString", true, xPackClassloader);
                securedStringCtor = securedStringClass.getConstructor(new Class[]{char[].class});
                securePasswordString = securedStringCtor.newInstance(new Object[]{password.toCharArray()});
                basicAuthHeaderValue = usernamePasswordTokenClass.getMethod("basicAuthHeaderValue", new Class[]{String.class, securedStringClass});
                authToken = (String)basicAuthHeaderValue.invoke(null, new Object[]{username, securePasswordString});
                if (authToken != null) {
                    headers.put("Authorization", authToken);
                }
                transportClient = (TransportClient)ctor.newInstance(new Object[]{settingsBuilder.build(), new Class[0]});
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException xPackLoadException) {
                throw new ProcessException("X-Pack plugin could not be loaded and/or configured", (Throwable)xPackLoadException);
            }
        } else {
            this.getLogger().debug("No X-Pack Transport location specified, secure connections and/or authorization will not be available");
        }
lbl23:
        // 3 sources

        if (transportClient == null) {
            transportClient = new PreBuiltTransportClient(settingsBuilder.build(), new Class[0]);
        }
        if (esHosts != null) {
            for (InetSocketAddress host : esHosts) {
                try {
                    transportClient.addTransportAddress((TransportAddress)new InetSocketTransportAddress(host));
                }
                catch (IllegalArgumentException iae) {
                    log.error("Could not add transport address {}", new Object[]{host});
                }
            }
        }
        client = transportClient.filterWithHeader(headers);
        return client;
    }

    public void closeClient() {
        Client client = this.esClient.get();
        if (client != null) {
            this.getLogger().info("Closing ElasticSearch Client");
            this.esClient.set(null);
            client.close();
        }
    }

    private List<InetSocketAddress> getEsHosts(String hosts) {
        if (hosts == null) {
            return null;
        }
        List<String> esList = Arrays.asList(hosts.split(","));
        ArrayList<InetSocketAddress> esHosts = new ArrayList<InetSocketAddress>();
        for (String item : esList) {
            String[] addresses = item.split(":");
            String hostName = addresses[0].trim();
            int port = Integer.parseInt(addresses[1].trim());
            esHosts.add(new InetSocketAddress(hostName, port));
        }
        return esHosts;
    }
}

