/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.elasticsearch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.EventDriven;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.elasticsearch.AbstractElasticsearch5TransportClientProcessor;
import org.apache.nifi.processors.elasticsearch.FetchElasticsearch5;
import org.apache.nifi.processors.elasticsearch.PutElasticsearch5;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.transport.ReceiveTimeoutTransportException;

@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@EventDriven
@Tags(value={"elasticsearch", "elasticsearch 5", "delete", "remove"})
@CapabilityDescription(value="Delete a document from Elasticsearch 5.0 by document id. If the cluster has been configured for authorization and/or secure transport (SSL/TLS), and the X-Pack plugin is available, secure connections can be made.")
@WritesAttributes(value={@WritesAttribute(attribute="es.error.message", description="The message attribute in case of error"), @WritesAttribute(attribute="filename", description="The filename attribute which is set to the document identifier"), @WritesAttribute(attribute="es.index", description="The Elasticsearch index containing the document"), @WritesAttribute(attribute="es.type", description="The Elasticsearch document type"), @WritesAttribute(attribute="es.rest.status", description="The filename attribute with rest status")})
@SeeAlso(value={FetchElasticsearch5.class, PutElasticsearch5.class})
public class DeleteElasticsearch5
extends AbstractElasticsearch5TransportClientProcessor {
    public static final String UNABLE_TO_DELETE_DOCUMENT_MESSAGE = "Unable to delete document";
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("All FlowFile corresponding to the deleted document from Elasticsearch are routed to this relationship").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("All FlowFile corresponding to delete document that failed from Elasticsearch are routed to this relationship").build();
    public static final Relationship REL_RETRY = new Relationship.Builder().name("retry").description("A FlowFile is routed to this relationship if the document cannot be deleted because or retryable exception like timeout or node not available").build();
    public static final Relationship REL_NOT_FOUND = new Relationship.Builder().name("not found").description("A FlowFile is routed to this relationship if the specified document was not found in elasticsearch").build();
    public static final PropertyDescriptor DOCUMENT_ID = new PropertyDescriptor.Builder().name("el5-delete-document-id").displayName("Document Identifier").description("The identifier for the document to be deleted").required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor INDEX = new PropertyDescriptor.Builder().name("el5-delete-index").displayName("Index").description("The name of the index to delete the document from").required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor TYPE = new PropertyDescriptor.Builder().name("el5-delete-type").displayName("Type").description("The type of this document to be deleted").required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    private static final Set<Relationship> relationships;
    private static final List<PropertyDescriptor> propertyDescriptors;
    public static final String ES_ERROR_MESSAGE = "es.error.message";
    public static final String ES_FILENAME = "filename";
    public static final String ES_INDEX = "es.index";
    public static final String ES_TYPE = "es.type";
    public static final String ES_REST_STATUS = "es.rest.status";

    public Set<Relationship> getRelationships() {
        return relationships;
    }

    public final List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return propertyDescriptors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        AtomicReference atomicReference = this.esClient;
        synchronized (atomicReference) {
            if (this.esClient.get() == null) {
                this.setup(context);
            }
        }
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        final String index = context.getProperty(INDEX).evaluateAttributeExpressions(flowFile).getValue();
        final String documentId = context.getProperty(DOCUMENT_ID).evaluateAttributeExpressions(flowFile).getValue();
        final String documentType = context.getProperty(TYPE).evaluateAttributeExpressions(flowFile).getValue();
        ComponentLog logger = this.getLogger();
        if (StringUtils.isBlank((CharSequence)index)) {
            logger.debug("Index is required but was empty {}", new Object[]{index});
            flowFile = session.putAttribute(flowFile, ES_ERROR_MESSAGE, "Index is required but was empty");
            session.transfer(flowFile, REL_FAILURE);
            return;
        }
        if (StringUtils.isBlank((CharSequence)documentType)) {
            logger.debug("Document type is required but was empty {}", new Object[]{documentType});
            flowFile = session.putAttribute(flowFile, ES_ERROR_MESSAGE, "Document type is required but was empty");
            session.transfer(flowFile, REL_FAILURE);
            return;
        }
        if (StringUtils.isBlank((CharSequence)documentId)) {
            logger.debug("Document id is required but was empty {}", new Object[]{documentId});
            flowFile = session.putAttribute(flowFile, ES_ERROR_MESSAGE, "Document id is required but was empty");
            session.transfer(flowFile, REL_FAILURE);
            return;
        }
        flowFile = session.putAllAttributes(flowFile, (Map)new HashMap<String, String>(){
            {
                this.put(DeleteElasticsearch5.ES_FILENAME, documentId);
                this.put(DeleteElasticsearch5.ES_INDEX, index);
                this.put(DeleteElasticsearch5.ES_TYPE, documentType);
            }
        });
        try {
            logger.debug("Deleting document {}/{}/{} from Elasticsearch", new Object[]{index, documentType, documentId});
            DeleteRequestBuilder requestBuilder = this.prepareDeleteRequest(index, documentId, documentType);
            DeleteResponse response = this.doDelete(requestBuilder);
            if (response.status() != RestStatus.OK) {
                logger.warn("Failed to delete document {}/{}/{} from Elasticsearch: Status {}", new Object[]{index, documentType, documentId, response.status()});
                flowFile = session.putAttribute(flowFile, ES_ERROR_MESSAGE, UNABLE_TO_DELETE_DOCUMENT_MESSAGE);
                flowFile = session.putAttribute(flowFile, ES_REST_STATUS, response.status().toString());
                context.yield();
                if (response.status() == RestStatus.NOT_FOUND) {
                    session.transfer(flowFile, REL_NOT_FOUND);
                } else {
                    session.transfer(flowFile, REL_FAILURE);
                }
            } else {
                logger.debug("Elasticsearch document " + documentId + " deleted");
                session.transfer(flowFile, REL_SUCCESS);
            }
        }
        catch (ElasticsearchTimeoutException | ReceiveTimeoutTransportException exception) {
            logger.error("Failed to delete document {} from Elasticsearch due to {}", new Object[]{documentId, exception.getLocalizedMessage()}, exception);
            flowFile = session.putAttribute(flowFile, ES_ERROR_MESSAGE, exception.getLocalizedMessage());
            session.transfer(flowFile, REL_RETRY);
            context.yield();
        }
        catch (Exception e) {
            logger.error("Failed to delete document {} from Elasticsearch due to {}", new Object[]{documentId, e.getLocalizedMessage()}, (Throwable)e);
            flowFile = session.putAttribute(flowFile, ES_ERROR_MESSAGE, e.getLocalizedMessage());
            session.transfer(flowFile, REL_FAILURE);
            context.yield();
        }
    }

    protected DeleteRequestBuilder prepareDeleteRequest(String index, String documentId, String documentType) {
        return ((Client)this.esClient.get()).prepareDelete(index, documentType, documentId);
    }

    protected DeleteResponse doDelete(DeleteRequestBuilder requestBuilder) throws InterruptedException, ExecutionException {
        return (DeleteResponse)requestBuilder.execute().get();
    }

    @Override
    @OnStopped
    public void closeClient() {
        super.closeClient();
    }

    static {
        HashSet<Relationship> relations = new HashSet<Relationship>();
        relations.add(REL_SUCCESS);
        relations.add(REL_FAILURE);
        relations.add(REL_RETRY);
        relations.add(REL_NOT_FOUND);
        relationships = Collections.unmodifiableSet(relations);
        ArrayList<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>();
        descriptors.add(CLUSTER_NAME);
        descriptors.add(HOSTS);
        descriptors.add(PROP_SSL_CONTEXT_SERVICE);
        descriptors.add(PROP_XPACK_LOCATION);
        descriptors.add(USERNAME);
        descriptors.add(PASSWORD);
        descriptors.add(PING_TIMEOUT);
        descriptors.add(SAMPLER_INTERVAL);
        descriptors.add(DOCUMENT_ID);
        descriptors.add(INDEX);
        descriptors.add(TYPE);
        propertyDescriptors = Collections.unmodifiableList(descriptors);
    }
}

