/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.elasticsearch.DeleteOperationResponse;
import org.apache.nifi.elasticsearch.ElasticSearchClientService;
import org.apache.nifi.elasticsearch.IndexOperationRequest;
import org.apache.nifi.elasticsearch.IndexOperationResponse;
import org.apache.nifi.elasticsearch.SearchResponse;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.ssl.SSLContextService;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;

public class ElasticSearchClientServiceImpl
extends AbstractControllerService
implements ElasticSearchClientService {
    private ObjectMapper mapper = new ObjectMapper();
    private static final List<PropertyDescriptor> properties;
    private RestClient client;
    private RestHighLevelClient highLevelClient;
    private String url;
    private Charset charset;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return properties;
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) throws InitializationException {
        try {
            this.setupClient(context);
            this.charset = Charset.forName(context.getProperty(CHARSET).getValue());
        }
        catch (Exception ex) {
            this.getLogger().error("Could not initialize ElasticSearch client.", (Throwable)ex);
            throw new InitializationException((Throwable)ex);
        }
    }

    @OnDisabled
    public void onDisabled() throws IOException {
        this.client.close();
        this.url = null;
    }

    private SSLContext buildSslContext(SSLContextService sslService) throws IOException, CertificateException, NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException, KeyManagementException {
        KeyStore keyStore = KeyStore.getInstance(sslService.getKeyStoreType());
        KeyStore trustStore = KeyStore.getInstance("JKS");
        try (FileInputStream is = new FileInputStream(sslService.getKeyStoreFile());){
            keyStore.load(is, sslService.getKeyStorePassword().toCharArray());
        }
        is = new FileInputStream(sslService.getTrustStoreFile());
        var5_5 = null;
        try {
            trustStore.load(is, sslService.getTrustStorePassword().toCharArray());
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (is != null) {
                if (var5_5 != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    ((InputStream)is).close();
                }
            }
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(keyStore, sslService.getKeyStorePassword().toCharArray());
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(keyStore);
        SSLContext context1 = SSLContext.getInstance(sslService.getSslAlgorithm());
        context1.init(kmf.getKeyManagers(), tmf.getTrustManagers(), new SecureRandom());
        return context1;
    }

    private void setupClient(ConfigurationContext context) throws MalformedURLException, InitializationException {
        SSLContext sslContext;
        String hosts = context.getProperty(HTTP_HOSTS).evaluateAttributeExpressions().getValue();
        String[] hostsSplit = hosts.split(",[\\s]*");
        this.url = hostsSplit[0];
        SSLContextService sslService = (SSLContextService)context.getProperty(PROP_SSL_CONTEXT_SERVICE).asControllerService(SSLContextService.class);
        String username = context.getProperty(USERNAME).evaluateAttributeExpressions().getValue();
        String password = context.getProperty(PASSWORD).evaluateAttributeExpressions().getValue();
        Integer connectTimeout = context.getProperty(CONNECT_TIMEOUT).asInteger();
        Integer readTimeout = context.getProperty(SOCKET_TIMEOUT).asInteger();
        Integer retryTimeout = context.getProperty(RETRY_TIMEOUT).asInteger();
        HttpHost[] hh = new HttpHost[hostsSplit.length];
        for (int x = 0; x < hh.length; ++x) {
            URL u = new URL(hostsSplit[x]);
            hh[x] = new HttpHost(u.getHost(), u.getPort(), u.getProtocol());
        }
        try {
            sslContext = sslService != null && sslService.isKeyStoreConfigured() && sslService.isTrustStoreConfigured() ? this.buildSslContext(sslService) : null;
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            this.getLogger().error("Error building up SSL Context from the supplied configuration.", (Throwable)e);
            throw new InitializationException((Throwable)e);
        }
        RestClientBuilder builder = RestClient.builder((HttpHost[])hh).setHttpClientConfigCallback(httpClientBuilder -> {
            if (sslContext != null) {
                httpClientBuilder = httpClientBuilder.setSSLContext(sslContext);
            }
            if (username != null && password != null) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
                httpClientBuilder = httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            }
            return httpClientBuilder;
        }).setRequestConfigCallback(requestConfigBuilder -> {
            requestConfigBuilder.setConnectTimeout(connectTimeout.intValue());
            requestConfigBuilder.setSocketTimeout(readTimeout.intValue());
            return requestConfigBuilder;
        }).setMaxRetryTimeoutMillis(retryTimeout.intValue());
        this.client = builder.build();
        this.highLevelClient = new RestHighLevelClient(this.client);
    }

    private Response runQuery(String endpoint, String query, String index, String type) throws IOException {
        StringBuilder sb = new StringBuilder().append("/").append(index);
        if (type != null && !type.equals("")) {
            sb.append("/").append(type);
        }
        sb.append(String.format("/%s", endpoint));
        NStringEntity queryEntity = new NStringEntity(query, ContentType.APPLICATION_JSON);
        return this.client.performRequest("POST", sb.toString(), Collections.emptyMap(), (HttpEntity)queryEntity, new Header[0]);
    }

    private Map<String, Object> parseResponse(Response response) throws IOException {
        int code = response.getStatusLine().getStatusCode();
        if (code >= 200 & code < 300) {
            InputStream inputStream = response.getEntity().getContent();
            byte[] result = IOUtils.toByteArray((InputStream)inputStream);
            inputStream.close();
            return (Map)this.mapper.readValue(new String(result, this.charset), Map.class);
        }
        String errorMessage = String.format("ElasticSearch reported an error while trying to run the query: %s", response.getStatusLine().getReasonPhrase());
        throw new IOException(errorMessage);
    }

    public IndexOperationResponse add(IndexOperationRequest operation) throws IOException {
        return this.add(Arrays.asList(operation));
    }

    public IndexOperationResponse add(List<IndexOperationRequest> operations) throws IOException {
        BulkRequest bulkRequest = new BulkRequest();
        for (int index = 0; index < operations.size(); ++index) {
            IndexOperationRequest or = operations.get(index);
            IndexRequest indexRequest = new IndexRequest(or.getIndex(), or.getType(), or.getId()).source(or.getFields());
            bulkRequest.add(indexRequest);
        }
        bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        BulkResponse response = this.highLevelClient.bulk(bulkRequest, new Header[0]);
        IndexOperationResponse retVal = new IndexOperationResponse(response.getTookInMillis(), response.getIngestTookInMillis());
        return retVal;
    }

    public DeleteOperationResponse deleteById(String index, String type, String id) throws IOException {
        return this.deleteById(index, type, Arrays.asList(id));
    }

    public DeleteOperationResponse deleteById(String index, String type, List<String> ids) throws IOException {
        BulkRequest bulk = new BulkRequest();
        for (int idx = 0; idx < ids.size(); ++idx) {
            DeleteRequest request = new DeleteRequest(index, type, ids.get(idx));
            bulk.add(request);
        }
        BulkResponse response = this.highLevelClient.bulk(bulk, new Header[0]);
        DeleteOperationResponse dor = new DeleteOperationResponse(response.getTookInMillis());
        return dor;
    }

    public DeleteOperationResponse deleteByQuery(String query, String index, String type) throws IOException {
        long start = System.currentTimeMillis();
        Response response = this.runQuery("_delete_by_query", query, index, type);
        long end = System.currentTimeMillis();
        Map<String, Object> parsed = this.parseResponse(response);
        return new DeleteOperationResponse(end - start);
    }

    public Map<String, Object> get(String index, String type, String id) throws IOException {
        GetRequest get = new GetRequest(index, type, id);
        GetResponse resp = this.highLevelClient.get(get, new Header[0]);
        return resp.getSource();
    }

    public SearchResponse search(String query, String index, String type) throws IOException {
        Response response = this.runQuery("_search", query, index, type);
        Map<String, Object> parsed = this.parseResponse(response);
        int took = (Integer)parsed.get("took");
        boolean timedOut = (Boolean)parsed.get("timed_out");
        Map aggregations = parsed.get("aggregations") != null ? (Map)parsed.get("aggregations") : new HashMap();
        Map hitsParent = (Map)parsed.get("hits");
        int count = (Integer)hitsParent.get("total");
        List hits = (List)hitsParent.get("hits");
        SearchResponse esr = new SearchResponse(hits, aggregations, count, took, timedOut);
        if (this.getLogger().isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("******************");
            sb.append(String.format("Took: %d", took));
            sb.append(String.format("Timed out: %s", timedOut));
            sb.append(String.format("Aggregation count: %d", aggregations.size()));
            sb.append(String.format("Hit count: %d", hits.size()));
            sb.append(String.format("Total found: %d", count));
            sb.append("******************");
            this.getLogger().debug(sb.toString());
        }
        return esr;
    }

    public String getTransitUrl(String index, String type) {
        return this.url + (index != null && !index.equals("") ? "/" : "") + (index != null ? index : "") + (type != null && !type.equals("") ? "/" : "") + (type != null ? type : "");
    }

    static {
        ArrayList<PropertyDescriptor> _props = new ArrayList<PropertyDescriptor>();
        _props.add(ElasticSearchClientService.HTTP_HOSTS);
        _props.add(ElasticSearchClientService.USERNAME);
        _props.add(ElasticSearchClientService.PASSWORD);
        _props.add(ElasticSearchClientService.PROP_SSL_CONTEXT_SERVICE);
        _props.add(ElasticSearchClientService.CONNECT_TIMEOUT);
        _props.add(ElasticSearchClientService.SOCKET_TIMEOUT);
        _props.add(ElasticSearchClientService.RETRY_TIMEOUT);
        _props.add(ElasticSearchClientService.CHARSET);
        properties = Collections.unmodifiableList(_props);
    }
}

