/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.elasticsearch.ElasticSearchClientService;
import org.apache.nifi.elasticsearch.SearchResponse;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.lookup.LookupFailureException;
import org.apache.nifi.lookup.LookupService;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.record.path.FieldValue;
import org.apache.nifi.record.path.RecordPath;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.JsonInferenceSchemaRegistryService;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordSchema;

@CapabilityDescription(value="Lookup a record from Elasticsearch Server associated with the specified document ID. The coordinates that are passed to the lookup must contain the key 'id'.")
@Tags(value={"lookup", "enrich", "record", "elasticsearch"})
public class ElasticSearchLookupService
extends JsonInferenceSchemaRegistryService
implements LookupService<Record> {
    public static final PropertyDescriptor CLIENT_SERVICE = new PropertyDescriptor.Builder().name("el-rest-client-service").displayName("Client Service").description("An ElasticSearch client service to use for running queries.").identifiesControllerService(ElasticSearchClientService.class).required(true).build();
    public static final PropertyDescriptor INDEX = new PropertyDescriptor.Builder().name("el-lookup-index").displayName("Index").description("The name of the index to read from").required(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor TYPE = new PropertyDescriptor.Builder().name("el-lookup-type").displayName("Type").description("The type of this document (used by Elasticsearch for indexing and searching)").required(false).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    private ElasticSearchClientService clientService;
    private String index;
    private String type;
    private ObjectMapper mapper;
    private final List<PropertyDescriptor> DESCRIPTORS;
    private volatile ConcurrentHashMap<String, RecordPath> mappings;

    public ElasticSearchLookupService() {
        ArrayList<PropertyDescriptor> _desc = new ArrayList<PropertyDescriptor>();
        _desc.addAll(super.getSupportedPropertyDescriptors());
        _desc.add(CLIENT_SERVICE);
        _desc.add(INDEX);
        _desc.add(TYPE);
        this.DESCRIPTORS = Collections.unmodifiableList(_desc);
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        this.clientService = (ElasticSearchClientService)context.getProperty(CLIENT_SERVICE).asControllerService(ElasticSearchClientService.class);
        this.index = context.getProperty(INDEX).evaluateAttributeExpressions().getValue();
        this.type = context.getProperty(TYPE).evaluateAttributeExpressions().getValue();
        this.mapper = new ObjectMapper();
        List dynamic = context.getProperties().entrySet().stream().filter(e -> ((PropertyDescriptor)e.getKey()).isDynamic()).map(e -> (PropertyDescriptor)e.getKey()).collect(Collectors.toList());
        HashMap<String, RecordPath> _temp = new HashMap<String, RecordPath>();
        for (PropertyDescriptor desc : dynamic) {
            String value = context.getProperty(desc).getValue();
            String name = desc.getName();
            _temp.put(name, RecordPath.compile((String)value));
        }
        this.mappings = new ConcurrentHashMap(_temp);
        super.onEnabled(context);
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.DESCRIPTORS;
    }

    public PropertyDescriptor getSupportedDynamicPropertyDescriptor(String name) {
        return new PropertyDescriptor.Builder().name(name).addValidator((subject, input, context) -> {
            ValidationResult.Builder builder = new ValidationResult.Builder();
            try {
                JsonPath.parse((String)input);
                builder.valid(true);
            }
            catch (Exception ex) {
                builder.explanation(ex.getMessage()).valid(false).subject(subject);
            }
            return builder.build();
        }).dynamic(true).build();
    }

    public Optional<Record> lookup(Map<String, Object> coordinates) throws LookupFailureException {
        Map<String, String> context = coordinates.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> e.getValue().toString()));
        return this.lookup(coordinates, context);
    }

    public Optional<Record> lookup(Map<String, Object> coordinates, Map<String, String> context) throws LookupFailureException {
        this.validateCoordinates(coordinates);
        try {
            Record record = coordinates.containsKey("_id") ? this.getById((String)coordinates.get("_id"), context) : this.getByQuery(coordinates, context);
            return record == null ? Optional.empty() : Optional.of(record);
        }
        catch (Exception ex) {
            this.getLogger().error("Error during lookup.", (Throwable)ex);
            throw new LookupFailureException((Throwable)ex);
        }
    }

    private void validateCoordinates(Map coordinates) throws LookupFailureException {
        ArrayList<String> reasons = new ArrayList<String>();
        if (coordinates.containsKey("_id") && !(coordinates.get("_id") instanceof String)) {
            reasons.add("_id was supplied, but it was not a String.");
        }
        if (coordinates.containsKey("_id") && coordinates.size() > 1) {
            reasons.add("When _id is used, it can be the only key used in the lookup.");
        }
        if (reasons.size() > 0) {
            String error = String.join((CharSequence)"\n", reasons);
            throw new LookupFailureException(error);
        }
    }

    private Record getById(final String _id, Map<String, String> context) throws IOException, LookupFailureException, SchemaNotFoundException {
        HashMap<String, Object> query = new HashMap<String, Object>(){
            {
                this.put("query", new HashMap<String, Object>(){
                    {
                        this.put("match", new HashMap<String, String>(){
                            {
                                this.put("_id", _id);
                            }
                        });
                    }
                });
            }
        };
        String json = this.mapper.writeValueAsString((Object)query);
        SearchResponse response = this.clientService.search(json, this.index, this.type);
        if (response.getNumberOfHits() > 1L) {
            throw new LookupFailureException(String.format("Expected 1 response, got %d for query %s", response.getNumberOfHits(), json));
        }
        if (response.getNumberOfHits() == 0L) {
            return null;
        }
        Map source = (Map)((Map)response.getHits().get(0)).get("_source");
        RecordSchema toUse = this.getSchema(context, source, null);
        MapRecord record = new MapRecord(toUse, source);
        if (this.mappings.size() > 0) {
            record = this.applyMappings((Record)record, source);
        }
        return record;
    }

    Map<String, Object> getNested(final String key, final Object value) {
        final String path = key.substring(0, key.lastIndexOf("."));
        return new HashMap<String, Object>(){
            {
                this.put("path", path);
                this.put("query", new HashMap<String, Object>(){
                    {
                        this.put("match", new HashMap<String, Object>(){
                            {
                                this.put(key, value);
                            }
                        });
                    }
                });
            }
        };
    }

    private Map<String, Object> buildQuery(final Map<String, Object> coordinates) {
        final HashMap<String, Object> query = new HashMap<String, Object>(){
            {
                this.put("bool", new HashMap<String, Object>(){
                    {
                        this.put("must", coordinates.entrySet().stream().map(e -> new HashMap<String, Object>(){
                            {
                                if (((String)e.getKey()).contains(".")) {
                                    this.put("nested", ElasticSearchLookupService.this.getNested((String)e.getKey(), e.getValue()));
                                } else {
                                    this.put("match", new HashMap<String, Object>(){
                                        {
                                            this.put(e.getKey(), e.getValue());
                                        }
                                    });
                                }
                            }
                        }).collect(Collectors.toList()));
                    }
                });
            }
        };
        HashMap<String, Object> outter = new HashMap<String, Object>(){
            {
                this.put("size", 1);
                this.put("query", query);
            }
        };
        return outter;
    }

    private Record getByQuery(Map<String, Object> query, Map<String, String> context) throws LookupFailureException {
        try {
            String json = this.mapper.writeValueAsString(this.buildQuery(query));
            SearchResponse response = this.clientService.search(json, this.index, this.type);
            if (response.getNumberOfHits() == 0L) {
                return null;
            }
            Map source = (Map)((Map)response.getHits().get(0)).get("_source");
            RecordSchema toUse = this.getSchema(context, source, null);
            MapRecord record = new MapRecord(toUse, source);
            if (this.mappings.size() > 0) {
                record = this.applyMappings((Record)record, source);
            }
            return record;
        }
        catch (Exception e) {
            throw new LookupFailureException((Throwable)e);
        }
    }

    private Record applyMappings(Record record, Map<String, Object> source) {
        MapRecord _rec = new MapRecord(record.getSchema(), new HashMap());
        this.mappings.entrySet().forEach(arg_0 -> ElasticSearchLookupService.lambda$applyMappings$5(source, (Record)_rec, arg_0));
        return _rec;
    }

    public Class<?> getValueType() {
        return Record.class;
    }

    public Set<String> getRequiredKeys() {
        return Collections.emptySet();
    }

    private static /* synthetic */ void lambda$applyMappings$5(Map source, Record _rec, Map.Entry entry) {
        try {
            Object o = JsonPath.read((Object)source, (String)((String)entry.getKey()), (Predicate[])new Predicate[0]);
            RecordPath path = (RecordPath)entry.getValue();
            Optional first = path.evaluate(_rec).getSelectedFields().findFirst();
            if (first.isPresent()) {
                ((FieldValue)first.get()).updateValue(o);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

