/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.elasticsearch.ElasticSearchClientService;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.lookup.LookupFailureException;
import org.apache.nifi.lookup.StringLookupService;
import org.apache.nifi.processor.util.StandardValidators;

@CapabilityDescription(value="Lookup a string value from Elasticsearch Server associated with the specified document ID. The coordinates that are passed to the lookup must contain the key 'id'.")
@Tags(value={"lookup", "enrich", "value", "key", "elasticsearch"})
public class ElasticSearchStringLookupService
extends AbstractControllerService
implements StringLookupService {
    public static final PropertyDescriptor CLIENT_SERVICE = new PropertyDescriptor.Builder().name("el-rest-client-service").displayName("Client Service").description("An ElasticSearch client service to use for running queries.").identifiesControllerService(ElasticSearchClientService.class).required(true).build();
    public static final PropertyDescriptor INDEX = new PropertyDescriptor.Builder().name("el-lookup-index").displayName("Index").description("The name of the index to read from").required(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor TYPE = new PropertyDescriptor.Builder().name("el-lookup-type").displayName("Type").description("The type of this document (used by Elasticsearch for indexing and searching)").required(false).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    private static final List<PropertyDescriptor> DESCRIPTORS = Arrays.asList(CLIENT_SERVICE, INDEX, TYPE);
    private static final ObjectMapper mapper = new ObjectMapper();
    public static final String ID = "es_document_id";
    private ElasticSearchClientService esClient;
    private String index;
    private String type;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return DESCRIPTORS;
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        this.esClient = (ElasticSearchClientService)context.getProperty(CLIENT_SERVICE).asControllerService(ElasticSearchClientService.class);
        this.index = context.getProperty(INDEX).evaluateAttributeExpressions().getValue();
        this.type = context.getProperty(TYPE).evaluateAttributeExpressions().getValue();
    }

    public Optional<String> lookup(Map<String, Object> coordinates) throws LookupFailureException {
        try {
            String id = (String)coordinates.get(ID);
            Map enums = this.esClient.get(this.index, this.type, id);
            return Optional.of(mapper.writeValueAsString((Object)enums));
        }
        catch (IOException e) {
            throw new LookupFailureException((Throwable)e);
        }
    }

    public Set<String> getRequiredKeys() {
        return Collections.singleton(ID);
    }
}

