/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.elasticsearch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.elasticsearch.DeleteOperationResponse;
import org.apache.nifi.elasticsearch.ElasticSearchClientService;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.elasticsearch.ElasticSearchRestProcessor;
import org.apache.nifi.util.StringUtils;

@InputRequirement(value=InputRequirement.Requirement.INPUT_ALLOWED)
@CapabilityDescription(value="Delete from an ElasticSearch index using a query. The query can be loaded from a flowfile body or from the Query parameter.")
@Tags(value={"elastic", "elasticsearch", "delete", "query"})
@WritesAttributes(value={@WritesAttribute(attribute="elasticsearch.delete.took", description="The amount of time that it took to complete the delete operation in ms."), @WritesAttribute(attribute="elasticsearch.delete.error", description="The error message provided by ElasticSearch if there is an error running the delete.")})
public class DeleteByQueryElasticsearch
extends AbstractProcessor
implements ElasticSearchRestProcessor {
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("If the delete by query fails, and a flowfile was read, it will be sent to this relationship.").build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("If the delete by query succeeds, and a flowfile was read, it will be sent to this relationship.").build();
    static final String TOOK_ATTRIBUTE = "elasticsearch.delete.took";
    static final String ERROR_ATTRIBUTE = "elasticsearch.delete.error";
    private static final Set<Relationship> relationships;
    private static final List<PropertyDescriptor> propertyDescriptors;
    private volatile ElasticSearchClientService clientService;

    public Set<Relationship> getRelationships() {
        return relationships;
    }

    public final List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return propertyDescriptors;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        this.clientService = (ElasticSearchClientService)context.getProperty(CLIENT_SERVICE).asControllerService(ElasticSearchClientService.class);
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile input = null;
        if (context.hasIncomingConnection() && (input = session.get()) == null && context.hasNonLoopConnection()) {
            return;
        }
        try {
            String query = this.getQuery(input, context, session);
            String index = context.getProperty(INDEX).evaluateAttributeExpressions(input).getValue();
            String type = context.getProperty(TYPE).isSet() ? context.getProperty(TYPE).evaluateAttributeExpressions(input).getValue() : null;
            String queryAttr = context.getProperty(QUERY_ATTRIBUTE).isSet() ? context.getProperty(QUERY_ATTRIBUTE).evaluateAttributeExpressions(input).getValue() : null;
            DeleteOperationResponse dor = this.clientService.deleteByQuery(query, index, type);
            if (input == null) {
                input = session.create();
            }
            HashMap<String, String> attrs = new HashMap<String, String>();
            attrs.put(TOOK_ATTRIBUTE, String.valueOf(dor.getTook()));
            if (!StringUtils.isBlank((String)queryAttr)) {
                attrs.put(queryAttr, query);
            }
            input = session.putAllAttributes(input, attrs);
            session.transfer(input, REL_SUCCESS);
        }
        catch (Exception e) {
            if (input != null) {
                input = session.putAttribute(input, ERROR_ATTRIBUTE, e.getMessage());
                session.transfer(input, REL_FAILURE);
            }
            this.getLogger().error("Error running delete by query: ", (Throwable)e);
            context.yield();
        }
    }

    static {
        HashSet<Relationship> _rels = new HashSet<Relationship>();
        _rels.add(REL_SUCCESS);
        _rels.add(REL_FAILURE);
        relationships = Collections.unmodifiableSet(_rels);
        ArrayList<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>();
        descriptors.add(QUERY);
        descriptors.add(QUERY_ATTRIBUTE);
        descriptors.add(INDEX);
        descriptors.add(TYPE);
        descriptors.add(CLIENT_SERVICE);
        propertyDescriptors = Collections.unmodifiableList(descriptors);
    }
}

