/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.elasticsearch;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.Validator;
import org.apache.nifi.elasticsearch.ElasticSearchClientService;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.util.JsonValidator;
import org.apache.nifi.processor.util.StandardValidators;

public interface ElasticSearchRestProcessor {
    public static final PropertyDescriptor INDEX = new PropertyDescriptor.Builder().name("el-rest-fetch-index").displayName("Index").description("The name of the index to use.").required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor TYPE = new PropertyDescriptor.Builder().name("el-rest-type").displayName("Type").description("The type of this document (used by Elasticsearch for indexing and searching)").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor QUERY = new PropertyDescriptor.Builder().name("el-rest-query").displayName("Query").description("A query in JSON syntax, not Lucene syntax. Ex: {\"query\":{\"match\":{\"somefield\":\"somevalue\"}}}. If this parameter is not set, the query will be read from the flowfile content.").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator((Validator)JsonValidator.INSTANCE).build();
    public static final PropertyDescriptor QUERY_ATTRIBUTE = new PropertyDescriptor.Builder().name("el-query-attribute").displayName("Query Attribute").description("If set, the executed query will be set on each result flowfile in the specified attribute.").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(Validator.VALID).required(false).build();
    public static final PropertyDescriptor CLIENT_SERVICE = new PropertyDescriptor.Builder().name("el-rest-client-service").displayName("Client Service").description("An ElasticSearch client service to use for running queries.").identifiesControllerService(ElasticSearchClientService.class).required(true).build();

    default public String getQuery(FlowFile input, ProcessContext context, ProcessSession session) throws IOException {
        String retVal = null;
        if (context.getProperty(QUERY).isSet()) {
            retVal = context.getProperty(QUERY).evaluateAttributeExpressions(input).getValue();
        } else if (input != null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            session.exportTo(input, (OutputStream)out);
            out.close();
            retVal = new String(out.toByteArray());
        }
        return retVal;
    }
}

