/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.email;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.mail.util.ByteArrayDataSource;
import microsoft.exchange.webservices.data.autodiscover.IAutodiscoverRedirectionUrl;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.PropertySet;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.property.BodyType;
import microsoft.exchange.webservices.data.core.enumeration.property.WellKnownFolderName;
import microsoft.exchange.webservices.data.core.enumeration.search.FolderTraversal;
import microsoft.exchange.webservices.data.core.enumeration.search.LogicalOperator;
import microsoft.exchange.webservices.data.core.enumeration.search.SortDirection;
import microsoft.exchange.webservices.data.core.enumeration.service.ConflictResolutionMode;
import microsoft.exchange.webservices.data.core.enumeration.service.DeleteMode;
import microsoft.exchange.webservices.data.core.service.folder.Folder;
import microsoft.exchange.webservices.data.core.service.item.EmailMessage;
import microsoft.exchange.webservices.data.core.service.item.Item;
import microsoft.exchange.webservices.data.core.service.schema.EmailMessageSchema;
import microsoft.exchange.webservices.data.core.service.schema.FolderSchema;
import microsoft.exchange.webservices.data.core.service.schema.ItemSchema;
import microsoft.exchange.webservices.data.credential.ExchangeCredentials;
import microsoft.exchange.webservices.data.credential.WebCredentials;
import microsoft.exchange.webservices.data.property.complex.Attachment;
import microsoft.exchange.webservices.data.property.complex.EmailAddress;
import microsoft.exchange.webservices.data.property.complex.FileAttachment;
import microsoft.exchange.webservices.data.property.complex.FolderId;
import microsoft.exchange.webservices.data.property.complex.InternetMessageHeader;
import microsoft.exchange.webservices.data.property.definition.PropertyDefinitionBase;
import microsoft.exchange.webservices.data.search.FindFoldersResults;
import microsoft.exchange.webservices.data.search.FindItemsResults;
import microsoft.exchange.webservices.data.search.FolderView;
import microsoft.exchange.webservices.data.search.ItemView;
import microsoft.exchange.webservices.data.search.filter.SearchFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.apache.commons.mail.MultiPartEmail;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.Validator;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.OutputStreamCallback;
import org.apache.nifi.processor.util.StandardValidators;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InputRequirement(value=InputRequirement.Requirement.INPUT_FORBIDDEN)
@CapabilityDescription(value="Consumes messages from Microsoft Exchange using Exchange Web Services. The raw-bytes of each received email message are written as contents of the FlowFile")
@Tags(value={"Email", "EWS", "Exchange", "Get", "Ingest", "Ingress", "Message", "Consume"})
public class ConsumeEWS
extends AbstractProcessor {
    public static final PropertyDescriptor USER = new PropertyDescriptor.Builder().name("user").displayName("User Name").description("User Name used for authentication and authorization with Email server.").required(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor PASSWORD = new PropertyDescriptor.Builder().name("password").displayName("Password").description("Password used for authentication and authorization with Email server.").required(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(true).build();
    public static final PropertyDescriptor FOLDER = new PropertyDescriptor.Builder().name("folder").displayName("Folder").description("Email folder to retrieve messages from (e.g., INBOX)").required(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).defaultValue("INBOX").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor FETCH_SIZE = new PropertyDescriptor.Builder().name("fetch.size").displayName("Fetch Size").description("Specify the maximum number of Messages to fetch per call to Email Server.").required(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).defaultValue("10").addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).build();
    public static final PropertyDescriptor SHOULD_DELETE_MESSAGES = new PropertyDescriptor.Builder().name("delete.messages").displayName("Delete Messages").description("Specify whether mail messages should be deleted after retrieval.").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("false").addValidator(StandardValidators.BOOLEAN_VALIDATOR).build();
    static final PropertyDescriptor CONNECTION_TIMEOUT = new PropertyDescriptor.Builder().name("connection.timeout").displayName("Connection timeout").description("The amount of time to wait to connect to Email server").required(true).addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).defaultValue("30 sec").build();
    public static final PropertyDescriptor EXCHANGE_VERSION = new PropertyDescriptor.Builder().name("mail-ews-version").displayName("Exchange Version").description("What version of Exchange Server the server is running.").required(true).allowableValues((Enum[])ExchangeVersion.values()).defaultValue(ExchangeVersion.Exchange2010_SP2.name()).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor EWS_URL = new PropertyDescriptor.Builder().name("ews-url").displayName("EWS URL").description("URL of the EWS Endpoint. Required if Autodiscover is false.").required(false).addValidator(StandardValidators.URL_VALIDATOR).build();
    public static final PropertyDescriptor USE_AUTODISCOVER = new PropertyDescriptor.Builder().name("ews-autodiscover").displayName("Auto Discover URL").description("Whether or not to use the Exchange email address to Autodiscover the EWS endpoint URL.").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("true").build();
    public static final PropertyDescriptor SHOULD_MARK_READ = new PropertyDescriptor.Builder().name("ews-mark-as-read").displayName("Mark Messages as Read").description("Specify if messages should be marked as read after retrieval.").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("true").addValidator(StandardValidators.BOOLEAN_VALIDATOR).build();
    public static final PropertyDescriptor INCLUDE_EMAIL_HEADERS = new PropertyDescriptor.Builder().name("ews-include-headers").displayName("Original Headers to Include").description("Comma delimited list specifying which headers from the original message to include in the exported email message. Blank means copy all headers. Some headers can cause problems with message parsing, specifically the 'Content-Type' header.").defaultValue("").addValidator(Validator.VALID).build();
    public static final PropertyDescriptor EXCLUDE_EMAIL_HEADERS = new PropertyDescriptor.Builder().name("ews-exclude-headers").displayName("Original Headers to Exclude").description("Comma delimited list specifying which headers from the original message to exclude in the exported email message. Blank means don't exclude any headers.").defaultValue("").addValidator(Validator.VALID).build();
    static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("All messages that are the are successfully received from Email server and converted to FlowFiles are routed to this relationship").build();
    protected final List<PropertyDescriptor> DESCRIPTORS;
    protected final Set<Relationship> RELATIONSHIPS;
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected volatile BlockingQueue<Message> messageQueue;
    protected volatile String displayUrl;
    protected volatile ProcessSession processSession;
    protected volatile boolean shouldSetDeleteFlag;
    protected volatile String folderName;

    public ConsumeEWS() {
        HashSet<Relationship> relationshipSet = new HashSet<Relationship>();
        relationshipSet.add(REL_SUCCESS);
        this.RELATIONSHIPS = relationshipSet;
        ArrayList<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>();
        descriptors.add(USER);
        descriptors.add(PASSWORD);
        descriptors.add(FOLDER);
        descriptors.add(FETCH_SIZE);
        descriptors.add(SHOULD_DELETE_MESSAGES);
        descriptors.add(CONNECTION_TIMEOUT);
        descriptors.add(EXCHANGE_VERSION);
        descriptors.add(EWS_URL);
        descriptors.add(USE_AUTODISCOVER);
        descriptors.add(SHOULD_MARK_READ);
        descriptors.add(INCLUDE_EMAIL_HEADERS);
        descriptors.add(EXCLUDE_EMAIL_HEADERS);
        this.DESCRIPTORS = descriptors;
    }

    public Set<Relationship> getRelationships() {
        return this.RELATIONSHIPS;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.DESCRIPTORS;
    }

    public void onTrigger(ProcessContext context, ProcessSession processSession) throws ProcessException {
        if (this.messageQueue == null) {
            int fetchSize = context.getProperty(FETCH_SIZE).evaluateAttributeExpressions().asInteger();
            this.messageQueue = new ArrayBlockingQueue<Message>(fetchSize);
        }
        this.folderName = context.getProperty(FOLDER).evaluateAttributeExpressions().getValue();
        Message emailMessage = this.receiveMessage(context);
        if (emailMessage != null) {
            this.transfer(emailMessage, context, processSession);
        } else {
            context.yield();
        }
    }

    protected ExchangeService initializeIfNecessary(ProcessContext context) throws ProcessException {
        ExchangeVersion ver = ExchangeVersion.valueOf((String)context.getProperty(EXCHANGE_VERSION).getValue());
        ExchangeService service = new ExchangeService(ver);
        String timeoutInMillis = String.valueOf(context.getProperty(CONNECTION_TIMEOUT).evaluateAttributeExpressions().asTimePeriod(TimeUnit.MILLISECONDS));
        service.setTimeout(Integer.parseInt(timeoutInMillis));
        String userEmail = context.getProperty(USER).evaluateAttributeExpressions().getValue();
        String password = context.getProperty(PASSWORD).evaluateAttributeExpressions().getValue();
        WebCredentials credentials = new WebCredentials(userEmail, password);
        service.setCredentials((ExchangeCredentials)credentials);
        Boolean useAutodiscover = context.getProperty(USE_AUTODISCOVER).asBoolean();
        if (useAutodiscover.booleanValue()) {
            try {
                service.autodiscoverUrl(userEmail, (IAutodiscoverRedirectionUrl)new RedirectionUrlCallback());
            }
            catch (Exception e) {
                throw new ProcessException("Failure setting Autodiscover URL from email address.", (Throwable)e);
            }
        }
        String ewsURL = context.getProperty(EWS_URL).getValue();
        try {
            service.setUrl(new URI(ewsURL));
        }
        catch (URISyntaxException e) {
            throw new ProcessException("Failure setting EWS URL.", (Throwable)e);
        }
        return service;
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().description("Specifies the value for '" + propertyDescriptorName + "' Java Mail property.").name(propertyDescriptorName).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).dynamic(true).build();
    }

    protected String getProtocol(ProcessContext processContext) {
        return "ews";
    }

    protected void fillMessageQueueIfNecessary(ProcessContext context) throws ProcessException {
        if (this.messageQueue.isEmpty()) {
            ExchangeService service = this.initializeIfNecessary(context);
            boolean deleteOnRead = context.getProperty(SHOULD_DELETE_MESSAGES).getValue().equals("true");
            boolean markAsRead = context.getProperty(SHOULD_MARK_READ).getValue().equals("true");
            String includeHeaders = context.getProperty(INCLUDE_EMAIL_HEADERS).getValue();
            String excludeHeaders = context.getProperty(EXCLUDE_EMAIL_HEADERS).getValue();
            List<String> includeHeadersList = null;
            List<String> excludeHeadersList = null;
            if (!StringUtils.isEmpty((CharSequence)includeHeaders)) {
                includeHeadersList = Arrays.asList(includeHeaders.split(","));
            }
            if (!StringUtils.isEmpty((CharSequence)excludeHeaders)) {
                excludeHeadersList = Arrays.asList(excludeHeaders.split(","));
            }
            try {
                Folder folder = this.getFolder(service);
                ItemView view = new ItemView(this.messageQueue.remainingCapacity());
                view.getOrderBy().add((PropertyDefinitionBase)ItemSchema.DateTimeReceived, SortDirection.Ascending);
                SearchFilter.SearchFilterCollection sf = new SearchFilter.SearchFilterCollection(LogicalOperator.And, new SearchFilter[]{new SearchFilter.IsEqualTo((PropertyDefinitionBase)EmailMessageSchema.IsRead, (Object)false)});
                FindItemsResults findResults = service.findItems(folder.getId(), (SearchFilter)sf, view);
                if (findResults == null || findResults.getItems().size() == 0) {
                    return;
                }
                service.loadPropertiesForItems((Iterable)findResults, PropertySet.FirstClassProperties);
                for (Item item : findResults) {
                    EmailMessage ewsMessage = (EmailMessage)item;
                    this.messageQueue.add((Message)this.parseMessage(ewsMessage, includeHeadersList, excludeHeadersList));
                    if (deleteOnRead) {
                        ewsMessage.delete(DeleteMode.HardDelete);
                        continue;
                    }
                    if (!markAsRead) continue;
                    ewsMessage.setIsRead(Boolean.valueOf(true));
                    ewsMessage.update(ConflictResolutionMode.AlwaysOverwrite);
                }
                service.close();
            }
            catch (Exception e) {
                throw new ProcessException("Failed retrieving new messages from EWS.", (Throwable)e);
            }
        }
    }

    protected Folder getFolder(ExchangeService service) {
        Folder folder;
        if (this.folderName.equals("INBOX")) {
            try {
                folder = Folder.bind((ExchangeService)service, (WellKnownFolderName)WellKnownFolderName.Inbox);
            }
            catch (Exception e) {
                throw new ProcessException("Failed to bind Inbox Folder on EWS Server", (Throwable)e);
            }
        }
        FolderView view = new FolderView(10);
        view.setTraversal(FolderTraversal.Deep);
        SearchFilter.IsEqualTo searchFilter = new SearchFilter.IsEqualTo((PropertyDefinitionBase)FolderSchema.DisplayName, (Object)this.folderName);
        try {
            FindFoldersResults foldersResults = service.findFolders(WellKnownFolderName.Root, (SearchFilter)searchFilter, view);
            ArrayList folderIds = foldersResults.getFolders();
            if (folderIds.size() > 1) {
                throw new ProcessException("More than 1 folder found with the name " + this.folderName);
            }
            folder = Folder.bind((ExchangeService)service, (FolderId)((Folder)folderIds.get(0)).getId());
        }
        catch (Exception e) {
            throw new ProcessException("Search for Inbox Subfolder failed.", (Throwable)e);
        }
        return folder;
    }

    public MimeMessage parseMessage(EmailMessage item, List<String> hdrIncludeList, List<String> hdrExcludeList) throws Exception {
        HtmlEmail mm;
        EmailMessage ewsMessage = item;
        String bodyText = ewsMessage.getBody().toString();
        if (ewsMessage.getBody().getBodyType() == BodyType.HTML) {
            mm = new HtmlEmail();
            if (!StringUtils.isEmpty((CharSequence)bodyText)) {
                mm.setHtmlMsg(bodyText);
            }
        } else {
            mm = new MultiPartEmail();
            if (!StringUtils.isEmpty((CharSequence)bodyText)) {
                mm.setMsg(bodyText);
            }
        }
        mm.setHostName("NiFi-EWS");
        mm.setFrom(ewsMessage.getFrom().getAddress());
        ewsMessage.getToRecipients().forEach(arg_0 -> ConsumeEWS.lambda$parseMessage$0((MultiPartEmail)mm, arg_0));
        ewsMessage.getCcRecipients().forEach(arg_0 -> ConsumeEWS.lambda$parseMessage$1((MultiPartEmail)mm, arg_0));
        mm.setSubject(ewsMessage.getSubject());
        mm.setSentDate(ewsMessage.getDateTimeSent());
        ewsMessage.getInternetMessageHeaders().getItems().stream().filter(x -> !(hdrIncludeList != null && !hdrIncludeList.isEmpty() && !hdrIncludeList.contains(x.getName()) || hdrExcludeList != null && !hdrExcludeList.isEmpty() && hdrExcludeList.contains(x.getName()))).forEach(arg_0 -> ConsumeEWS.lambda$parseMessage$3((MultiPartEmail)mm, arg_0));
        if (ewsMessage.getHasAttachments()) {
            ewsMessage.getAttachments().forEach(arg_0 -> ConsumeEWS.lambda$parseMessage$4((MultiPartEmail)mm, arg_0));
        }
        mm.buildMimeMessage();
        return mm.getMimeMessage();
    }

    private void transfer(final Message emailMessage, ProcessContext context, ProcessSession processSession) {
        long start = System.nanoTime();
        FlowFile flowFile = processSession.create();
        flowFile = processSession.append(flowFile, new OutputStreamCallback(){

            public void process(OutputStream out) throws IOException {
                try {
                    emailMessage.writeTo(out);
                }
                catch (MessagingException e) {
                    throw new IOException(e);
                }
            }
        });
        long executionDuration = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
        String fromAddressesString = "";
        try {
            Address[] fromAddresses = emailMessage.getFrom();
            if (fromAddresses != null) {
                fromAddressesString = Arrays.asList(fromAddresses).toString();
            }
        }
        catch (MessagingException e) {
            this.logger.warn("Faild to retrieve 'From' attribute from Message.");
        }
        processSession.getProvenanceReporter().receive(flowFile, this.displayUrl, "Received message from " + fromAddressesString, executionDuration);
        this.getLogger().info("Successfully received {} from {} in {} millis", new Object[]{flowFile, fromAddressesString, executionDuration});
        processSession.transfer(flowFile, REL_SUCCESS);
        try {
            emailMessage.setFlag(Flags.Flag.DELETED, this.shouldSetDeleteFlag);
        }
        catch (MessagingException e) {
            this.logger.warn("Failed to set DELETE Flag on the message, data duplication may occur.");
        }
    }

    protected Message receiveMessage(ProcessContext context) {
        Message emailMessage = null;
        try {
            this.fillMessageQueueIfNecessary(context);
            emailMessage = this.messageQueue.poll(1L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            context.yield();
            this.logger.error("Failed retrieving messages from EWS.", (Throwable)e);
            Thread.currentThread().interrupt();
            this.logger.debug("Current thread is interrupted");
        }
        return emailMessage;
    }

    @OnStopped
    public void stop(ProcessContext processContext) {
        this.flushRemainingMessages(processContext);
    }

    protected void flushRemainingMessages(ProcessContext processContext) {
        try {
            Message emailMessage;
            while ((emailMessage = this.messageQueue.poll(1L, TimeUnit.MILLISECONDS)) != null) {
                this.transfer(emailMessage, processContext, this.processSession);
                this.processSession.commit();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.logger.debug("Current thread is interrupted");
        }
    }

    private static /* synthetic */ void lambda$parseMessage$4(MultiPartEmail mm, Attachment x) {
        try {
            FileAttachment file = (FileAttachment)x;
            file.load();
            ByteArrayDataSource bds = new ByteArrayDataSource(file.getContent(), file.getContentType());
            mm.attach((DataSource)bds, file.getName(), "", "attachment");
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static /* synthetic */ void lambda$parseMessage$3(MultiPartEmail mm, InternetMessageHeader x) {
        mm.addHeader(x.getName(), x.getValue());
    }

    private static /* synthetic */ void lambda$parseMessage$1(MultiPartEmail mm, EmailAddress x) {
        try {
            mm.addCc(x.getAddress());
        }
        catch (EmailException e) {
            throw new ProcessException("Failed to add CC recipient.", (Throwable)e);
        }
    }

    private static /* synthetic */ void lambda$parseMessage$0(MultiPartEmail mm, EmailAddress x) {
        try {
            mm.addTo(x.getAddress());
        }
        catch (EmailException e) {
            throw new ProcessException("Failed to add TO recipient.", (Throwable)e);
        }
    }

    static class RedirectionUrlCallback
    implements IAutodiscoverRedirectionUrl {
        RedirectionUrlCallback() {
        }

        public boolean autodiscoverRedirectionUrlValidationCallback(String redirectionUrl) {
            return redirectionUrl.toLowerCase().startsWith("https://");
        }
    }
}

