/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.evtx.parser.bxml.value;

import com.google.common.primitives.UnsignedInteger;
import java.io.IOException;
import org.apache.nifi.processors.evtx.parser.BinaryReader;
import org.apache.nifi.processors.evtx.parser.ChunkHeader;
import org.apache.nifi.processors.evtx.parser.bxml.BxmlNode;
import org.apache.nifi.processors.evtx.parser.bxml.value.VariantTypeNode;

public class SIDTypeNode
extends VariantTypeNode {
    private final String value;

    public SIDTypeNode(BinaryReader binaryReader, ChunkHeader chunkHeader, BxmlNode parent, int length) throws IOException {
        super(binaryReader, chunkHeader, parent, length);
        int version = binaryReader.read();
        int num_elements = binaryReader.read();
        UnsignedInteger id_high = binaryReader.readDWordBE();
        int id_low = binaryReader.readWordBE();
        StringBuilder builder = new StringBuilder("S-");
        builder.append(version);
        builder.append("-");
        builder.append(id_high.longValue() << 16 ^ (long)id_low);
        for (int i = 0; i < num_elements; ++i) {
            builder.append("-");
            builder.append(binaryReader.readDWord());
        }
        this.value = builder.toString();
    }

    @Override
    public String getValue() {
        return this.value;
    }
}

