/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language;

import org.apache.nifi.attribute.expression.language.Query;
import org.apache.nifi.attribute.expression.language.StandardAttributeExpression;
import org.apache.nifi.attribute.expression.language.exception.AttributeExpressionLanguageParsingException;
import org.apache.nifi.expression.AttributeExpression;
import org.apache.nifi.expression.ExpressionLanguageCompiler;
import org.apache.nifi.registry.VariableRegistry;

public class StandardExpressionLanguageCompiler
implements ExpressionLanguageCompiler {
    private final VariableRegistry variableRegistry;

    public StandardExpressionLanguageCompiler(VariableRegistry variableRegistry) {
        this.variableRegistry = variableRegistry;
    }

    public AttributeExpression compile(String expression) throws IllegalArgumentException {
        try {
            return new StandardAttributeExpression(Query.compile(expression), this.variableRegistry);
        }
        catch (AttributeExpressionLanguageParsingException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public boolean isValidExpression(String expression) {
        return Query.isValidExpression(expression);
    }

    public String validateExpression(String expression, boolean allowSurroundingCharacters) {
        try {
            Query.validateExpression(expression, allowSurroundingCharacters);
            return null;
        }
        catch (AttributeExpressionLanguageParsingException aelpe) {
            return aelpe.getMessage();
        }
    }

    public AttributeExpression.ResultType getResultType(String expression) throws IllegalArgumentException {
        try {
            return Query.getResultType(expression);
        }
        catch (AttributeExpressionLanguageParsingException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

