/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.cast;

import java.util.Map;
import java.util.regex.Pattern;
import org.apache.nifi.attribute.expression.language.evaluation.DateQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.NumberEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.NumberQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.StringQueryResult;
import org.apache.nifi.attribute.expression.language.exception.AttributeExpressionLanguageParsingException;
import org.apache.nifi.expression.AttributeExpression;

public class NumberCastEvaluator
extends NumberEvaluator {
    private final Evaluator<?> subjectEvaluator;
    private static final Pattern NUMBER_PATTERN = Pattern.compile("-?\\d+");

    public NumberCastEvaluator(Evaluator<?> subjectEvaluator) {
        if (subjectEvaluator.getResultType() == AttributeExpression.ResultType.BOOLEAN) {
            throw new AttributeExpressionLanguageParsingException("Cannot implicitly convert Data Type " + subjectEvaluator.getResultType() + " to " + AttributeExpression.ResultType.NUMBER);
        }
        this.subjectEvaluator = subjectEvaluator;
    }

    @Override
    public QueryResult<Long> evaluate(Map<String, String> attributes) {
        QueryResult<?> result = this.subjectEvaluator.evaluate(attributes);
        if (result.getValue() == null) {
            return new NumberQueryResult(null);
        }
        switch (result.getResultType()) {
            case NUMBER: {
                return (NumberQueryResult)result;
            }
            case STRING: {
                String trimmed = ((StringQueryResult)result).getValue().trim();
                if (NUMBER_PATTERN.matcher(trimmed).matches()) {
                    return new NumberQueryResult(Long.valueOf(trimmed));
                }
                return new NumberQueryResult(null);
            }
            case DATE: {
                return new NumberQueryResult(((DateQueryResult)result).getValue().getTime());
            }
        }
        return new NumberQueryResult(null);
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subjectEvaluator;
    }
}

