/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import java.util.Date;
import java.util.Map;
import org.apache.nifi.attribute.expression.language.evaluation.DateEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.NumberEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.NumberQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;

public class DateToNumberEvaluator
extends NumberEvaluator {
    private final DateEvaluator subjectEvaluator;

    public DateToNumberEvaluator(DateEvaluator subjectEvaluator) {
        this.subjectEvaluator = subjectEvaluator;
    }

    @Override
    public QueryResult<Long> evaluate(Map<String, String> attributes) {
        QueryResult subjectResult = this.subjectEvaluator.evaluate(attributes);
        if (subjectResult.getValue() == null) {
            return new NumberQueryResult(null);
        }
        return new NumberQueryResult(((Date)subjectResult.getValue()).getTime());
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subjectEvaluator;
    }
}

