/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import java.util.Map;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.NumberEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.NumberQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;

public class ModEvaluator
extends NumberEvaluator {
    private final Evaluator<Long> subject;
    private final Evaluator<Long> modValue;

    public ModEvaluator(Evaluator<Long> subject, Evaluator<Long> modValue) {
        this.subject = subject;
        this.modValue = modValue;
    }

    @Override
    public QueryResult<Long> evaluate(Map<String, String> attributes) {
        Long subjectValue = this.subject.evaluate(attributes).getValue();
        if (subjectValue == null) {
            return new NumberQueryResult(null);
        }
        Long mod = this.modValue.evaluate(attributes).getValue();
        if (mod == null) {
            return new NumberQueryResult(null);
        }
        long result = subjectValue % mod;
        return new NumberQueryResult(result);
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subject;
    }
}

