/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.apache.nifi.attribute.expression.language.evaluation.DateEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.DateQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.exception.IllegalAttributeException;

public class StringToDateEvaluator
extends DateEvaluator {
    private final Evaluator<String> subject;
    private final Evaluator<String> format;

    public StringToDateEvaluator(Evaluator<String> subject, Evaluator<String> format) {
        this.subject = subject;
        this.format = format;
    }

    @Override
    public QueryResult<Date> evaluate(Map<String, String> attributes) {
        String subjectValue = this.subject.evaluate(attributes).getValue();
        String formatValue = this.format.evaluate(attributes).getValue();
        if (subjectValue == null || formatValue == null) {
            return new DateQueryResult(null);
        }
        try {
            return new DateQueryResult(new SimpleDateFormat(formatValue, Locale.US).parse(subjectValue));
        }
        catch (ParseException e) {
            throw new IllegalAttributeException("Cannot parse attribute value as a date; date format: " + formatValue + "; attribute value: " + subjectValue);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalAttributeException("Invalid date format: " + formatValue);
        }
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subject;
    }
}

