/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.selection;

import java.util.Map;
import org.apache.nifi.attribute.expression.language.evaluation.BooleanEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.BooleanQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.selection.IteratingEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.selection.MultiAttributeEvaluator;

public class AllAttributesEvaluator
extends BooleanEvaluator
implements IteratingEvaluator<Boolean> {
    private final BooleanEvaluator booleanEvaluator;
    private final MultiAttributeEvaluator multiAttributeEvaluator;

    public AllAttributesEvaluator(BooleanEvaluator booleanEvaluator, MultiAttributeEvaluator multiAttributeEvaluator) {
        this.booleanEvaluator = booleanEvaluator;
        this.multiAttributeEvaluator = multiAttributeEvaluator;
    }

    @Override
    public QueryResult<Boolean> evaluate(Map<String, String> attributes) {
        QueryResult<Boolean> attributeValueQuery = this.booleanEvaluator.evaluate(attributes);
        Boolean result = (Boolean)attributeValueQuery.getValue();
        if (result == null) {
            return new BooleanQueryResult(false);
        }
        if (!result.booleanValue()) {
            return new BooleanQueryResult(false);
        }
        while (this.multiAttributeEvaluator.getEvaluationsRemaining() > 0) {
            attributeValueQuery = this.booleanEvaluator.evaluate(attributes);
            result = (Boolean)attributeValueQuery.getValue();
            if (result == null || result.booleanValue()) continue;
            return attributeValueQuery;
        }
        return new BooleanQueryResult(true);
    }

    @Override
    public int getEvaluationsRemaining() {
        return 0;
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return null;
    }

    @Override
    public Evaluator<?> getLogicEvaluator() {
        return this.booleanEvaluator;
    }
}

