/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.selection;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.StringQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.selection.MultiAttributeEvaluator;

public class MultiNamedAttributeEvaluator
extends MultiAttributeEvaluator {
    private final List<String> attributeNames;
    private final int evaluationType;
    private int evaluationCount = 0;
    private List<String> matchingAttributeNames = null;

    public MultiNamedAttributeEvaluator(List<String> attributeNames, int evaluationType) {
        this.attributeNames = attributeNames;
        this.evaluationType = evaluationType;
    }

    @Override
    public QueryResult<String> evaluate(Map<String, String> attributes) {
        this.matchingAttributeNames = new ArrayList<String>(this.attributeNames);
        if (this.matchingAttributeNames.size() <= this.evaluationCount) {
            return new StringQueryResult(null);
        }
        return new StringQueryResult(attributes.get(this.matchingAttributeNames.get(this.evaluationCount++)));
    }

    @Override
    public int getEvaluationsRemaining() {
        return this.matchingAttributeNames.size() - this.evaluationCount;
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return null;
    }

    @Override
    public int getEvaluationType() {
        return this.evaluationType;
    }

    @Override
    public Evaluator<?> getLogicEvaluator() {
        return this;
    }
}

