/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.flume;

import org.apache.flume.ChannelFullException;
import org.apache.flume.Context;
import org.apache.flume.channel.BasicChannelSemantics;
import org.apache.flume.channel.BasicTransactionSemantics;
import org.apache.flume.lifecycle.LifecycleState;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processors.flume.NifiTransaction;

public class NifiSessionFactoryChannel
extends BasicChannelSemantics {
    private final ProcessSessionFactory sessionFactory;
    private final Relationship relationship;

    public NifiSessionFactoryChannel(ProcessSessionFactory sessionFactory, Relationship relationship) {
        this.sessionFactory = sessionFactory;
        this.relationship = relationship;
    }

    protected BasicTransactionSemantics createTransaction() {
        LifecycleState lifecycleState = this.getLifecycleState();
        if (lifecycleState == LifecycleState.STOP) {
            throw new ChannelFullException("Can't write to a stopped channel");
        }
        return new NifiTransaction(this.sessionFactory.createSession(), this.relationship);
    }

    public void configure(Context context) {
    }
}

