/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.flume.util;

import com.google.common.collect.Maps;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Map;
import org.apache.flume.Event;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.io.InputStreamCallback;
import org.apache.nifi.stream.io.StreamUtils;

public class FlowFileEvent
implements Event {
    private final FlowFile flowFile;
    private final ProcessSession session;
    private final Map<String, String> headers;
    private boolean headersLoaded;
    private final Object bodyLock;
    private byte[] body;
    private boolean bodyLoaded;

    public FlowFileEvent(FlowFile flowFile, ProcessSession session) {
        this.flowFile = flowFile;
        this.session = session;
        this.headers = Maps.newHashMap();
        this.bodyLock = new Object();
        this.bodyLoaded = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getHeaders() {
        Map<String, String> map = this.headers;
        synchronized (map) {
            if (!this.headersLoaded) {
                this.headers.putAll(this.flowFile.getAttributes());
                this.headers.put("nifi.entry.date", Long.toString(this.flowFile.getEntryDate()));
                this.headers.put("nifi.id", Long.toString(this.flowFile.getId()));
                this.headers.put("nifi.last.queue.date", Long.toString(this.flowFile.getLastQueueDate()));
                this.headers.put("nifi.lineage.start.date", Long.toString(this.flowFile.getLineageStartDate()));
                this.headers.put("nifi.size", Long.toString(this.flowFile.getSize()));
                this.headersLoaded = true;
            }
        }
        return this.headers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHeaders(Map<String, String> headers) {
        Map<String, String> map = this.headers;
        synchronized (map) {
            this.headers.clear();
            this.headers.putAll(headers);
            this.headersLoaded = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBody() {
        Object object = this.bodyLock;
        synchronized (object) {
            if (!this.bodyLoaded) {
                if (this.flowFile.getSize() > Integer.MAX_VALUE) {
                    throw new RuntimeException("Can't get body of Event because the backing FlowFile is too large (" + this.flowFile.getSize() + " bytes)");
                }
                final ByteArrayOutputStream baos = new ByteArrayOutputStream((int)this.flowFile.getSize());
                this.session.read(this.flowFile, new InputStreamCallback(){

                    public void process(InputStream in) throws IOException {
                        try (BufferedInputStream input = new BufferedInputStream(in);){
                            StreamUtils.copy((InputStream)input, (OutputStream)baos);
                        }
                        baos.close();
                    }
                });
                this.body = baos.toByteArray();
                this.bodyLoaded = true;
            }
        }
        return this.body;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBody(byte[] body) {
        Object object = this.bodyLock;
        synchronized (object) {
            this.body = Arrays.copyOf(body, body.length);
            this.bodyLoaded = true;
        }
    }
}

