/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authorization;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.nifi.authorization.AccessPolicy;
import org.apache.nifi.authorization.AuthorizationRequest;
import org.apache.nifi.authorization.AuthorizationResult;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.AuthorizerConfigurationContext;
import org.apache.nifi.authorization.Group;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.User;
import org.apache.nifi.authorization.UsersAndAccessPolicies;
import org.apache.nifi.authorization.exception.AuthorizationAccessException;
import org.apache.nifi.authorization.exception.AuthorizerCreationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class AbstractPolicyBasedAuthorizer
implements Authorizer {
    static final DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY = DocumentBuilderFactory.newInstance();
    static final XMLOutputFactory XML_OUTPUT_FACTORY = XMLOutputFactory.newInstance();
    static final String USER_ELEMENT = "user";
    static final String GROUP_USER_ELEMENT = "groupUser";
    static final String GROUP_ELEMENT = "group";
    static final String POLICY_ELEMENT = "policy";
    static final String POLICY_USER_ELEMENT = "policyUser";
    static final String POLICY_GROUP_ELEMENT = "policyGroup";
    static final String IDENTIFIER_ATTR = "identifier";
    static final String IDENTITY_ATTR = "identity";
    static final String NAME_ATTR = "name";
    static final String RESOURCE_ATTR = "resource";
    static final String ACTIONS_ATTR = "actions";
    public static final String EMPTY_FINGERPRINT = "EMPTY";

    @Override
    public final void onConfigured(AuthorizerConfigurationContext configurationContext) throws AuthorizerCreationException {
        this.doOnConfigured(configurationContext);
        for (AccessPolicy accessPolicy : this.getAccessPolicies()) {
            if (!this.policyExists(accessPolicy)) continue;
            throw new AuthorizerCreationException(String.format("Found multiple policies for '%s' with '%s'.", new Object[]{accessPolicy.getResource(), accessPolicy.getAction()}));
        }
        for (User user : this.getUsers()) {
            if (!this.tenantExists(user.getIdentifier(), user.getIdentity())) continue;
            throw new AuthorizerCreationException(String.format("Found multiple users/user groups with identity '%s'.", user.getIdentity()));
        }
        for (Group group : this.getGroups()) {
            if (!this.tenantExists(group.getIdentifier(), group.getName())) continue;
            throw new AuthorizerCreationException(String.format("Found multiple users/user groups with name '%s'.", group.getName()));
        }
    }

    protected abstract void doOnConfigured(AuthorizerConfigurationContext var1) throws AuthorizerCreationException;

    private boolean policyExists(AccessPolicy checkAccessPolicy) {
        for (AccessPolicy accessPolicy : this.getAccessPolicies()) {
            if (accessPolicy.getIdentifier().equals(checkAccessPolicy.getIdentifier()) || !accessPolicy.getResource().equals(checkAccessPolicy.getResource()) || !accessPolicy.getAction().equals((Object)checkAccessPolicy.getAction())) continue;
            return true;
        }
        return false;
    }

    private boolean tenantExists(String identifier, String identity) {
        for (User user : this.getUsers()) {
            if (user.getIdentifier().equals(identifier) || !user.getIdentity().equals(identity)) continue;
            return true;
        }
        for (Group group : this.getGroups()) {
            if (group.getIdentifier().equals(identifier) || !group.getName().equals(identity)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final AuthorizationResult authorize(AuthorizationRequest request) throws AuthorizationAccessException {
        String resourceIdentifier;
        UsersAndAccessPolicies usersAndAccessPolicies = this.getUsersAndAccessPolicies();
        AccessPolicy policy = usersAndAccessPolicies.getAccessPolicy(resourceIdentifier = request.getResource().getIdentifier(), request.getAction());
        if (policy == null) {
            return AuthorizationResult.resourceNotFound();
        }
        User user = usersAndAccessPolicies.getUser(request.getIdentity());
        if (user == null) {
            return AuthorizationResult.denied(String.format("Unknown user with identity '%s'.", request.getIdentity()));
        }
        Set<Group> userGroups = usersAndAccessPolicies.getGroups(user.getIdentity());
        if (policy.getUsers().contains(user.getIdentifier()) || this.containsGroup(userGroups, policy)) {
            return AuthorizationResult.approved();
        }
        return AuthorizationResult.denied(request.getExplanationSupplier().get());
    }

    private boolean containsGroup(Set<Group> userGroups, AccessPolicy policy) {
        if (userGroups.isEmpty() || policy.getGroups().isEmpty()) {
            return false;
        }
        for (Group userGroup : userGroups) {
            if (!policy.getGroups().contains(userGroup.getIdentifier())) continue;
            return true;
        }
        return false;
    }

    public final synchronized Group addGroup(Group group) throws AuthorizationAccessException {
        if (this.tenantExists(group.getIdentifier(), group.getName())) {
            throw new IllegalStateException(String.format("User/user group already exists with the identity '%s'.", group.getName()));
        }
        return this.doAddGroup(group);
    }

    public abstract Group doAddGroup(Group var1) throws AuthorizationAccessException;

    public abstract Group getGroup(String var1) throws AuthorizationAccessException;

    public final synchronized Group updateGroup(Group group) throws AuthorizationAccessException {
        if (this.tenantExists(group.getIdentifier(), group.getName())) {
            throw new IllegalStateException(String.format("User/user group already exists with the identity '%s'.", group.getName()));
        }
        return this.doUpdateGroup(group);
    }

    public abstract Group doUpdateGroup(Group var1) throws AuthorizationAccessException;

    public abstract Group deleteGroup(Group var1) throws AuthorizationAccessException;

    public abstract Set<Group> getGroups() throws AuthorizationAccessException;

    public final synchronized User addUser(User user) throws AuthorizationAccessException {
        if (this.tenantExists(user.getIdentifier(), user.getIdentity())) {
            throw new IllegalStateException(String.format("User/user group already exists with the identity '%s'.", user.getIdentity()));
        }
        return this.doAddUser(user);
    }

    public abstract User doAddUser(User var1) throws AuthorizationAccessException;

    public abstract User getUser(String var1) throws AuthorizationAccessException;

    public abstract User getUserByIdentity(String var1) throws AuthorizationAccessException;

    public final synchronized User updateUser(User user) throws AuthorizationAccessException {
        if (this.tenantExists(user.getIdentifier(), user.getIdentity())) {
            throw new IllegalStateException(String.format("User/user group already exists with the identity '%s'.", user.getIdentity()));
        }
        return this.doUpdateUser(user);
    }

    public abstract User doUpdateUser(User var1) throws AuthorizationAccessException;

    public abstract User deleteUser(User var1) throws AuthorizationAccessException;

    public abstract Set<User> getUsers() throws AuthorizationAccessException;

    public final synchronized AccessPolicy addAccessPolicy(AccessPolicy accessPolicy) throws AuthorizationAccessException {
        if (this.policyExists(accessPolicy)) {
            throw new IllegalStateException(String.format("Found multiple policies for '%s' with '%s'.", new Object[]{accessPolicy.getResource(), accessPolicy.getAction()}));
        }
        return this.doAddAccessPolicy(accessPolicy);
    }

    protected abstract AccessPolicy doAddAccessPolicy(AccessPolicy var1) throws AuthorizationAccessException;

    public abstract AccessPolicy getAccessPolicy(String var1) throws AuthorizationAccessException;

    public abstract AccessPolicy updateAccessPolicy(AccessPolicy var1) throws AuthorizationAccessException;

    public abstract AccessPolicy deleteAccessPolicy(AccessPolicy var1) throws AuthorizationAccessException;

    public abstract Set<AccessPolicy> getAccessPolicies() throws AuthorizationAccessException;

    public abstract UsersAndAccessPolicies getUsersAndAccessPolicies() throws AuthorizationAccessException;

    public final void inheritFingerprint(String fingerprint) throws AuthorizationAccessException {
        if (fingerprint == null || fingerprint.trim().isEmpty()) {
            return;
        }
        byte[] fingerprintBytes = fingerprint.getBytes(StandardCharsets.UTF_8);
        try (ByteArrayInputStream in = new ByteArrayInputStream(fingerprintBytes);){
            DocumentBuilder docBuilder = DOCUMENT_BUILDER_FACTORY.newDocumentBuilder();
            Document document = docBuilder.parse(in);
            Element rootElement = document.getDocumentElement();
            NodeList userNodes = rootElement.getElementsByTagName(USER_ELEMENT);
            for (int i = 0; i < userNodes.getLength(); ++i) {
                Node userNode = userNodes.item(i);
                User user = this.parseUser((Element)userNode);
                this.addUser(user);
            }
            NodeList groupNodes = rootElement.getElementsByTagName(GROUP_ELEMENT);
            for (int i = 0; i < groupNodes.getLength(); ++i) {
                Node groupNode = groupNodes.item(i);
                Group group = this.parseGroup((Element)groupNode);
                this.addGroup(group);
            }
            NodeList policyNodes = rootElement.getElementsByTagName(POLICY_ELEMENT);
            for (int i = 0; i < policyNodes.getLength(); ++i) {
                Node policyNode = policyNodes.item(i);
                AccessPolicy policy = this.parsePolicy((Element)policyNode);
                this.addAccessPolicy(policy);
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new AuthorizationAccessException("Unable to parse fingerprint", e);
        }
    }

    private User parseUser(Element element) {
        User.Builder builder = new User.Builder().identifier(element.getAttribute(IDENTIFIER_ATTR)).identity(element.getAttribute(IDENTITY_ATTR));
        return builder.build();
    }

    private Group parseGroup(Element element) {
        Group.Builder builder = new Group.Builder().identifier(element.getAttribute(IDENTIFIER_ATTR)).name(element.getAttribute(NAME_ATTR));
        NodeList groupUsers = element.getElementsByTagName(GROUP_USER_ELEMENT);
        for (int i = 0; i < groupUsers.getLength(); ++i) {
            Element groupUserNode = (Element)groupUsers.item(i);
            builder.addUser(groupUserNode.getAttribute(IDENTIFIER_ATTR));
        }
        return builder.build();
    }

    private AccessPolicy parsePolicy(Element element) {
        AccessPolicy.Builder builder = new AccessPolicy.Builder().identifier(element.getAttribute(IDENTIFIER_ATTR)).resource(element.getAttribute(RESOURCE_ATTR));
        String actions = element.getAttribute(ACTIONS_ATTR);
        if (actions.equals(RequestAction.READ.name())) {
            builder.action(RequestAction.READ);
        } else if (actions.equals(RequestAction.WRITE.name())) {
            builder.action(RequestAction.WRITE);
        } else {
            throw new IllegalStateException("Unknown Policy Action: " + actions);
        }
        NodeList policyUsers = element.getElementsByTagName(POLICY_USER_ELEMENT);
        for (int i = 0; i < policyUsers.getLength(); ++i) {
            Element policyUserNode = (Element)policyUsers.item(i);
            builder.addUser(policyUserNode.getAttribute(IDENTIFIER_ATTR));
        }
        NodeList policyGroups = element.getElementsByTagName(POLICY_GROUP_ELEMENT);
        for (int i = 0; i < policyGroups.getLength(); ++i) {
            Element policyGroupNode = (Element)policyGroups.item(i);
            builder.addGroup(policyGroupNode.getAttribute(IDENTIFIER_ATTR));
        }
        return builder.build();
    }

    public final String getFingerprint() throws AuthorizationAccessException {
        List<User> users = this.getSortedUsers();
        List<Group> groups = this.getSortedGroups();
        List<AccessPolicy> policies = this.getSortedAccessPolicies();
        if (users.isEmpty() && groups.isEmpty() && policies.isEmpty()) {
            return EMPTY_FINGERPRINT;
        }
        XMLStreamWriter writer = null;
        StringWriter out = new StringWriter();
        try {
            writer = XML_OUTPUT_FACTORY.createXMLStreamWriter(out);
            writer.writeStartDocument();
            writer.writeStartElement("authorizations");
            for (User user : users) {
                this.writeUser(writer, user);
            }
            for (Group group : groups) {
                this.writeGroup(writer, group);
            }
            for (AccessPolicy policy : policies) {
                this.writePolicy(writer, policy);
            }
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.flush();
        }
        catch (XMLStreamException e) {
            throw new AuthorizationAccessException("Unable to generate fingerprint", e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (XMLStreamException xMLStreamException) {}
            }
        }
        return out.toString();
    }

    private void writeUser(XMLStreamWriter writer, User user) throws XMLStreamException {
        writer.writeStartElement(USER_ELEMENT);
        writer.writeAttribute(IDENTIFIER_ATTR, user.getIdentifier());
        writer.writeAttribute(IDENTITY_ATTR, user.getIdentity());
        writer.writeEndElement();
    }

    private void writeGroup(XMLStreamWriter writer, Group group) throws XMLStreamException {
        ArrayList<String> users = new ArrayList<String>(group.getUsers());
        Collections.sort(users);
        writer.writeStartElement(GROUP_ELEMENT);
        writer.writeAttribute(IDENTIFIER_ATTR, group.getIdentifier());
        writer.writeAttribute(NAME_ATTR, group.getName());
        for (String user : users) {
            writer.writeStartElement(GROUP_USER_ELEMENT);
            writer.writeAttribute(IDENTIFIER_ATTR, user);
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writePolicy(XMLStreamWriter writer, AccessPolicy policy) throws XMLStreamException {
        ArrayList<String> policyUsers = new ArrayList<String>(policy.getUsers());
        Collections.sort(policyUsers);
        ArrayList<String> policyGroups = new ArrayList<String>(policy.getGroups());
        Collections.sort(policyGroups);
        writer.writeStartElement(POLICY_ELEMENT);
        writer.writeAttribute(IDENTIFIER_ATTR, policy.getIdentifier());
        writer.writeAttribute(RESOURCE_ATTR, policy.getResource());
        writer.writeAttribute(ACTIONS_ATTR, policy.getAction().name());
        for (String policyUser : policyUsers) {
            writer.writeStartElement(POLICY_USER_ELEMENT);
            writer.writeAttribute(IDENTIFIER_ATTR, policyUser);
            writer.writeEndElement();
        }
        for (String policyGroup : policyGroups) {
            writer.writeStartElement(POLICY_GROUP_ELEMENT);
            writer.writeAttribute(IDENTIFIER_ATTR, policyGroup);
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private List<AccessPolicy> getSortedAccessPolicies() {
        ArrayList<AccessPolicy> policies = new ArrayList<AccessPolicy>(this.getAccessPolicies());
        Collections.sort(policies, new Comparator<AccessPolicy>(){

            @Override
            public int compare(AccessPolicy p1, AccessPolicy p2) {
                return p1.getIdentifier().compareTo(p2.getIdentifier());
            }
        });
        return policies;
    }

    private List<Group> getSortedGroups() {
        ArrayList<Group> groups = new ArrayList<Group>(this.getGroups());
        Collections.sort(groups, new Comparator<Group>(){

            @Override
            public int compare(Group g1, Group g2) {
                return g1.getIdentifier().compareTo(g2.getIdentifier());
            }
        });
        return groups;
    }

    private List<User> getSortedUsers() {
        ArrayList<User> users = new ArrayList<User>(this.getUsers());
        Collections.sort(users, new Comparator<User>(){

            @Override
            public int compare(User u1, User u2) {
                return u1.getIdentifier().compareTo(u2.getIdentifier());
            }
        });
        return users;
    }
}

