/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.event;

import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class Event {
    private final String source;
    private final long timestamp;
    private final Category category;
    private final String message;

    public Event(String source, String message) {
        this(source, message, Category.INFO);
    }

    public Event(String source, String message, Category category) {
        this(source, message, category, new Date().getTime());
    }

    public Event(String source, String message, long timestamp) {
        this(source, message, Category.INFO, timestamp);
    }

    public Event(String source, String message, Category category, long timestamp) {
        if (StringUtils.isBlank((CharSequence)source)) {
            throw new IllegalArgumentException("Source may not be empty or null.");
        }
        if (StringUtils.isBlank((CharSequence)message)) {
            throw new IllegalArgumentException("Event message may not be empty or null.");
        }
        if (category == null) {
            throw new IllegalArgumentException("Event category may not be null.");
        }
        if (timestamp < 0L) {
            throw new IllegalArgumentException("Timestamp may not be negative: " + timestamp);
        }
        this.source = source;
        this.message = message;
        this.category = category;
        this.timestamp = timestamp;
    }

    public Category getCategory() {
        return this.category;
    }

    public String getMessage() {
        return this.message;
    }

    public String getSource() {
        return this.source;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public static enum Category {
        DEBUG,
        INFO,
        WARN;

    }
}

