/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.flow.impl;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.UUID;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.nifi.cluster.flow.ClusterDataFlow;
import org.apache.nifi.cluster.flow.DaoException;
import org.apache.nifi.cluster.flow.DataFlowDao;
import org.apache.nifi.cluster.flow.PersistedFlowState;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.cluster.protocol.StandardDataFlow;
import org.apache.nifi.cluster.protocol.jaxb.message.NodeIdentifierAdapter;
import org.apache.nifi.logging.NiFiLog;
import org.apache.nifi.stream.io.BufferedInputStream;
import org.apache.nifi.stream.io.BufferedOutputStream;
import org.apache.nifi.stream.io.ByteArrayInputStream;
import org.apache.nifi.stream.io.StreamUtils;
import org.apache.nifi.util.file.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DataFlowDaoImpl
implements DataFlowDao {
    private final File primaryDirectory;
    private final File restoreDirectory;
    private final boolean autoStart;
    private final String generatedRootGroupId = UUID.randomUUID().toString();
    public static final String STALE_EXT = ".stale";
    public static final String UNKNOWN_EXT = ".unknown";
    public static final String FLOW_PACKAGE = "flow.tar";
    public static final String FLOW_XML_FILENAME = "flow.xml";
    public static final String TEMPLATES_FILENAME = "templates.xml";
    public static final String SNIPPETS_FILENAME = "snippets.xml";
    public static final String CONTROLLER_SERVICES_FILENAME = "controller-services.xml";
    public static final String REPORTING_TASKS_FILENAME = "reporting-tasks.xml";
    public static final String CLUSTER_INFO_FILENAME = "cluster-info.xml";
    private static final Logger logger = new NiFiLog(LoggerFactory.getLogger(DataFlowDaoImpl.class));

    public DataFlowDaoImpl(File primaryDirectory) throws DaoException {
        this(primaryDirectory, null, false);
    }

    public DataFlowDaoImpl(File primaryDirectory, File restoreDirectory, boolean autoStart) throws DaoException {
        if (primaryDirectory == null) {
            throw new IllegalArgumentException("Primary directory may not be null.");
        }
        if (!primaryDirectory.exists()) {
            if (!primaryDirectory.mkdir()) {
                throw new DaoException(String.format("Failed to create primary directory '%s'", primaryDirectory.getAbsolutePath()));
            }
        } else if (!primaryDirectory.isDirectory()) {
            throw new IllegalArgumentException("Primary directory must be a directory.");
        }
        this.autoStart = autoStart;
        try {
            this.primaryDirectory = primaryDirectory;
            this.restoreDirectory = restoreDirectory;
            if (restoreDirectory == null) {
                this.ensureSingleCurrentStateFile(primaryDirectory);
            } else {
                FileUtils.ensureDirectoryExistAndCanAccess((File)restoreDirectory);
                if (primaryDirectory.getAbsolutePath().equals(restoreDirectory.getAbsolutePath())) {
                    throw new IllegalArgumentException(String.format("Primary directory '%s' is the same as restore directory '%s' ", primaryDirectory.getAbsolutePath(), restoreDirectory.getAbsolutePath()));
                }
                File[] primaryFlowStateFiles = this.getFlowStateFiles(primaryDirectory);
                File[] restoreFlowStateFiles = this.getFlowStateFiles(restoreDirectory);
                if (primaryFlowStateFiles.length > 1) {
                    throw new IllegalStateException(String.format("Found multiple dataflow state files in primary directory '%s'", primaryDirectory));
                }
                if (restoreFlowStateFiles.length > 1) {
                    throw new IllegalStateException(String.format("Found multiple dataflow state files in restore directory '%s'", restoreDirectory));
                }
                File primaryFlowStateFile = this.ensureSingleCurrentStateFile(primaryDirectory);
                File restoreFlowStateFile = this.ensureSingleCurrentStateFile(restoreDirectory);
                if (restoreFlowStateFiles.length == 0 && primaryFlowStateFiles.length != 0) {
                    FileUtils.copyFile((File)primaryFlowStateFile, (File)restoreFlowStateFile, (boolean)false, (boolean)false, (Logger)logger);
                } else if (primaryFlowStateFiles.length == 0 && restoreFlowStateFiles.length != 0) {
                    FileUtils.copyFile((File)restoreFlowStateFile, (File)primaryFlowStateFile, (boolean)false, (boolean)false, (Logger)logger);
                } else {
                    this.syncWithRestore(primaryFlowStateFile, restoreFlowStateFile);
                }
            }
        }
        catch (IOException | IllegalArgumentException | IllegalStateException | JAXBException ex) {
            throw new DaoException(ex);
        }
    }

    private void syncWithRestore(File primaryFile, File restoreFile) throws IOException {
        try (FileInputStream primaryFis = new FileInputStream(primaryFile);
             TarArchiveInputStream primaryIn = new TarArchiveInputStream((InputStream)primaryFis);
             FileInputStream restoreFis = new FileInputStream(restoreFile);
             TarArchiveInputStream restoreIn = new TarArchiveInputStream((InputStream)restoreFis);){
            byte[] restoreMd5;
            ArchiveEntry primaryEntry = primaryIn.getNextEntry();
            ArchiveEntry restoreEntry = restoreIn.getNextEntry();
            if (primaryEntry == null && restoreEntry == null) {
                return;
            }
            if (primaryEntry == null && restoreEntry != null || primaryEntry != null && restoreEntry == null) {
                throw new IllegalStateException(String.format("Primary file '%s' is different than restore file '%s'", primaryFile.getAbsoluteFile(), restoreFile.getAbsolutePath()));
            }
            byte[] primaryMd5 = this.calculateMd5((InputStream)primaryIn);
            if (!Arrays.equals(primaryMd5, restoreMd5 = this.calculateMd5((InputStream)restoreIn))) {
                throw new IllegalStateException(String.format("Primary file '%s' is different than restore file '%s'", primaryFile.getAbsoluteFile(), restoreFile.getAbsolutePath()));
            }
        }
    }

    private byte[] calculateMd5(InputStream in) throws IOException {
        int len;
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new IOException(nsae);
        }
        byte[] buffer = new byte[8192];
        while ((len = in.read(buffer)) > -1) {
            if (len <= 0) continue;
            digest.update(buffer, 0, len);
        }
        return digest.digest();
    }

    @Override
    public ClusterDataFlow loadDataFlow() throws DaoException {
        try {
            return this.parseDataFlow(this.getExistingFlowStateFile(this.primaryDirectory));
        }
        catch (IOException | JAXBException ex) {
            throw new DaoException(ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void saveDataFlow(ClusterDataFlow dataFlow) throws DaoException {
        try {
            File primaryStateFile = this.getFlowStateFile(this.primaryDirectory);
            if (this.restoreDirectory != null) {
                File restoreStateFile = this.getFlowStateFile(this.restoreDirectory);
                if (restoreStateFile == null) {
                    if (primaryStateFile != null) throw new DaoException(String.format("Unable to save dataflow because dataflow state file in primary directory '%s' exists, but it does not exist in the restore directory '%s'", this.primaryDirectory.getAbsolutePath(), this.restoreDirectory.getAbsolutePath()));
                    this.writeDataFlow(this.createNewFlowStateFile(this.restoreDirectory), dataFlow);
                } else {
                    PersistedFlowState restoreFlowState;
                    if (primaryStateFile == null) {
                        throw new DaoException(String.format("Unable to save dataflow because dataflow state file in restore directory '%s' exists, but it does not exist in the primary directory '%s'", this.restoreDirectory.getAbsolutePath(), this.primaryDirectory.getAbsolutePath()));
                    }
                    PersistedFlowState primaryFlowState = this.getPersistedFlowState(primaryStateFile);
                    if (primaryFlowState != (restoreFlowState = this.getPersistedFlowState(restoreStateFile))) throw new DaoException(String.format("Unable to save dataflow because state file in primary directory '%s' has state '%s', but the state file in the restore directory '%s' has state '%s'", new Object[]{this.primaryDirectory.getAbsolutePath(), primaryFlowState, this.restoreDirectory.getAbsolutePath(), restoreFlowState}));
                    this.writeDataFlow(restoreStateFile, dataFlow);
                }
            }
            if (primaryStateFile == null) {
                this.writeDataFlow(this.createNewFlowStateFile(this.primaryDirectory), dataFlow);
                return;
            } else {
                this.writeDataFlow(primaryStateFile, dataFlow);
            }
            return;
        }
        catch (IOException | JAXBException ex) {
            throw new DaoException(ex);
        }
    }

    @Override
    public PersistedFlowState getPersistedFlowState() {
        if (this.restoreDirectory == null) {
            return this.getPersistedFlowState(this.getExistingFlowStateFile(this.primaryDirectory));
        }
        return this.getPersistedFlowState(this.getExistingFlowStateFile(this.restoreDirectory));
    }

    @Override
    public void setPersistedFlowState(PersistedFlowState flowState) throws DaoException {
        if (this.restoreDirectory != null) {
            this.renameFlowStateFile(this.getExistingFlowStateFile(this.restoreDirectory), flowState);
        }
        this.renameFlowStateFile(this.getExistingFlowStateFile(this.primaryDirectory), flowState);
    }

    private File ensureSingleCurrentStateFile(File dir) throws IOException, JAXBException {
        File[] directoryFlowStateFiles = this.getFlowStateFiles(dir);
        if (directoryFlowStateFiles.length > 1) {
            throw new DaoException(String.format("Found multiple dataflow state files in directory '%s'", dir));
        }
        if (directoryFlowStateFiles.length == 0) {
            return this.createNewFlowStateFile(dir);
        }
        PersistedFlowState flowState = this.getPersistedFlowState(directoryFlowStateFiles[0]);
        if (PersistedFlowState.CURRENT == flowState) {
            return directoryFlowStateFiles[0];
        }
        throw new DaoException(String.format("Dataflow state file '%s' must be current.", directoryFlowStateFiles[0].getAbsolutePath()));
    }

    private PersistedFlowState getPersistedFlowState(File file) {
        String path = file.getAbsolutePath();
        if (path.endsWith(STALE_EXT)) {
            return PersistedFlowState.STALE;
        }
        if (path.endsWith(UNKNOWN_EXT)) {
            return PersistedFlowState.UNKNOWN;
        }
        return PersistedFlowState.CURRENT;
    }

    private File getFlowStateFile(File dir) {
        File[] files = this.getFlowStateFiles(dir);
        if (files.length > 1) {
            throw new IllegalStateException(String.format("Expected at most one dataflow state file, but found %s files.", files.length));
        }
        if (files.length == 0) {
            return null;
        }
        return files[0];
    }

    private File getExistingFlowStateFile(File dir) {
        File file = this.getFlowStateFile(dir);
        if (file == null) {
            throw new IllegalStateException(String.format("Expected a dataflow state file, but none existed in directory '%s'", dir.getAbsolutePath()));
        }
        return file;
    }

    private File[] getFlowStateFiles(File dir) {
        File[] files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.equals(DataFlowDaoImpl.FLOW_PACKAGE) || name.endsWith(DataFlowDaoImpl.STALE_EXT) || name.endsWith(DataFlowDaoImpl.UNKNOWN_EXT);
            }
        });
        if (files == null) {
            return new File[0];
        }
        return files;
    }

    private File removeStateFileExtension(File file) {
        String path = file.getAbsolutePath();
        int stateFileExtIndex = path.endsWith(STALE_EXT) ? path.lastIndexOf(STALE_EXT) : (path.endsWith(UNKNOWN_EXT) ? path.lastIndexOf(UNKNOWN_EXT) : path.length());
        return new File(path.substring(0, stateFileExtIndex));
    }

    private File addStateFileExtension(File file, PersistedFlowState state) {
        switch (state) {
            case CURRENT: {
                return file;
            }
            case STALE: {
                return new File(file.getAbsolutePath() + STALE_EXT);
            }
            case UNKNOWN: {
                return new File(file.getAbsolutePath() + UNKNOWN_EXT);
            }
        }
        throw new RuntimeException("Unsupported PersistedFlowState Enum value: " + (Object)((Object)state));
    }

    private File createNewFlowStateFile(File dir) throws IOException, JAXBException {
        File stateFile = new File(dir, FLOW_PACKAGE);
        stateFile.createNewFile();
        this.writeDataFlow(stateFile, new ClusterDataFlow(null, null, new byte[0], new byte[0]), new ClusterMetadata());
        return stateFile;
    }

    private byte[] getEmptyFlowBytes() throws IOException {
        try {
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = docBuilder.newDocument();
            Element controller = document.createElement("flowController");
            document.appendChild(controller);
            controller.appendChild(this.createTextElement(document, "maxThreadCount", "15"));
            Element rootGroup = document.createElement("rootGroup");
            rootGroup.appendChild(this.createTextElement(document, "id", this.generatedRootGroupId));
            rootGroup.appendChild(this.createTextElement(document, "name", "NiFi Flow"));
            Element positionElement = this.createTextElement(document, "position", "");
            positionElement.setAttribute("x", "0.0");
            positionElement.setAttribute("y", "0.0");
            rootGroup.appendChild(positionElement);
            rootGroup.appendChild(this.createTextElement(document, "comment", ""));
            controller.appendChild(rootGroup);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(document);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(baos);
            transformer.transform(source, result);
            return baos.toByteArray();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private Element createTextElement(Document document, String elementName, String value) {
        Element element = document.createElement(elementName);
        element.setTextContent(value);
        return element;
    }

    private void renameFlowStateFile(File flowStateFile, PersistedFlowState newState) throws DaoException {
        File newFlowStateFile;
        PersistedFlowState existingState = this.getPersistedFlowState(flowStateFile);
        if (existingState != newState && !flowStateFile.renameTo(newFlowStateFile = this.addStateFileExtension(this.removeStateFileExtension(flowStateFile), newState))) {
            throw new DaoException(String.format("Failed to rename flow state file '%s' to new name '%s'", flowStateFile.getAbsolutePath(), newFlowStateFile.getAbsolutePath()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ClusterDataFlow parseDataFlow(File file) throws IOException, JAXBException, DaoException {
        NodeIdentifier nodeIdentifier;
        ClusterMetadata clusterMetadata;
        byte[] flowBytes = new byte[]{};
        byte[] templateBytes = new byte[]{};
        byte[] snippetBytes = new byte[]{};
        byte[] clusterInfoBytes = new byte[]{};
        byte[] controllerServiceBytes = new byte[]{};
        byte[] reportingTaskBytes = new byte[]{};
        try (FileInputStream inStream = new FileInputStream(file);
             TarArchiveInputStream tarIn = new TarArchiveInputStream((InputStream)new BufferedInputStream((InputStream)inStream));){
            TarArchiveEntry tarEntry;
            block34: while ((tarEntry = tarIn.getNextTarEntry()) != null) {
                switch (tarEntry.getName()) {
                    case "flow.xml": {
                        flowBytes = new byte[(int)tarEntry.getSize()];
                        StreamUtils.fillBuffer((InputStream)tarIn, (byte[])flowBytes, (boolean)true);
                        continue block34;
                    }
                    case "templates.xml": {
                        templateBytes = new byte[(int)tarEntry.getSize()];
                        StreamUtils.fillBuffer((InputStream)tarIn, (byte[])templateBytes, (boolean)true);
                        continue block34;
                    }
                    case "snippets.xml": {
                        snippetBytes = new byte[(int)tarEntry.getSize()];
                        StreamUtils.fillBuffer((InputStream)tarIn, (byte[])snippetBytes, (boolean)true);
                        continue block34;
                    }
                    case "cluster-info.xml": {
                        clusterInfoBytes = new byte[(int)tarEntry.getSize()];
                        StreamUtils.fillBuffer((InputStream)tarIn, (byte[])clusterInfoBytes, (boolean)true);
                        continue block34;
                    }
                    case "controller-services.xml": {
                        controllerServiceBytes = new byte[(int)tarEntry.getSize()];
                        StreamUtils.fillBuffer((InputStream)tarIn, (byte[])controllerServiceBytes, (boolean)true);
                        continue block34;
                    }
                    case "reporting-tasks.xml": {
                        reportingTaskBytes = new byte[(int)tarEntry.getSize()];
                        StreamUtils.fillBuffer((InputStream)tarIn, (byte[])reportingTaskBytes, (boolean)true);
                        continue block34;
                    }
                }
                throw new DaoException("Found Unexpected file in dataflow configuration: " + tarEntry.getName());
            }
        }
        if (clusterInfoBytes.length == 0) {
            clusterMetadata = null;
        } else {
            Unmarshaller clusterMetadataUnmarshaller = ClusterMetadata.jaxbCtx.createUnmarshaller();
            clusterMetadata = (ClusterMetadata)clusterMetadataUnmarshaller.unmarshal((InputStream)new ByteArrayInputStream(clusterInfoBytes));
        }
        StandardDataFlow dataFlow = new StandardDataFlow(flowBytes, templateBytes, snippetBytes);
        dataFlow.setAutoStartProcessors(this.autoStart);
        if (clusterMetadata == null) {
            nodeIdentifier = null;
            return new ClusterDataFlow(dataFlow, nodeIdentifier, controllerServiceBytes, reportingTaskBytes);
        }
        nodeIdentifier = clusterMetadata.getPrimaryNodeId();
        return new ClusterDataFlow(dataFlow, nodeIdentifier, controllerServiceBytes, reportingTaskBytes);
    }

    private void writeDataFlow(File file, ClusterDataFlow clusterDataFlow) throws IOException, JAXBException {
        StandardDataFlow dataFlow = clusterDataFlow.getDataFlow();
        if (dataFlow == null) {
            dataFlow = new StandardDataFlow(new byte[0], new byte[0], new byte[0]);
        }
        ClusterMetadata clusterMetadata = new ClusterMetadata();
        clusterMetadata.setPrimaryNodeId(clusterDataFlow.getPrimaryNodeId());
        this.writeDataFlow(file, clusterDataFlow, clusterMetadata);
    }

    private void writeTarEntry(TarArchiveOutputStream tarOut, String filename, byte[] bytes) throws IOException {
        TarArchiveEntry flowEntry = new TarArchiveEntry(filename);
        flowEntry.setSize((long)bytes.length);
        tarOut.putArchiveEntry((ArchiveEntry)flowEntry);
        tarOut.write(bytes);
        tarOut.closeArchiveEntry();
    }

    private void writeDataFlow(File file, ClusterDataFlow clusterDataFlow, ClusterMetadata clusterMetadata) throws IOException, JAXBException {
        try (FileOutputStream fos = new FileOutputStream(file);
             TarArchiveOutputStream tarOut = new TarArchiveOutputStream((OutputStream)new BufferedOutputStream((OutputStream)fos));){
            StandardDataFlow dataFlow = clusterDataFlow.getDataFlow();
            if (dataFlow == null) {
                this.writeTarEntry(tarOut, FLOW_XML_FILENAME, this.getEmptyFlowBytes());
                this.writeTarEntry(tarOut, TEMPLATES_FILENAME, new byte[0]);
                this.writeTarEntry(tarOut, SNIPPETS_FILENAME, new byte[0]);
            } else {
                this.writeTarEntry(tarOut, FLOW_XML_FILENAME, dataFlow.getFlow());
                this.writeTarEntry(tarOut, TEMPLATES_FILENAME, dataFlow.getTemplates());
                this.writeTarEntry(tarOut, SNIPPETS_FILENAME, dataFlow.getSnippets());
            }
            this.writeTarEntry(tarOut, CONTROLLER_SERVICES_FILENAME, clusterDataFlow.getControllerServices());
            this.writeTarEntry(tarOut, REPORTING_TASKS_FILENAME, clusterDataFlow.getReportingTasks());
            ByteArrayOutputStream baos = new ByteArrayOutputStream(256);
            this.writeClusterMetadata(clusterMetadata, baos);
            byte[] clusterInfoBytes = baos.toByteArray();
            this.writeTarEntry(tarOut, CLUSTER_INFO_FILENAME, clusterInfoBytes);
        }
    }

    private void writeClusterMetadata(ClusterMetadata clusterMetadata, OutputStream os) throws IOException, JAXBException {
        Marshaller marshaller = ClusterMetadata.jaxbCtx.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.setProperty("jaxb.fragment", (Object)true);
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.marshal((Object)clusterMetadata, os);
    }

    @XmlRootElement(name="clusterMetadata")
    private static class ClusterMetadata {
        private NodeIdentifier primaryNodeId;
        private static final JAXBContext jaxbCtx;

        private ClusterMetadata() {
        }

        @XmlJavaTypeAdapter(value=NodeIdentifierAdapter.class)
        public NodeIdentifier getPrimaryNodeId() {
            return this.primaryNodeId;
        }

        public void setPrimaryNodeId(NodeIdentifier primaryNodeId) {
            this.primaryNodeId = primaryNodeId;
        }

        static {
            try {
                jaxbCtx = JAXBContext.newInstance((Class[])new Class[]{ClusterMetadata.class});
            }
            catch (JAXBException je) {
                throw new RuntimeException(je);
            }
        }
    }
}

