/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.node;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.nifi.cluster.HeartbeatPayload;
import org.apache.nifi.cluster.protocol.Heartbeat;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.cluster.protocol.ProtocolException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Node
implements Cloneable,
Comparable<Node> {
    private static final Logger lockLogger = LoggerFactory.getLogger((String)"cluster.lock");
    private final NodeIdentifier nodeId;
    private Status status;
    private Heartbeat lastHeartbeat;
    private HeartbeatPayload lastHeartbeatPayload;
    private AtomicLong connectionRequestedTimestamp = new AtomicLong(0L);
    private boolean heartbeatDisconnection;

    public Node(NodeIdentifier id, Status status) {
        if (id == null) {
            throw new IllegalArgumentException("ID may not be null.");
        }
        if (status == null) {
            throw new IllegalArgumentException("Status may not be null.");
        }
        this.nodeId = id;
        this.status = status;
    }

    public NodeIdentifier getNodeId() {
        return this.nodeId;
    }

    public Heartbeat getHeartbeat() {
        return this.lastHeartbeat;
    }

    public HeartbeatPayload getHeartbeatPayload() {
        return this.lastHeartbeatPayload;
    }

    public void setHeartbeat(Heartbeat heartbeat) throws ProtocolException {
        byte[] payload;
        this.lastHeartbeat = heartbeat;
        this.lastHeartbeatPayload = this.lastHeartbeat == null ? null : ((payload = this.lastHeartbeat.getPayload()) == null || payload.length == 0 ? null : HeartbeatPayload.unmarshal((byte[])payload));
    }

    public long getConnectionRequestedTimestamp() {
        return this.connectionRequestedTimestamp.get();
    }

    public void setConnectionRequestedTimestamp(long connectionRequestedTimestamp) {
        this.connectionRequestedTimestamp.set(connectionRequestedTimestamp);
    }

    public boolean isHeartbeatDisconnection() {
        return this.heartbeatDisconnection;
    }

    public void setHeartbeatDisconnection() {
        this.setStatus(Status.DISCONNECTED);
        this.heartbeatDisconnection = true;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        if (status == null) {
            throw new IllegalArgumentException("Status may not be null.");
        }
        this.status = status;
        this.heartbeatDisconnection = false;
    }

    public Node clone() {
        Node clone = new Node(this.nodeId, this.status);
        clone.lastHeartbeat = this.lastHeartbeat;
        clone.lastHeartbeatPayload = this.lastHeartbeatPayload;
        clone.heartbeatDisconnection = this.heartbeatDisconnection;
        clone.connectionRequestedTimestamp = this.connectionRequestedTimestamp;
        return clone;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Node other = (Node)obj;
        return this.nodeId == other.nodeId || this.nodeId != null && this.nodeId.equals((Object)other.nodeId);
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + (this.nodeId != null ? this.nodeId.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return this.nodeId.toString();
    }

    @Override
    public int compareTo(Node o) {
        if (o == null) {
            return -1;
        }
        return this.getNodeId().getId().compareTo(o.getNodeId().getId());
    }

    public static enum Status {
        CONNECTED,
        CONNECTING,
        DISCONNECTED,
        DISCONNECTING;

    }
}

